<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   3.10.0
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

/**
 * Fixes content variable filter for catid, id and sectionid variables
 */

$db =& JFactory::getDBO();

$oldFilter = '+^[0-9]+(:[a-zA-Z._-]+)?$=catid,id,sectionid';
$newFilter = '+^[0-9]+(:[a-zA-Z0-9._-]+)?$=catid,id,sectionid';

// Get the content extension
$db->setQuery("SELECT `id`, `filters` FROM `#__sefexts` WHERE `file` = 'com_content.xml' LIMIT 1");
$content = $db->loadObject();
if (is_null($content)) {
    return;
}

// Fix the filter
$content->filters = str_replace($oldFilter, $newFilter, $content->filters);

// Store changes
$db->setQuery("UPDATE `#__sefexts` SET `filters` = ".$db->Quote($content->filters)." WHERE `id` = '{$content->id}' LIMIT 1");
$db->query();

?>