<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

$jfrouterLink = JText::_('COM_SEF_JFROUTER_PLUGIN');
if (SEFTools::JoomFishInstalled()) {
    $db =& JFactory::getDBO();
    $db->setQuery("SELECT `id` FROM `#__plugins` WHERE `folder` = 'system' AND `element` = 'jfrouter' LIMIT 1");
    $jfrouterId = $db->loadResult();
    if (!is_null($jfrouterId)) {
        $jfrouterLink = '<a href="index.php?option=com_plugins&view=plugin&client=site&task=edit&cid[]='.$jfrouterId.'">'.$jfrouterLink.'</a>';
    }
}
?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
<table class="adminheading">
		<tr><th>		
        <?php
		$config =& JFactory::getConfig();
		$sefConfig =& SEFConfig::getConfig();
		$lists = $this->lists;
		$sef_config_file = JPATH_COMPONENT . DS . 'configuration.php';
		echo 'ARTIO JoomSEF ' . JText::_('COM_SEF_CONFIGURATION_FILE') . (file_exists($sef_config_file) ? (is_writable($sef_config_file) ? (' <b><font color="green">'.JText::_('COM_SEF_WRITEABLE').'</font></b>') : (' <b><font color="red">'.JText::_('COM_SEF_UNWRITEABLE').'</font></b>')) : (' <b><font color="red">'.JText::_('COM_SEF_USING_DEFAULT_VALUES').'</font></b>'));
		?>		
		</th></tr>
		</table>
		<?php if (!$config->getValue('sef')) {
			JError::raiseNotice('100', JText::sprintf('INFO_SEF_DISABLED', '<a href="index.php?option=com_config">', '</a>'));
		}
		$x = 0;
	    ?>
	    <script language="Javascript">
	    Joomla.submitbutton = function(pressbutton) {
	        <?php
	        jimport( 'joomla.html.editor' );
	        $editor =& JFactory::getEditor();
	        echo $editor->save('introtext');
	        ?>
	        Joomla.submitform(pressbutton);
	    }
	    
	    function addMetaTag() {
	        var tbl = document.getElementById('tblMetatags');
	        if( !tbl ) {
	            return;
	        }
	        var tbody = tbl.getElementsByTagName('tbody')[0];
	        if( !tbody ) {
	            return;
	        }
	        
	        var row = document.createElement('tr');
	        var td1 = document.createElement('td');
	        td1.width = '200';
	        td1.innerHTML = '<input type="text" value="" size="40" name="metanames[]" />';
	        var td2 = document.createElement('td');
	        td2.width = '200';
	        td2.innerHTML = '<input type="text" value="" size="60" name="metacontents[]" />';
	        var td3 = document.createElement('td');
	        td3.innerHTML = '<input type="button" value="<?php echo JText::_('COM_SEF_REMOVE_META_TAG'); ?>" onclick="removeMetaTag(this);" />';
	        row.appendChild(td1);
	        row.appendChild(td2);
	        row.appendChild(td3);
	        tbody.appendChild(row);
	    }
	    
	    function removeMetaTag(el) {
	        var tbl = document.getElementById('tblMetatags');
	        if( !tbl ) {
	            return;
	        }
	        var tbody = tbl.getElementsByTagName('tbody')[0];
	        if( !tbody ) {
	            return;
	        }

	        while( el ) {
	            if( el.nodeName && (el.nodeName.toLowerCase() == 'tr') ) {
	                break;
	            }
	            el = el.parentNode;
	        }
	        
	        if( el.nodeName && (el.nodeName.toLowerCase() == 'tr') ) {
	           tbody.removeChild(el);
	        }
	    }

        function enableStatus(type)
        {
            var form = document.adminForm;
            if( !form ) {
                return;
            }
            
            form.statusType.value = type;
            submitbutton('enableStatus');
        }
        
        function disableStatus(type)
        {
            var form = document.adminForm;
            if( !form ) {
                return;
            }
            
            form.statusType.value = type;
            submitbutton('disableStatus');
        }
	    </script>
		
		<?php
		if (!is_null($this->tab)) {
		    JRequest::setVar('jpanetabs_sef-config-tabs', null, 'cookie');
		}
		echo JHtml::_('tabs.start', 'sef-config-tabs', array('startOffset' => $this->tab, 'useCookie' => 1));
		echo JHtml::_('tabs.panel', JText::_('COM_SEF_BASIC'), 'basic');
		?>
		
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_BASIC_CONFIGURATION'); ?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_JOOMSEF_ENABLED'),JText::_('COM_SEF_ENABLED'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_JOOMSEF_ENABLED');?>?</td>
    	            <td><?php echo $lists['enabled'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_DISABLE_NEW_SEF'),JText::_('COM_SEF_DISABLE_CREATION_OF_NEW_SEF_URLS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_DISABLE_CREATION_OF_NEW_SEF_URLS');?></td>
    	            <td><?php echo $lists['disableNewSEF']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_NUMBER_DUPLICATES'),JText::_('COM_SEF_NUMBER_DUPLICATE_URLS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_NUMBER_DUPLICATE_URLS');?></td>
    	            <td><?php echo $lists['numberDuplicates']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_REPLACE_CHAR'),JText::_('COM_SEF_REPLACE_CHAR'));?></td>
    	            <td><?php echo JText::_('COM_SEF_REPLACE_CHAR');?></td>
    	            <td><input type="text" name="replacement" value="<?php echo $sefConfig->replacement;?>" size="1" maxlength="1"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_PAGE_SEP_CHAR'),JText::_('COM_SEF_PAGE_SEP_CHAR'));?></td>
    	            <td><?php echo JText::_('COM_SEF_PAGE_SEP_CHAR');?></td>
    	            <td><input type="text" name="pagerep" value="<?php echo $sefConfig->pagerep;?>" size="1" maxlength="1"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_STRIP_CHAR'),JText::_('COM_SEF_STRIP_CHAR'));?></td>
    	            <td><?php echo JText::_('COM_SEF_STRIP_CHAR');?></td>
    	            <td><input type="text" name="stripthese" value="<?php echo $sefConfig->stripthese;?>" size="60" maxlength="255"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_FRIEND_TRIM_CHAR'),JText::_('COM_SEF_TRIM_FRIEND_TRIM_CHAR'));?></td>
    	            <td><?php echo JText::_('COM_SEF_TRIM_FRIEND_TRIM_CHAR');?></td>
    	            <td><input type="text" name="friendlytrim" value="<?php echo $sefConfig->friendlytrim;?>" size="60" maxlength="255"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_ALIAS'),JText::_('COM_SEF_USE_TITLE_ALIAS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_USE_ALIAS');?></td>
    	            <td><?php echo $lists['useAlias'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_SUFFIX'),JText::_('COM_SEF_SUFFIX'));?></td>
    	            <td><?php echo JText::_('COM_SEF_SUFFIX');?></td>
    	            <td><input type="text" name="suffix" value="<?php echo $sefConfig->suffix; ?>" size="10" maxlength="6"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_ADD_FILE'),JText::_('COM_SEF_ADD_FILE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_ADD_FILE');?></td>
    	            <td><input type="text" name="addFile" value="<?php echo $sefConfig->addFile; ?>" size="60" maxlength="60"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_PAGE_TEXT'),JText::_('COM_SEF_PAGE_TEXT'));?></td>
    	            <td><?php echo JText::_('COM_SEF_PAGE_TEXT');?></td>
    	            <td><input type="text" name="pagetext" value="<?php echo $sefConfig->pagetext; ?>" size="30" maxlength="30"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_LOWERCASE'),JText::_('COM_SEF_ALL_LOWERCASE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_ALL_LOWERCASE');?>?</td>
    	            <td><?php echo $lists['lowerCase'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_SEC_CAT_INDEX'),JText::_('COM_SEF_USE_INDEX_FILE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_USE_SEC_CAT_INDEX');?></td>
    	            <td><?php echo $lists['contentUseIndex']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_WWW_HANDLING'),JText::_('COM_SEF_WWW_HANDLING'));?></td>
    	            <td><?php echo JText::_('COM_SEF_WWW_HANDLING');?></td>
    	            <td><?php echo $lists['wwwHandling']; ?></td>
    	        </tr>
		      </table>
		  </fieldset>
		  
		  <?php
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_ADVANCED'), 'advanced');
		  ?>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_ADVANCED_CONFIGURATION');?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20" valign="top"><?php echo $this->tooltip(JText::_('COM_SEF_TT_ALLOW_UTF'), JText::_('COM_SEF_ALLOW_UTF'));?></td>
    	            <td width="200" valign="top"><?php echo JText::_('COM_SEF_ALLOW_UTF');?></td>
    	            <td><?php echo $lists['allowUTF'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td valign="top"><?php echo $this->tooltip(JText::_('COM_SEF_TT_REPLACEMENTS'), JText::_('COM_SEF_REPLACEMENTS'));?></td>
    	            <td valign="top"><?php echo JText::_('COM_SEF_REPLACEMENTS');?></td>
    	            <td><textarea name="replacements" cols="40" rows="5"><?php echo $sefConfig->replacements;?></textarea></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_EXCLUDE_SOURCE'), JText::_('COM_SEF_EXCLUDE_SOURCE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_EXCLUDE_SOURCE');?></td>
    	            <td><?php echo $lists['excludeSource'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_REAPPEND_SOURCE'), JText::_('COM_SEF_REAPPEND_SOURCE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_REAPPEND_SOURCE');?></td>
    	            <td><?php echo $lists['reappendSource'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_IGNORE_SOURCE'), JText::_('COM_SEF_IGNORE_MULTIPLE_SOURCES'));?></td>
    	            <td><?php echo JText::_('COM_SEF_IGNORE_MULTIPLE_SOURCES');?></td>
    	            <td><?php echo $lists['ignoreSource'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_APPEND_NONSEF'), JText::_('COM_SEF_APPEND_NONSEF'));?></td>
    	            <td><?php echo JText::_('COM_SEF_APPEND_NONSEF');?></td>
    	            <td><?php echo $lists['appendNonSef'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_TRANSIT_SLASH'), JText::_('COM_SEF_BE_TOLERANT_TO_TRAILING_SLASH'));?></td>
    	            <td><?php echo JText::_('COM_SEF_BE_TOLERANT_TO_TRAILING_SLASH');?></td>
    	            <td><?php echo $lists['transitSlash'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	        	<td><?php echo $this->tooltip(JText::_('COM_SEF_TT_REDIRECT_SLASH'),JText::_('COM_SEF_REDIRECT_SLASH')); ?></td>
    	        	<td><?php echo JText::_('COM_SEF_REDIRECT_SLASH'); ?></td>
    	        	<td><?php echo $lists['redirectSlash']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_NONSEF_REDIRECT'), JText::_('COM_SEF_REDIRECT_NONSEF_URLS_TO_SEF'));?></td>
    	            <td><?php echo JText::_('COM_SEF_REDIRECT_NONSEF_URLS_TO_SEF');?></td>
    	            <td><?php echo $lists['nonSefRedirect'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_MOVED'), JText::_('COM_SEF_USE_MOVED_PERMANENTLY_REDIRECTION_TABLE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_USE_MOVED_PERMANENTLY_REDIRECTION_TABLE');?></td>
    	            <td><?php echo $lists['useMoved'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_MOVED_ASK'), JText::_('COM_SEF_ASK_BEFORE_SAVING_URL_TO_MOVED_PERMANENTLY_TABLE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_ASK_BEFORE_SAVING_URL_TO_MOVED_PERMANENTLY_TABLE');?></td>
    	            <td><?php echo $lists['useMovedAsk'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_DONT_REMOVE_SID'), JText::_('COM_SEF_DO_NOT_REMOVE_SID_FROM_SEF_URL'));?></td>
    	            <td><?php echo JText::_('COM_SEF_DO_NOT_REMOVE_SID_FROM_SEF_URL');?></td>
    	            <td><?php echo $lists['dontRemoveSid'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_SET_QUERY_STRING'), JText::_('COM_SEF_SET_SERVER_QUERY_STRING'));?></td>
    	            <td><?php echo JText::_('COM_SEF_SET_SERVER_QUERY_STRING');?></td>
    	            <td><?php echo $lists['setQueryString'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_PARSE_JOOMLA_SEO'), JText::_('COM_SEF_PARSE_JOOMLA_SEO_LINKS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_PARSE_JOOMLA_SEO_LINKS');?></td>
    	            <td><?php echo $lists['parseJoomlaSEO'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CHECK_JUNK_URLS'), JText::_('COM_SEF_FILTER_VARIABLE_VALUES'));?></td>
    	            <td><?php echo JText::_('COM_SEF_FILTER_VARIABLE_VALUES');?></td>
    	            <td><?php echo $lists['checkJunkUrls'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JUNK_WORDS'), JText::_('COM_SEF_FILTER_THESE_WORDS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_FILTER_THESE_WORDS');?>:</td>
    	            <td><?php echo $lists['junkWords'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JUNK_EXCLUDE'), JText::_('COM_SEF_JUNK_EXCLUDE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_JUNK_EXCLUDE');?>:</td>
    	            <td><?php echo $lists['junkExclude'];?></td>
    	        </tr>
                <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
                    <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_GLOBAL_FILTERS'), JText::_('COM_SEF_FILTER_SYSTEM_VARIABLES'));?></td>
                    <td><?php echo JText::_('COM_SEF_FILTER_SYSTEM_VARIABLES');?>:</td>
                    <td><?php echo $lists['useGlobalFilters']; ?></td>
                </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_PREVENT_NONSEF_OVERWRITE'), JText::_('COM_SEF_PREVENT_NONSEF_OVERWRITE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_PREVENT_NONSEF_OVERWRITE');?>:</td>
    	            <td><?php echo $lists['preventNonSefOverwrite'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CUSTOM_NONSEF'), JText::_('COM_SEF_CUSTOM_NONSEF'));?></td>
    	            <td><?php echo JText::_('COM_SEF_CUSTOM_NONSEF');?>:</td>
    	            <td><input type="text" name="customNonSef" value="<?php echo $sefConfig->customNonSef; ?>" size="60"></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_AUTO_CANONICAL'), JText::_('COM_SEF_AUTO_CANONICAL'));?></td>
    	            <td><?php echo JText::_('COM_SEF_AUTO_CANONICAL');?>:</td>
    	            <td><?php echo $lists['autoCanonical']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_SEF_COMPONENT_URLS'), JText::_('COM_SEF_SEF_COMPONENT_TEMPLATE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_SEF_COMPONENT_TEMPLATE');?>:</td>
    	            <td><?php echo $lists['sefComponentUrls']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CHECK_BASE_HREF'), JText::_('COM_SEF_SET_PAGE_BASE_HREF_VALUE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_SET_PAGE_BASE_HREF_VALUE');?>:</td>
    	            <td><?php echo $lists['check_base_href']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_FIX_INDEX_PHP'), JText::_('COM_SEF_FIX_INDEXPHP_LINKS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_FIX_INDEXPHP_LINKS');?>:</td>
    	            <td><?php echo $lists['fixIndexPhp']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_FIX_DOCUMENT_FORMAT'), JText::_('COM_SEF_FIX_DOCUMENT_FORMAT'));?></td>
    	            <td><?php echo JText::_('COM_SEF_FIX_DOCUMENT_FORMAT');?>:</td>
    	            <td><?php echo $lists['fixDocumentFormat']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	        	<td><?php echo $this->tooltip(JText::_('COM_SEF_TT_AUTOLOCK_URLS'),JText::_('COM_SEF_AUTOLOCK_URLS')); ?></td>
    	        	<td><?php echo Jtext::_('COM_SEF_AUTOLOCK_URLS'); ?>:</td>
    	        	<td><?php echo $lists['autolock_urls']; ?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	        	<td><?php echo $this->tooltip(JText::_('COM_SEF_TT_AUTO_UPDATE_URLS'),JText::_('COM_SEF_AUTO_UPDATE_URLS')); ?></td>
    	        	<td><?php echo Jtext::_('COM_SEF_AUTO_UPDATE_URLS'); ?>:</td>
    	        	<td><?php echo $lists['update_urls']; ?></td>
    	        </tr>
    	        </table>
		    </fieldset>
    	        
			<fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_URL_SOURCE_TRACING');?></legend>
		      <table class="adminform">    	        
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20" valign="top"><?php echo $this->tooltip(JText::_('COM_SEF_TT_TRACE'), JText::_('COM_SEF_TRACE_URL_SOURCE'));?></td>
    	            <td width="200" valign="top"><?php echo JText::_('COM_SEF_ENABLE_URL_SOURCE_TRACING');?></td>
    	            <td><?php echo $lists['trace'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_TRACE_DEPTH'), JText::_('COM_SEF_TRACING_DEPTH'));?></td>
    	            <td><?php echo JText::_('COM_SEF_TRACING_DEPTH');?>:</td>
    	            <td><?php echo $lists['traceLevel'];?></td>
    	        </tr>
		      </table>
		  </fieldset>
		  
		  <?php
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_CACHE'), 'cache');
		  ?>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_CACHE_CONFIGURATION');?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_CACHE'), JText::_('COM_SEF_USE_CACHE'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_USE_CACHE');?></td>
    	            <td><?php echo $lists['useCache'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CACHE_SIZE'), JText::_('COM_SEF_MAXIMUM_CACHE_SIZE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_MAXIMUM_CACHE_SIZE');?>:</td>
    	            <td><?php echo $lists['cacheSize'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CACHE_HITS'), JText::_('COM_SEF_MINIMUM_CACHE_HITS_COUNT'));?></td>
    	            <td><?php echo JText::_('COM_SEF_MINIMUM_CACHE_HITS_COUNT');?>:</td>
    	            <td><?php echo $lists['cacheMinHits'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CACHE_RECORDHITS'), JText::_('COM_SEF_RECORD_HITS_FOR_CACHED_URLS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_RECORD_HITS_FOR_CACHED_URLS');?>:</td>
    	            <td><?php echo $lists['cacheRecordHits'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_CACHE_SHOWERR'), JText::_('COM_SEF_DISPLAY_CACHE_CORRUPTED_ERROR'));?></td>
    	            <td><?php echo JText::_('COM_SEF_DISPLAY_CACHE_CORRUPTED_ERROR');?>:</td>
    	            <td><?php echo $lists['cacheShowErr'];?></td>
    	        </tr>
		      </table>
		  </fieldset>

		  <?php
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_TITLE_AND_META_TAGS'), 'metatags');
		  ?>
		  
		  <div class="fltlft" style="width: 50%">
		      <fieldset class="adminform">
		          <legend><?php echo JText::_('COM_SEF_TITLE_AND_META_TAGS_CONFIGURATION'); ?></legend>
    		      <table class="adminform">
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_ENABLE_METADATA'), JText::_('COM_SEF_ENABLE_METADATA_GENERATION'));?></td>
        	            <td width="200"><?php echo JText::_('COM_SEF_ENABLE_METADATA_GENERATION');?>:</td>
        	            <td><?php echo $lists['enable_metadata'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
                        <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_METADATA_AUTO'), JText::_('COM_SEF_METADATA_AUTO_GENERATION'));?></td>
                        <td><?php echo JText::_('COM_SEF_METADATA_AUTO_GENERATION');?>:</td>
                        <td><?php echo $lists['metadata_auto'];?></td>
                    </tr>      
                    <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_PREFER_JOOMSEF_TITLE'), JText::_('COM_SEF_PREFER_JOOMSEF_TITLES'));?></td>
        	            <td><?php echo JText::_('COM_SEF_PREFER_JOOMSEF_TITLES');?>:</td>
        	            <td><?php echo $lists['prefer_joomsef_title'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_SITENAME'), JText::_('COM_SEF_USE_SITENAME_IN_PAGE_TITLES'));?></td>
        	            <td><?php echo JText::_('COM_SEF_USE_SITENAME_IN_PAGE_TITLES');?>:</td>
        	            <td><?php echo $lists['use_sitename'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITENAME_SEPARATOR'), JText::_('COM_SEF_SITENAME_SEPARATOR'));?></td>
        	            <td><?php echo JText::_('COM_SEF_SITENAME_SEPARATOR');?>:</td>
        	            <td><?php echo $lists['sitename_sep'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_REWRITE_KEYWORDS'), JText::_('COM_SEF_META_KEYWORDS_PREFERENCE'));?></td>
        	            <td><?php echo JText::_('COM_SEF_META_KEYWORDS_PREFERENCE');?>:</td>
        	            <td><?php echo $lists['rewrite_keywords'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_REWRITE_DESC'), JText::_('COM_SEF_META_DESCRIPTION_PREFERENCE'));?></td>
        	            <td><?php echo JText::_('COM_SEF_META_DESCRIPTION_PREFERENCE');?>:</td>
        	            <td><?php echo $lists['rewrite_description'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_NO_SITENAME_DUPLICITY'), JText::_('COM_SEF_PREVENT_SITENAME_DUPLICITY'));?></td>
        	            <td><?php echo JText::_('COM_SEF_PREVENT_SITENAME_DUPLICITY');?>:</td>
        	            <td><?php echo $lists['prevent_dupl'];?></td>
        	        </tr>
        	      </table>
		      </fieldset>
		  </div>
		  <div class="fltrt" style="width: 50%">
		      <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_GLOBAL_META_TAGS_CONFIGURATION'); ?></legend>
		      <fieldset class="adminform">
		          <legend><?php echo JText::_('COM_SEF_STANDARD').' '.JText::_('COM_SEF_META_TAGS'); ?></legend>
    		      <table class="adminform">
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_TAG_GENERATOR'), JText::_('COM_SEF_GENERATOR_TAG'));?></td>
        	            <td width="200"><?php echo JText::_('COM_SEF_GENERATOR_TAG');?>:</td>
        	            <td><?php echo $lists['tag_generator'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_TAG_GOOGLE_KEY'), JText::_('COM_SEF_GOOGLE_KEY'));?></td>
        	            <td><?php echo JText::_('COM_SEF_GOOGLE_KEY');?>:</td>
        	            <td><?php echo $lists['tag_googlekey'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_TAG_LIVE_KEY'), JText::_('COM_SEF_LIVECOM_KEY'));?></td>
        	            <td><?php echo JText::_('COM_SEF_LIVECOM_KEY');?>:</td>
        	            <td><?php echo $lists['tag_livekey'];?></td>
        	        </tr>
        	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_TAG_YAHOO_KEY'), JText::_('COM_SEF_YAHOO_KEY'));?></td>
        	            <td><?php echo JText::_('COM_SEF_YAHOO_KEY');?>:</td>
        	            <td><?php echo $lists['tag_yahookey'];?></td>
        	        </tr>
        	      </table>
		      </fieldset>
		      <fieldset class="adminform">
		          <legend><?php echo JText::_('COM_SEF_CUSTOM').' '.JText::_('COM_SEF_META_TAGS'); ?></legend>
		          <table class="adminform" id="tblMetatags">
		              <tr>
		                  <th width="200"><?php echo JText::_('COM_SEF_NAME'); ?></th>
		                  <th colspan="2"><?php echo JText::_('COM_SEF_CONTENT'); ?></th>
		              </tr>
		              <?php
		              // Custom meta tags
		              if (is_array($sefConfig->customMetaTags)) {
		                  foreach($sefConfig->customMetaTags as $name => $content) {
		                      ?>
		                      <tr>
		                          <td width="200"><input type="text" name="metanames[]" size="40" value="<?php echo $name; ?>" /></td>
		                          <td width="250"><input type="text" name="metacontents[]" size="60" value="<?php echo $content; ?>" /></td>
		                          <td><input type="button" value="<?php echo JText::_('COM_SEF_REMOVE_META_TAG'); ?>" onclick="removeMetaTag(this);" /></td>
		                      </tr>
		                      <?php
		                  }
		              }
		              ?>
		          </table>
		          <input type="button" value="<?php echo JText::_('COM_SEF_ADD_META_TAG'); ?>" onclick="addMetaTag();" />
		      </fieldset>
		      </fieldset>
		  </div>
		  <div style="clear: both;"></div>
		  
		  <?php
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_SEO'), 'seo');
		  ?>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_SEO_CONFIGURATION'); ?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_EXTERNAL_NOFOLLOW'), JText::_('COM_SEF_NOFOLLOW_EXTERNAL'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_NOFOLLOW_EXTERNAL');?>:</td>
    	            <td><?php echo $lists['external_nofollow'];?></td>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_INTERNAL_ENABLE'), JText::_('COM_SEF_ENABLE_INTERNAL'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_ENABLE_INTERNAL');?>:</td>
    	            <td><?php echo $lists['internal_enable'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_INTERNAL_NOFOLLOW'), JText::_('COM_SEF_NOFOLLOW_INTERNAL'));?></td>
    	            <td><?php echo JText::_('COM_SEF_NOFOLLOW_INTERNAL');?>:</td>
    	            <td><?php echo $lists['internal_nofollow'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_INTERNAL_NEWWINDOW'), JText::_('COM_SEF_OPEN_LINKS_IN_NEW_WINDOW'));?></td>
    	            <td><?php echo JText::_('COM_SEF_OPEN_LINKS_IN_NEW_WINDOW');?>:</td>
    	            <td><?php echo $lists['internal_newwindow'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_INTERNAL_MAXLINKS'), JText::_('COM_SEF_MAXIMUM_LINKS_FOR_EACH_WORD'));?></td>
    	            <td><?php echo JText::_('COM_SEF_MAXIMUM_LINKS_FOR_EACH_WORD');?>:</td>
    	            <td><?php echo $lists['internal_maxlinks'];?></td>
    	        </tr>
    	        </tr>
		      </table>
		  </fieldset>
		  
		  <?php
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_SITEMAP'), 'sitemap');
		  ?>
		  
		  <div class="fltlft" style="width: 50%">
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_SITEMAP_CONFIGURATION'); ?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_FILENAME'), JText::_('COM_SEF_XML_FILE_NAME'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_XML_FILE_NAME');?>:</td>
    	            <td><?php echo $lists['sitemap_filename'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_INDEXED'), JText::_('COM_SEF_DEFAULT_INDEXED'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_DEFAULT_INDEXED');?>:</td>
    	            <td><?php echo $lists['sitemap_indexed'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_FREQUENCY'), JText::_('COM_SEF_DEFAULT_CHANGE_FREQUENCY'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_DEFAULT_CHANGE_FREQUENCY');?>:</td>
    	            <td><?php echo $lists['sitemap_frequency'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_PRIORITY'), JText::_('COM_SEF_DEFAULT_PRIORITY'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_DEFAULT_PRIORITY');?>:</td>
    	            <td><?php echo $lists['sitemap_priority'];?></td>
    	        </tr>
                <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
                    <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_SHOW_DATE'), JText::_('COM_SEF_SITEMAP_DATE'));?></td>
                    <td width="200"><?php echo JText::_('COM_SEF_SITEMAP_DATE');?>:</td>
                    <td><?php echo $lists['sitemap_show_date'];?></td>
                </tr>
                <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
                    <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_SHOW_FREQUENCY'), JText::_('COM_SEF_SITEMAP_CHANGE_FREQUENCY'));?></td>
                    <td width="200"><?php echo JText::_('COM_SEF_SITEMAP_CHANGE_FREQUENCY');?>:</td>
                    <td><?php echo $lists['sitemap_show_frequency'];?></td>
                </tr>
                <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
                    <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_SHOW_PRIORITY'), JText::_('COM_SEF_SITEMAP_PRIORITY'));?></td>
                    <td width="200"><?php echo JText::_('COM_SEF_SITEMAP_PRIORITY');?>:</td>
                    <td><?php echo $lists['sitemap_show_priority'];?></td>
                </tr>
		      </table>
		  </fieldset>
		  </div>
		  <div class="fltrt" style="width: 50%">
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_PING_CONFIGURATION'); ?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_PINGAUTO'), JText::_('COM_SEF_PING_AFTER_XML_GENERATION'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_PING_AFTER_XML_GENERATION');?>:</td>
    	            <td><?php echo $lists['sitemap_pingauto'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_YAHOOID'), JText::_('COM_SEF_YAHOO_APPLICATION_ID'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_YAHOO_APPLICATION_ID');?>:</td>
    	            <td><?php echo $lists['sitemap_yahooid'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20" valign="top"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SITEMAP_SERVICES'), JText::_('COM_SEF_PING_SERVICES'));?></td>
    	            <td width="200" valign="top"><?php echo JText::_('COM_SEF_PING_SERVICES');?>:</td>
    	            <td><?php echo $lists['sitemap_services'];?></td>
    	        </tr>
		      </table>
		  </fieldset>
		  </div>
		  <div style="clear: both;"></div>
		  
          <?php if (SEFTools::JoomFishInstalled()) {
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_JOOMFISH'), 'joomfish');
		  ?>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_JOOMFISH_RELATED_CONFIGURATION');?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_LANG_PLACEMENT'), JText::_('COM_SEF_LANGUAGE_INTEGRATION'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_LANGUAGE_INTEGRATION');?></td>
    	            <td><?php echo $lists['langPlacement'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_ALWAYS_USE_LANG'), JText::_('COM_SEF_ALWAYS_USE_LANGUAGE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_ALWAYS_USE_LANGUAGE');?></td>
    	            <td><?php echo $lists['alwaysUseLang'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_TRANSLATE'), JText::_('COM_SEF_TRANSLATE_URLS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_TRANSLATE_URLS');?></td>
    	            <td><?php echo $lists['translateNames'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_BROWSER_LANG'), JText::_('COM_SEF_GET_LANGUAGE_FROM_BROWSER_SETTING'));?></td>
    	            <td><?php echo JText::_('COM_SEF_GET_LANGUAGE_FROM_BROWSER_SETTING');?></td>
    	            <td><?php echo $lists['jfBrowserLang'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_LANG_COOKIE'), JText::_('COM_SEF_SAVE_LANGUAGE_TO_COOKIE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_SAVE_LANGUAGE_TO_COOKIE');?></td>
    	            <td><?php echo $lists['jfLangCookie'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_MAIN_LANG'), JText::_('COM_SEF_MAIN_LANGUAGE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_MAIN_LANGUAGE');?>:</td>
    	            <td><?php echo $lists['mainLanguage'];?></td>
    	        </tr>
		      </table>
		      
		      <?php
		      $jfrouterEnabled = JPluginHelper::isEnabled('system', 'jfrouter');
		      if( isset($lists['jfSubDomains']) ) {
		          $disabled = '';
		          if ($jfrouterEnabled) {
		              $disabled = 'disabled="disabled"';
		          }
		          ?>
		          <table class="adminform">
		          <tr>
		              <th width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_DOMAIN'), JText::_('COM_SEF_DOMAIN_CONFIGURATION'));?></th>
		              <th width="200"><?php echo JText::_('COM_SEF_DOMAIN_CONFIGURATION'); ?></th>
		              <th colspan="2"></th>
		          </tr>
		          <?php
		          foreach( $lists['jfSubDomains'] as $l ) {
		              ?>
		              <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
        	              <td colspan="2"><?php echo $l->name;?></td>
        	              <td><input type="text" name="jfSubDomains[<?php echo $l->code; ?>]" class="inputbox" size="45" value="<?php echo $l->value; ?>" <?php echo $disabled; ?> /></td>
        	              <td></td>
    	              </tr>
		              <?php
		          }
		          ?>
		          </table>
		          <?php
		      }
		      ?>
		      
		      <?php
		      if ($jfrouterEnabled) {
		          $jftxt = sprintf(JText::_('COM_SEF_JFROUTER_ENABLED'), $jfrouterLink);
		          $jfbutton = '<input type="button" onclick="disableStatus(\'jfrouter\');" value="' . JText::_('COM_SEF_DISABLE_JFROUTER_PLUGIN') . '" />';
		      }
		      else {
		          $jftxt = JText::_('COM_SEF_JFROUTER_DISABLED');
		          $jfbutton = '<input type="button" onclick="enableStatus(\'jfrouter\');" value="' . JText::_('COM_SEF_ENABLE_JFROUTER_PLUGIN') . '" />';
		      }
		      ?>
		      <table class="adminform">
		          <tr>
		              <td><?php echo JText::_($jftxt); ?></td>
		          </tr>
		          <tr>
		              <td><?php echo JText::_('COM_SEF_JFROUTER_INFO'); ?></td>
		          </tr>
		          <tr>
		              <td><?php echo $jfbutton; ?></td>
		          </tr>
		      </table>
		  </fieldset>
          <?php } ?>
          <?php
          //if(JPluginHelper::isEnabled('system','languagefilter')) {
	          echo JHTML::_('tabs.panel',JText::_('COM_SEF_LANGUAGE'),'language');
	          ?>
	          <fieldset class="adminform">
	          	<legend><?php echo JText::_('COM_SEF_LANGUAGE_SETTINGS'); ?></legend>
	          	<table class="adminform">
	          		<tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	          			<td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_LANG_ENABLE'),JText::_('COM_SEF_LANG_ENABLE')); ?></td>
	          			<td width="200"><?php echo JText::_('COM_SEF_LANG_ENABLE'); ?></td>
	          			<td><?php echo $lists['langEnable']; ?></td>
	          		</tr>
	          		<tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_LANG_PLACEMENT'), JText::_('COM_SEF_LANGUAGE_INTEGRATION'));?></td>
	    	            <td width="200"><?php echo JText::_('COM_SEF_LANGUAGE_INTEGRATION');?></td>
	    	            <td><?php echo $lists['langPlacementJoomla'];?></td>
	    	        </tr>
	    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_ALWAYS_USE_LANG'), JText::_('COM_SEF_ALWAYS_USE_LANGUAGE'));?></td>
	    	            <td><?php echo JText::_('COM_SEF_ALWAYS_USE_LANGUAGE');?></td>
	    	            <td><?php echo $lists['alwaysUseLangJoomla'];?></td>
	    	        </tr>
	    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	    	        	<td><?php echo $this->tooltip(JText::_('COM_SEF_TT_ADDLANG_TO_MULTILANGUAGE'),JText::_('COM_SEF_ADDLANG_TO_MULTILANGUAGE')); ?></td>
	    	        	<td><?php echo JText::_('COM_SEF_ADDLANG_TO_MULTILANGUAGE'); ?></td>
	    	        	<td><?php echo $lists['addLangMulti']; ?></td>
	    	        </tr>
	    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_BROWSER_LANG'), JText::_('COM_SEF_GET_LANGUAGE_FROM_BROWSER_SETTING'));?></td>
	    	            <td><?php echo JText::_('COM_SEF_GET_LANGUAGE_FROM_BROWSER_SETTING');?></td>
	    	            <td><?php echo $lists['browserLangJoomla'];?></td>
	    	        </tr>
	    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_LANG_COOKIE'), JText::_('COM_SEF_SAVE_LANGUAGE_TO_COOKIE'));?></td>
	    	            <td><?php echo JText::_('COM_SEF_SAVE_LANGUAGE_TO_COOKIE');?></td>
	    	            <td><?php echo $lists['langCookieJoomla'];?></td>
	    	        </tr>
	    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_MAIN_LANG'), JText::_('COM_SEF_MAIN_LANGUAGE'));?></td>
	    	            <td><?php echo JText::_('COM_SEF_MAIN_LANGUAGE');?>:</td>
	    	            <td><?php echo $lists['mainLanguageJoomla'];?></td>
	    	        </tr>
	          	</table>
	          	<table class="adminform">
	          		<tr>
	          			<th width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_JF_DOMAIN'), JText::_('COM_SEF_DOMAIN_CONFIGURATION'));?></th>
		              	<th width="200"><?php echo JText::_('COM_SEF_DOMAIN_CONFIGURATION'); ?></th>
		              	<th colspan="2"></th>
	          		</tr>
	          		<?php
	          		for($i=0;$i<count($lists["subdomainsJoomla"]);$i++) {
	          			$l=$lists["subdomainsJoomla"][$i];
	          			?>
	          			<tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
	          				<td><?php echo $l->title; ?></td>
	          				<td><input type="text" name="subDomainsJoomla[<?php echo $l->sef; ?>]" class="inputbox" size="45" value="<?php echo $l->value; ?>" /></td>
	          				<td></td> 
	          			</tr>
	          			<?php
	          		}
	          		?>
	          	</table>
	          </fieldset>
			  <?php
          //}
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_404_PAGE'), '404');
		  ?>
		  
		  <div class="fltlft" style="width: 50%">
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_404_PAGE'); ?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_404_PAGE'), JText::_('COM_SEF_404_PAGE'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_404_PAGE');?></td>
    	            <td><?php echo $lists['page404'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_404_MESSAGE'), JText::_('COM_SEF_SHOW_404_MESSAGE'));?></td>
    	            <td><?php echo JText::_('COM_SEF_SHOW_404_MESSAGE');?></td>
    	            <td><?php echo $lists['msg404'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_404_RECORD_HITS'), JText::_('COM_SEF_RECORD_404_PAGE_HITS'));?></td>
    	            <td><?php echo JText::_('COM_SEF_RECORD_404_PAGE_HITS');?></td>
    	            <td><?php echo $lists['record404'];?></td>
    	        </tr>
		      </table>
		  </fieldset>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_DEFAULT_404_PAGE').' - '.JText::_('COM_SEF_ITEMID');?></legend>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20" valign="top"><?php echo $this->tooltip(JText::_('COM_SEF_TT_USE_404_ITEMID'), JText::_('COM_SEF_USE_ITEMID_FOR_DEFAULT_404_PAGE'));?></td>
    	            <td width="200" valign="top"><?php echo JText::_('COM_SEF_USE_ITEMID_FOR_DEFAULT_404_PAGE');?></td>
    	            <td><?php echo $lists['use404itemid'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td valign="top"><?php echo $this->tooltip(JText::_('COM_SEF_TT_SELECT_ITEMID'), JText::_('COM_SEF_SELECT_ITEMID'));?></td>
    	            <td valign="top"><?php echo JText::_('COM_SEF_SELECT_ITEMID');?></td>
    	            <td><?php echo $lists['itemid404'];?></td>
    	        </tr>
		      </table>
		  </fieldset>
		  </div>
		  
		  <div class="fltrt" style="width: 50%">
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_CUSTOM_404_PAGE');?></legend>
    		  <?php
    		  // parameters : hidden field, content, width, height, cols, rows
    		  jimport( 'joomla.html.editor' );
    		  $editor =& JFactory::getEditor();
    		  echo $editor->display('introtext', $lists['txt404'], '450', '250', '50', '11');
    		  ?>
		  </fieldset>
		  </div>
		  <div class="clr"></div>
		  
		  <?php
		  echo JHtml::_('tabs.panel', JText::_('COM_SEF_REGISTRATION'), 'registration');
		  $x = 0;
		  ?>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_ARTIO_JOOMSEF_REGISTRATION');?></legend>
		      <p><?php echo JText::_('COM_SEF_INFO_REGISTRATION'); ?></p>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_ARTIO_DOWNLOAD_ID'), JText::_('COM_SEF_JOOMSEF_DOWNLOAD_ID'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_JOOMSEF_DOWNLOAD_ID');?>:</td>
    	            <td><?php echo $lists['artioDownloadId'];?></td>
    	        </tr>
		      </table>
		  </fieldset>

		  <?php $x = 0; ?>
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_ARTIO_USER_ACCOUNT'); ?></legend>
		      <p><?php echo JText::_('COM_SEF_INFO_ACCOUNT'); ?></p>
		      <table class="adminform">
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_ARTIO_USERNAME'), JText::_('COM_SEF_ARTIO_SITE_USERNAME'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_ARTIO_SITE_USERNAME');?>:</td>
    	            <td><?php echo $lists['artioUserName'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td><?php echo $this->tooltip(JText::_('COM_SEF_TT_ARTIO_PASSWORD'), JText::_('COM_SEF_ARTIO_SITE_PASSWORD'));?></td>
    	            <td><?php echo JText::_('COM_SEF_ARTIO_SITE_PASSWORD');?>:</td>
    	            <td><?php echo $lists['artioPassword'];?></td>
    	        </tr>
		      </table>
		  </fieldset>
		  
		  <fieldset class="adminform">
		      <legend><?php echo JText::_('COM_SEF_ARTIO_NEWS'); ?></legend>
		      <table class="adminform">
                <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
                    <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_ARTIO_FEED'), JText::_('COM_SEF_DISPLAY_ARTIO_NEWSFEED'));?></td>
                    <td width="200"><?php echo JText::_('COM_SEF_DISPLAY_ARTIO_NEWSFEED');?>:</td>
                    <td><?php echo $lists['artioFeedDisplay'];?></td>
    	        </tr>
    	        <tr<?php $x++; echo (($x % 2) ? '':' class="row1"' );?>>
    	            <td width="20"><?php echo $this->tooltip(JText::_('COM_SEF_TT_VERSION_CHECKER'),JText::_('COM_SEF_CHECK_FOR_NEWER_VERSIONS'));?></td>
    	            <td width="200"><?php echo JText::_('COM_SEF_CHECK_FOR_NEWER_VERSIONS');?>:</td>
    	            <td><?php echo $lists['versionChecker'];?></td>
    	        </tr>
		      </table>
		  </fieldset>

		  <?php
		  echo JHtml::_('tabs.end');
		  ?>
		
		
		
<input type="hidden" name="id" value="" />
<input type="hidden" name="section" value="config" />
<input type="hidden" name="option" value="com_sef" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="controller" value="config" />
<input type="hidden" name="statusType" value="" />
<input type="hidden" name="return" value="index.php?option=com_sef&amp;controller=config&amp;task=edit" />
<?php echo JHTML::_('form.token'); ?>
</form>
