<?php
/**
 * Content SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

define( '_COM_SEF_PRIORITY_CONTENT_ARTICLE_ITEMID',         15 );
define( '_COM_SEF_PRIORITY_CONTENT_ARTICLE',                20 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYLIST_ITEMID',    35 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYLIST',           40 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG_ITEMID',    55 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG',           60 );

class SefExt_com_content extends SefExt
{
    public function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);

        return array($this->nonSefVars, $this->ignoreVars);
    }

    protected function _createNonSefVars(&$uri)
    {
        if (!isset($this->nonSefVars) && !isset($this->ignoreVars)) {
            $this->nonSefVars = array();
        	$this->ignoreVars = array();
        }

        $this->params =& SEFTools::GetExtParams('com_content');
        $sefConfig =& SEFConfig::getConfig();

        if ($sefConfig->appendNonSef && ($this->params->get('pagination', '0') != '0')) {

            if (!is_null($uri->getVar('limit'))) {
                $this->nonSefVars['limit'] = $uri->getVar('limit');
            }
            if (!is_null($uri->getVar('limitstart'))) {
                $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
            }
        }
        if (!is_null($uri->getVar('filter'))) {
            $this->nonSefVars['filter'] = $uri->getVar('filter');
        }
    }

    protected function _getArticle($id)
    {
        $sefConfig =& SEFConfig::getConfig();
        $title=array();

    	$field = 'title';
        if (SEFTools::UseAlias($this->params, 'title_alias')) {
            $field = 'alias';
        }

        $id = intval($id);
        $query="SELECT `$field` AS `name`, `introtext`, `fulltext`, `language`, `metakey`, `metadesc`, `metadata`, `catid` FROM `#__content` WHERE `id` = ".$id;
        $this->_db->setQuery($query);
        $row = $this->_db->loadObject();
        // Article dont exists
        if(!is_object($row)) {
        	return array();
        }
        
        if($this->params->get('show_category', '2')!=0) {
        	$title=array_merge($title,$this->getCategoryInfo($row->catid));
        }

        //$this->item_desc = $row->introtext;
        if($this->params->get('googlenewsnum',0)==0) {
        	$title[] = (($this->params->get('articleid', '0')==1) ? $id.'-':'').$row->name;
        } else {
        	$title[]=$this->GoogleNews($row->name,$id);
        }
        $this->getMetaData($row);
        
        $this->metadesc=$row->introtext;
        $this->origmetadesc=$row->metadesc;
        $this->metakeySource=$row->fulltext;
        $this->origmetakey=$row->metakey;
     
        return $title;
    }

    public function beforeCreate(&$uri)
    {
        // remove the limitstart and limit variables if they point to the first page
        if (!is_null($uri->getVar('limitstart')) && ($uri->getVar('limitstart') == '0')) {
            $uri->delVar('limitstart');
            $uri->delVar('limit');
        }

        // Try to guess the correct Itemid if set to
        if ($this->params->get('guessId', '0') != '0') {
            if (!is_null($uri->getVar('Itemid')) && !is_null($uri->getVar('id'))) {
                $mainframe =& JFactory::getApplication();
                $i = $mainframe->getItemid($uri->getVar('id'));
                $uri->setVar('Itemid', $i);
            }
        }

        // Remove the part after ':' from variables
        if (!is_null($uri->getVar('id')))    SEFTools::fixVariable($uri, 'id');
        if (!is_null($uri->getVar('catid'))) SEFTools::fixVariable($uri, 'catid');

        // If catid not given, try to find it
        $catid = $uri->getVar('catid');
        if (!is_null($uri->getVar('view')) && ($uri->getVar('view') == 'article') && !is_null($uri->getVar('id')) && empty($catid)) {
            $id = $uri->getVar('id');
            $query = "SELECT `catid` FROM `#__content` WHERE `id` = '{$id}'";
            $this->_db->setQuery($query);
            $catid = $this->_db->loadResult();

            if (!empty($catid)) {
                $uri->setVar('catid', $catid);
            }
        }

        // remove empty id in categories list
        if ($uri->getVar('view') == 'categories' && ! (int) $uri->getVar('id'))
        	$uri->delVar('id');

        return;
    }

    protected function GoogleNews($title, $id)
    {
        $db =& JFactory::getDBO();

        $num = '';
        $add = $this->params->get('googlenewsnum', '0');

        if ($add == '1' || $add == '3') {
            // Article ID
            $digits = trim($this->params->get('digits', '3'));
            if (!is_numeric($digits)) {
                $digits = '3';
            }

            $num1 = sprintf('%0'.$digits.'d', $id);
        }
        if ($add == '2' || $add == '3') {
            // Publish date
            $query = "SELECT `publish_up` FROM `#__content` WHERE `id` = '$id'";
            $db->setQuery($query);
            $time = $db->loadResult();

            $time = strtotime($time);

            $date = $this->params->get('dateformat', 'ddmm');

            $search = array('dd', 'd', 'mm', 'm', 'yyyy', 'yy');
            $replace = array(date('d', $time),
            date('j', $time),
            date('m', $time),
            date('n', $time),
            date('Y', $time),
            date('y', $time) );
            $num2 = str_replace($search, $replace, $date);
        }

        if ($add == '1') {
            $num = $num1;
        }
        else if ($add == '2') {
            $num = $num2;
        }
        else if ($add == '3') {
            $sep = $this->params->get('iddatesep', '');
            if ($this->params->get('iddateorder', '0') == '0') {
                $num = $num2.$sep.$num1;
            }
            else {
                $num = $num1.$sep.$num2;
            }
        }

        if (!empty($num)) {
            $onlyNum = ($this->params->get('title_alias', 'global') == 'googlenews');

            if ($onlyNum) {
                return $num;
            }

            $sefConfig =& SEFConfig::getConfig();
            $sep = $sefConfig->replacement;

            $where = $this->params->get('numberpos', '1');

            if( $where == '1' ) {
                $title = $title.$sep.$num;
            } else {
                $title = $num.$sep.$title;
            }
        }

        return $title;
    }

    function _processPagination(&$uri) {
    	$title=array();
    	$sefConfig =& SEFConfig::getConfig();
    	$handle=$this->params->get('pagination',0);
    	if($sefConfig->appendNonSef==true && $handle==1 ) {
    		$this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
    		return array();
    	}
		//$appParams=JFactory::getApplication('site')->getParams();
		$appParams=JApplication::getInstance('site');
    	$menu =& JFactory::getApplication('site')->getMenu('site');
        if( !isset($Itemid) ) {
            // We need to find Itemid first
            $active =& $menu->getActive();
            $Itemid = $active->id;
        }
        $menuParams =& $menu->getParams($Itemid);
        $menuParams->merge($appParams);
        // View: Article
        if($uri->getVar("view")=="article") {
        	if(($limitstart=$uri->getVar('limitstart'))>0) {
        		$pagetext = strval($limitstart+1);
                if (($cnfPageText = $sefConfig->getPageText())) {
                    $title[] = str_replace('%s', $limitstart+1, $cnfPageText);
                }
        	}
        	if($uri->getVar('showall')==1) {
	        	$title[] = JText::_('COM_SEF_ALL_PAGES');
	        }
        // Layouts: category default list; View: Archive
        } else if($uri->getVar("layout")!="blog" && $uri->getVar("view")!="featured") {
        	// If pagination filter is disabled we can make sef URL's with pagination
        	if($menuParams->get('show_pagination_limit',1)==0 || $uri->getVar("view")!="featured") {
        		$limit=$menuParams->get('display_num');
        		$limitstart=$uri->getVar('limitstart');
        		@$page=intval($limitstart/$limit)+1;
        		/*if($limit==0) {
        			echo "<pre>";
        			debug_print_backtrace();
        			echo "</pre>";
        		}*/
        		if($page!=1) {
	        		$pagetext = strval($page);
	                if (($cnfPageText = $sefConfig->getPageText())) {
	                    $title[] = str_replace('%s', $page, $cnfPageText);
	                }
        		}
        	} else {
        		if(!is_null($uri->getVar('limitstart'))) {
        			$this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
        		}
        	}
        // Layout: category blog; View: featured
        } else {
        	$leading = $menuParams->get('num_leading_articles', 1);
	        $intro   = $menuParams->get('num_intro_articles', 4);
	        $limit = $leading + $intro;	
			$limitstart=$uri->getVar('limitstart');
	        $page = intval($limitstart / $limit)  + 1;
	        if($page!=1) {
        		$pagetext = strval($page);
                if (($cnfPageText = $sefConfig->getPageText())) {
                    $title[] = str_replace('%s', $page, $cnfPageText);
                }
    		}
        }
        
        return $title;	
    }
    
    public function create(&$uri)
    {
    	$this->metadesc = null;
    	$this->cat_desc = null;
    	$this->item_desc = null;

        $sefConfig =& SEFConfig::getConfig();
        $title=array();

        $vars = $uri->getQuery(true);
        extract($vars);
        $this->_createNonSefVars($uri);

        // Set title.
        $title[] = JoomSEF::_getMenuTitleLang(@$option, $this->lang, @$Itemid);
        switch (@$view) {
            case 'form':
                $this->nonSefVars = array();
            	$this->nonSefVars["return"]=@$return;
            	if(isset($a_id)) {
					$title=array_merge($title,$this->_getArticle($a_id));            		
            	}
             	break;
            case 'featured':
            	$title=array_merge($title,$this->_processPagination($uri));
            	break;
            case 'categories':
            	break;
            case 'category':
            	if (isset($id)) {
                    $title=array_merge($title,$this->getCategoryInfo($id));
                }
                if($this->params->get('add_layout')==2 || ($this->params->get('add_layout')==1 && $this->params->get('def_layout')!=@$layout)) {
                	@$title[]=$layout;
                }
                if(isset($format) && $format=="feed") {
                	@$title[]=$type;
                }
                $title=array_merge($title,$this->_processPagination($uri));
            	break;
            case 'article':
            	$title=array_merge($title,$this->_getArticle($id));
            	$title=array_merge($title,$this->_processPagination($uri));
            	break;
            case 'archive':
                if( !empty($year) ) {
                    $title[] = $year;
                }
                if( !empty($month) ) {
                    $title[] = $month;
                }
				$title=array_merge($title,$this->_processPagination($uri));
                break;
            default:
            	switch($task) {
            		case 'article.add':
            			$title[]=JText::_('COM_SEF_NEW');
            			break;
            		case 'article.edit':
            			$this->nonSefVars = array();
		            	$this->nonSefVars["return"]=@$return;
		            	if(isset($a_id)) {
							$title=array_merge($title,$this->_getArticle($a_id));            		
		            	}
		            	$title[]=JText::_('COM_SEF_EDIT');
            			break;
            	}
            	break;
        }

        $newUri = $uri;
        if (count($title) > 0) {
            // Generate meta tags
            $this->metatags = $this->getMetaTags();

            $priority = $this->getPriority($uri);
            if(isset($this->lang)) {
            	$lang=$this->lang;
            }
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, $this->nonSefVars, null, $this->metatags, $priority, true);

        }

        return $newUri;
    }

    public function getPriority(&$uri)
    {
        $itemid = $uri->getVar('Itemid');
        $view = $uri->getVar('view');
        $layout = $uri->getVar('layout');

        switch($view)
        {
            case 'article':
                if( is_null($itemid) ) {
                    return _COM_SEF_PRIORITY_CONTENT_ARTICLE;
                } else {
                    return _COM_SEF_PRIORITY_CONTENT_ARTICLE_ITEMID;
                }
                break;

            case 'category':
                if( $layout == 'blog' ) {
                    if( is_null($itemid) ) {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG;
                    } else {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG_ITEMID;
                    }
                } else {
                    if( is_null($itemid) ) {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYLIST;
                    } else {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYLIST_ITEMID;
                    }
                }
                break;

            default:
                return null;
                break;
        }
    }
    
    function getURLPatterns($item) {
    	$urls=array();
    	if($item->getTableName()=='#__categories') {
    		// Category view
    		$urls[]='index\.php\?option=com_content(&format=feed)?&id='.$item->id.'&';
    		// Content View
    		$urls[]='index\.php\?option=com_content&catid='.$item->id.'&id=';
    		$tree=$item->getTree($item->id);
    		foreach($tree as $catitem) {
    			$urls[]='index\.php\?option=com_content(&format=feed)?&id='.$catitem->id.'&';
    			$urls[]='index\.php\?option=com_content&catid='.$catitem->id.'&id=';
    		}
    	} else {
    		$urls[]='index\.php\?option=com_content(&catid=([0-9])*)*&id='.$item->id.'(&lang=[a-z]+)?(&limitstart=[0-9]+)?(&type=(atom|rss))?&view=article';
    	}
    	return $urls;
    }
}
?>