<?php
/**
 * AlphaUserPoints SEF extension for Joomla!
 *
 * @copyright   2009 JoomAce LLC
 * @license	    http://www.joomace.net/company/license
 * www.joomace.net
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_alphauserpoints extends SefExt
{
    var $params;

    function getUserTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT u.id, u.username FROM #__alpha_userpoints AS a, #__users AS u WHERE a.userid = u.id AND a.referreid = '$id'");
        $rows = $database->loadRow();
        
		$name = ( ($this->params->get('userid_inc', '0') != '0') ? $rows[0].'-' : '' ).$rows[1];
		return $name;
    }
	
    function create(&$uri) {
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_alphauserpoints');
		
		$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if(isset($view)) {
            switch($view) {
				case 'user2userpoints':
				case 'buypoints':
				case 'invite':
				case 'users':
				case 'medals':
				case 'account':
                    $tasks = array( 'user2userpoints' => JText::_('AUP_USER2USERPOINTS'),
					'buypoints' => JText::_('BUY POINTS'),
					'invite' => JText::_('AUP_INVITE'),
					'users' => JText::_('AUP_USERS'),
					'medals' => JText::_('AUP_MEDALS'),
					'account' => JText::_('AUP_USERACCOUNT'));
                    $title[] = $tasks[$view];
                    unset($view);
                    break;
				default:
					$title[] = $view;
            }
        }
		
		if(isset($task)) {
            switch($task) {
				case 'downloadactivity':
					if(isset($userid))
						$title[] = $this->getUserTitle($userid);
					$title[] = JText::_('AUP_DOWNLOAD_MY_FULL_ACTIVITY');
					unset($task);
					break;
				case 'cancel':
					$title[] = JText::_('AUP_PURCHASE_CANCELED');
					unset($task);
					break;
				default:
					$title[] = $task;
			}
		}
		
		if(isset($referrer))
			$title[] = $this->getUserTitle($referrer);
		
		$nonSefVars = array();
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
		
        $newUri = $uri;
        if (count($title) > 0)
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        return $newUri;
    }
}
?>