<?php
/**
 * Gary's Cook Book SEF extension for Joomla!
 *
 * @author      $Author: Teer $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */
defined('_JEXEC') or die('Restricted access.');
class SefExt_com_garyscookbook extends SefExt
{
    function getCategories ($id)
    {
        $title = array();
        $this->addCategoryTitle($id, $title);
        if (count($title)) {
            return $title;
        }
        return null;
    }
    function getImgTitle ($id, &$title)
    {
        $catTitles = $this->addReceptCategoriesTree($id);
        if (is_array($catTitles)) {
            $title = array_merge($title, $catTitles);
        }
        $database = JFactory::getDBO();
        $database->setQuery("SELECT `imgtitle` FROM `#__garyscookbook` WHERE `id` = $id");
        $itemTitle = strval($database->loadResult());
        if ($itemTitle) {
            $title[] = $itemTitle;
        }
    }
    function addReceptCategoriesTree ($id)
    {
        $database = JFactory::getDBO();
        $database->setQuery("SELECT `catid` FROM `#__garyscookbook` WHERE `id` = $id");
        $catid = intval($database->loadResult());
        if ($catid) {
            $title = array();
            $this->addCategoryTitle($catid, $title);
            if (count($title)) {
                return $title;
            }
        }
        return null;
    }
    function addCategoryTitle ($id, &$title)
    {
        $database = JFactory::getDBO();
        $database->setQuery("SELECT `title`,`parent_id` FROM `#__categories` WHERE `id` = $id");
        $row = $database->loadRow();
        if (count($row) == 2) {
            $name = strval($row[0]);
            array_unshift($title, $name);
            $parent = intval($row[1]);
            if ($parent) {
                return $this->addCategoryTitle($parent, $title);
            }
        }
        return;
    }
    function create (&$uri)
    {
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();
        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
        switch (@$func) {
            case 'special':
                switch (@$sorting) {
                    case 'rating':
                        $title[] = JText::_('Top Rated');
                        break;
                    case 'lastadd':
                        $title[] = JText::_('Last Added');
                        break;
                    case 'lastcomment':
                        $title[] = JText::_('Last Commented');
                        break;
                    case 'vegetarian':
                        $title[] = JText::_('Vegetarian Dishes');
                        break;
                    case 'lactose':
                        $title[] = JText::_('Lactose free Dishes');
                        break;
                    case 'diet':
                        $title[] = JText::_('Diet Dishes');
                        break;
                    case 'gluten':
                        $title[] = JText::_('Gluten free Dishes');
                        break;
                    default:
                        $title[] = JText::_('Most Viewed');
                        break;
                }
                break;
            case 'viewcategory':
                $catTitles = $this->getCategories($id);
                if (is_array($catTitles)) {
                    $title = array_merge($title, $catTitles);
                }
                break;
            case 'detail':
                $this->getImgTitle($id, $title);
                break;
            case 'newItem':
                $title[] = JText::_('Add a Recipe to the Cookbook');
                break;
            case 'editpic':
                $this->getImgTitle($id, $title);
                $title[] = JText::_('Edit Recipe');
                break;
            case 'print':
                $this->getImgTitle($id, $title);
                $title[] = JText::_('Print Recipe');
                break;
            case 'rpdf':
                $this->getImgTitle($id, $title);
                $title[] = JText::_('Print Recipe to PDF');
                break;
            case 'rmm':
                $this->getImgTitle($id, $title);
                $title[] = JText::_('Export Recipe');
                break;
        }
        $newUri = $uri;
        if (count($title) > 0) {
            $nonSefVars = array();
            if (isset($limit)) {
                $nonSefVars['limit'] = $limit;
            }
            if (isset($limitstart)) {
                $nonSefVars['limitstart'] = $limitstart;
            }
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, $nonSefVars);
        }
        return $newUri;
    }
}
?>