<?php
/**
 * Phoca Gallery SEF extension for Joomla!
 *
* @copyright  2009 JoomAce
 * @license	    http://www.joomace.net/company/license
 * www.joomace.net
 * @package     JoomSEF
 */

 // Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_phocagallery extends SefExt
{
	var $params;
	
	function getCategoryTitle($id) {
		$cats = $this->params->get('category_inc', '2');
		$categories = array();
		
		$field = 'title';
        if(SEFTools::UseAlias($this->params, 'category_part') ) {
            $field = 'alias';
        }
		
		if ($cats == '0')
            $id = 0; // No cat to add
		while ($id > 0) {
			$database =& JFactory::getDBO();
	        $database->setQuery("SELECT $field AS `title`, `parent_id` FROM `#__phocagallery_categories` WHERE `id` = $id");
	        $cat = $database->loadObject();
			
	        $name = ( ($this->params->get('categoryid_inc', '0') != '0') ? $id.'-' : '' ).$cat->title;
			array_unshift($categories, $name);
			
			$id = $cat->parent_id;
			if ($cats == '1')
                break; //  Only last cat
        }
		 return $categories;
    }
	
	function getPictureTitle($id) {
		$field = 'title';
        if(SEFTools::UseAlias($this->params, 'picture_part') ) {
            $field = 'alias';
        }
		
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT $field AS `title`, `catid` FROM `#__phocagallery` WHERE `id` = $id");
        $picture = $database->loadObject();
		
		$category = $this->getCategoryTitle($picture->catid);
		
		$name = ( ($this->params->get('pictureid', '0') != '0') ? $id.'-' : '' ).$picture->title;
		array_push($category, $name);
		
		return $category;
    }

    function beforeCreate(&$uri) {
        if( !is_null($uri->getVar('id')) )       SEFTools::fixVariable($uri, 'id');

        return;
    }
	
	function create(&$uri) {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_phocagallery');

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if( isset($view) ) {
            switch($view) {
                case 'detail':
					if( isset($id) ) {
						$title = array_merge( $title, $this->getPictureTitle($id) );
					}
                    unset($view);
                    break;

                case 'category':
                    if( isset($id) ) {
                        $title = array_merge( $title, $this->getCategoryTitle($id));
                    }
                    unset($view);
                    break;
				case 'categories':
                        $title[] = JText::_('CATEGORIES');
                    unset($view);
                    break;
				default:
					$title[] = $view;
                    unset($view);
            }
        }
		
		$nonSefVars = array();
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
		
		$newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }

        return $newUri;
    }
}
?>