<?php
/**
 * Seyret Video Directory SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_seyret extends SefExt
{

    var $params;

    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('from')))
            $this->nonSefVars['from'] = $uri->getVar('from');
        if (!is_null($uri->getVar('no_html')))
            $this->nonSefVars['no_html'] = $uri->getVar('no_html');
        if (!is_null($uri->getVar('sender')))
            $this->nonSefVars['sender'] = $uri->getVar('sender');
        if (!is_null($uri->getVar('featurednavstart')))
            $this->nonSefVars['featurednavstart'] = $uri->getVar('featurednavstart');
        if (!is_null($uri->getVar('latestnavstart')))
            $this->nonSefVars['latestnavstart'] = $uri->getVar('latestnavstart');
        if (!is_null($uri->getVar('rvds')))
            $this->nonSefVars['rvds'] = $uri->getVar('rvds');
        if (!is_null($uri->getVar('scvds')))
            $this->nonSefVars['scvds'] = $uri->getVar('scvds');
        if (!is_null($uri->getVar('cvld')))
            $this->nonSefVars['cvld'] = $uri->getVar('cvld');
        if (!is_null($uri->getVar('qsvd')))
            $this->nonSefVars['qsvd'] = $uri->getVar('qsvd');
        if (!is_null($uri->getVar('chvld')))
            $this->nonSefVars['chvld'] = $uri->getVar('chvld');
        if (!is_null($uri->getVar('uvld')))
            $this->nonSefVars['uvld'] = $uri->getVar('uvld');
        if (!is_null($uri->getVar('mmvd')))
            $this->nonSefVars['mmvd'] = $uri->getVar('mmvd');
        if (!is_null($uri->getVar('mlvd')))
            $this->nonSefVars['mlvd'] = $uri->getVar('mlvd');
        if (!is_null($uri->getVar('mhrvd')))
            $this->nonSefVars['mhrvd'] = $uri->getVar('mhrvd');
        if (!is_null($uri->getVar('mfvd')))
            $this->nonSefVars['mfvd'] = $uri->getVar('mfvd');
        if (!is_null($uri->getVar('cvsubpage')))
            $this->nonSefVars['cvsubpage'] = $uri->getVar('cvsubpage');
        if (!is_null($uri->getVar('searchkey')))
            $this->nonSefVars['searchkey'] = $uri->getVar('searchkey');
        if (!is_null($uri->getVar('width')))
            $this->nonSefVars['width'] = $uri->getVar('width');
        if (!is_null($uri->getVar('height')))
            $this->nonSefVars['height'] = $uri->getVar('height');
        if (!is_null($uri->getVar('comid')))
            $this->nonSefVars['comid'] = $uri->getVar('comid');
    }
    
    function beforeCreate(&$uri)
    {
        if ($uri->getVar('view') == 'main' && $uri->getVar('lvpage') == '1') {
            $uri->delVar('view');
            $uri->delVar('lvpage');
        }
        else if ($uri->getVar('view') == 'category' && $uri->getVar('cvlpage') == '1') {
            $uri->delVar('cvlpage');
        }
        else if ($uri->getVar('view') == 'search' && $uri->getVar('qsvpage') == '1') {
            $uri->delVar('qsvpage');
        }
        else if ($uri->getVar('view') == 'user' && $uri->getVar('uvlpage') == '1') {
            $uri->delVar('uvlpage');
        }
        
        if ($uri->getVar('view') == 'user' && $uri->getVar('id') == '0') {
            $uri->delVar('view');
            $uri->delVar('id');
        }
    }
    
    function GetParentId($catId)
    {
        $parentId = intval(preg_replace('/^(.*)\*([^\*]*)\*#/', '$2', $catId));
        return $parentId;
    }

    // Creates an array of nested categories from given category id
    function GetCategories($catId, $tbl = '#__seyret_category')
    {
        $database =& JFactory::getDBO();

        $categories = array();

        // If set not to add any category
        //if( $this->params->get('categories', '2') == '0' )  $catId = 0;

        while ($catId > 0) {
            $database->setQuery("SELECT `id`, `categoryname`, `parentcat` FROM `{$tbl}` WHERE `id` = '{$catId}'");
            $row = $database->loadObject();

            $name = $row->categoryname;
            array_unshift ($categories, $name);

            // If set to add last category only
            //if ($this->params->get('categories', '2') == '1')   break;

            $catId = $this->GetParentId($row->parentcat);
        }
        return $categories;
    }

    function GetItemInfo($id, $oldVersion = false)
    {
        $database =& JFactory::getDBO();

        if ($oldVersion)
        {
            $query = "SELECT `id`, `catid`, `title` FROM `#__seyret_items` WHERE `id` = '$id'";
            $database->setQuery($query);
            $row = $database->loadObject();
        }
        else
        {
            $query = "SELECT `id`, `parentcat`, `videotitle` FROM `#__seyret_video` WHERE `id` = '$id'";
            $database->setQuery($query);
            $row = $database->loadObject();
        }

        return $row;
    }
    
    function GetChannelInfo($id)
    {
        $database =& JFactory::getDBO();
        $query = "SELECT `id`, `channeltitle` FROM `#__seyret_channel` WHERE `id` = '$id'";
        $database->setQuery($query);
        $row = $database->loadObject();
    
        return $row;
    }

    function GetUserInfo($id)
    {
        $database =& JFactory::getDBO();

        $query = "SELECT `id`, `username` FROM `#__users` WHERE `id` = '$id'";
        $database->setQuery($query);
        $row = $database->loadObject();

        return $row;
    }
    
    function GoogleNews($title, $id)
    {
        $db =& JFactory::getDBO();
        $params = SEFTools::GetExtParams('com_content');

        $num = '';
        $add = $params->get('googlenewsnum', '0');

        if ($add == '1') {
            // Article ID
            $digits = trim($params->get('digits', '3'));
            if (!is_numeric($digits)) {
                $digits = '3';
            }

            $num = sprintf('%0'.$digits.'d', $id);
        }
        else if ($add == '2') {
            // Publish date
            $query = "SELECT `publish_up` FROM `#__content` WHERE `id` = '$id'";
            $db->setQuery($query);
            $time = $db->loadResult();

            $time = strtotime($time);

            $date = $params->get('dateformat', 'ddmm');

            $search = array('dd', 'd', 'mm', 'm', 'yyyy', 'yy');
            $replace = array(date('d', $time),
            date('j', $time),
            date('m', $time),
            date('n', $time),
            date('Y', $time),
            date('y', $time) );
            $num = str_replace($search, $replace, $date);
        }

        if (!empty($num)) {
            $sefConfig =& SEFConfig::getConfig();
            $sep = $sefConfig->replacement;

            $where = $params->get('numberpos', '1');

            if( $where == '1' ) {
                $title = $title.$sep.$num;
            } else {
                $title = $num.$sep.$title;
            }
        }

        return $title;
    }

    function create(&$uri)
    {
        // Load the texts to use in URL
        $tasks = SEFTools::getExtTexts('com_seyret');
        
        // Load extension parameters
        $this->params = SEFTools::GetExtParams('com_seyret');

        /**
         * Use this to get variables from the original Joomla! URL, such as $task, $page, $id, $catID, ...
         */
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if (isset($view))
        {
            // Versions > 0.3
            switch ($view)
            {
            case 'category':
                $catNames = $this->GetCategories($id);
                if ($this->params->get('categories', '2') == '2') {
                    // All categories
                    foreach ($catNames as $cat) {
                        $title[] = $cat;
                    }
                } else {
                    // One category
                    $title[] = @$catNames[count($catNames) - 1];
                }
                
                // Pagination
                if (isset($cvlpage)) {
                    $title[] = $cvlpage;
                }
                
                if (isset($task)) {
                    unset($task);
                }
                break;
                
            case 'video':
            case 'editvideo':
            case 'tools':
            case 'statistics':
            case 'comments':
                if (!isset($id) && isset($vid)) {
                    $id = $vid;
                }
                if (isset($id)) {
                    $item = $this->GetItemInfo($id);
                    
                    // Get categories
                    $catid = $this->GetParentId($item->parentcat);
                    $catNames = $this->GetCategories($catid);
                    if (($c = $this->params->get('categories', '2')) != '0') {
                        if ($c == '2') {
                            // All categories
                            foreach ($catNames as $cat) {
                                $title[] = $cat;
                            }
                        } else {
                            // One category
                            $title[] = @$catNames[count($catNames) - 1];
                        }
                    }
                    $title[] = $item->videotitle;
                    
                    // Add Google News number if set to
                    if ($this->params->get('googlenewsnum', '0') != '0') {
                        $i = count($title) - 1;
                        $title[$i] = $this->GoogleNews($title[$i], $id);
                    }
                }
                
                if (isset($task) && ($task == 'ajaxvideo')) {
                    $title[] = JText::_('Ajax');
                    unset($task);
                }
                
                if ($view == 'editvideo') {
                    if (isset($task)) {
                        if ($task == 'deletevideo') {
                            $title[] = JText::_('Delete video');
                        }
                        else if ($task == 'savevideo') {
                            $title[] = JText::_('Add video');
                            $title[] = JText::_('Save');
                        }
                        
                        unset($task);
                    }
                    else {
                        if (isset($id)) {
                            $title[] = JText::_('Edit video');
                        }
                        else {
                            $title[] = JText::_('Add video');
                        }
                    }
                }
                else if ($view == 'tools') {
                    if (isset($task)) {
                        switch ($task) {
                        case 'flagvideo':
                            $title[] = JText::_('Flag video');
                            break;
                        case 'addfavorite':
                            $title[] = JText::_('Favorite');
                            break;
                        case 'emailtofriend':
                            $title[] = JText::_('Send to a friend');
                            break;
                        case 'socialbookmarks':
                            $title[] = JText::_('Social bookmarks');
                            break;
                        case 'removefavorite':
                            $title[] = JText::_('Remove from favorites');
                            break;
                        case 'flagcomment':
                            $title[] = JText::_('Report comment');
                            break;
                        case 'rssfactory':
                            $title[] = JText::_('RSS');
                            break;
                        }
                    }
                    unset ($task);
                }
                else if ($view == 'statistics') {
                    $title[] = JText::_('Statistics');
                    unset ($task);
                }
                else if ($view == 'comments') {
                    if (isset($task)) {
                        if ($task == 'geteditor') {
                            $title[] = JText::_('Write comment');
                        }
                        else if ($task == 'geteditoredit') {
                            $title[] = JText::_('Edit comment');
                        }
                        else if ($task == 'submitcomment') {
                            $title[] = JText::_('Comments');
                            $title[] = JText::_('Submit');
                        }
                        unset($task);
                    }
                }
                break;
                
            case 'channel':
                $title[] = JText::_('Channels');
                
                if (isset($id)) {
                    $item = $this->GetChannelInfo($id);
                    $title[] = $item->channeltitle;
                }
                
                if (isset($task)) {
                    if ($task == 'joinchannel') {
                        $title[] = JText::_('Join');
                    }
                    else if ($task == 'editchannel') {
                        $title[] = JText::_('Create new channel');
                    }
                    else if ($task == 'savechannel') {
                        $title[] = JText::_('Create new channel');
                        $title[] = JText::_('Save');
                    }
                    unset($task);
                }
                break;
                
            case 'user':
                $item = $this->GetUserInfo($id);
                $title[] = $item->username;
                
                // Pagination
                if (isset($uvlpage)) {
                    $title[] = $uvlpage;
                }
                break;
                
            case 'search':
                $title[] = JText::_('Search');
                
                // Pagination
                if (isset($qsvpage)) {
                    $title[] = $qsvpage;
                }
                
                if (isset($task)) {
                    if ($task == 'gsitemapindex') {
                        $title[] = JText::_('Sitemap');
                    }
                    unset($task);
                }
                break;
                
            case 'main':
                // Pagination
                if (isset($lvpage)) {
                    // Latest
                    $title[] = JText::_('Latest');
                    $title[] = $lvpage;
                }
                else if (isset($mvvpage)) {
                    // Most viewed
                    $title[] = JText::_('Most viewed');
                    $title[] = $mvvpage;
                }
                else if (isset($hrvpage)) {
                    // Highest rated
                    $title[] = JText::_('Highest rated');
                    $title[] = $hrvpage;
                }
                else if (isset($fvpage)) {
                    // Featured
                    $title[] = JText::_('Featured');
                    $title[] = $fvpage;
                }
                else if (isset($catpage)) {
                    // Highest rated
                    $title[] = JText::_('Categories');
                    $title[] = $catpage;
                }
                break;
            }
        }
        else
        {
            // Older versions
            
            // Find catid for item id
            if (isset($id)) {
                $item = $this->GetItemInfo($id, true);
                if (!isset($catid)) {
                    $catid = $this->GetParentId($item->catid);
                }           
            }
    
            // Create nested categories
            if (isset($catid)) {
                $title = array_merge($title, $this->GetCategories($catid, '#__seyret_categories'));
            }
    
            // Add item title
            if (isset($item)) {
                $title[] = $item->title;
            
                // Add Google News number if set to
                if ($this->params->get('googlenewsnum', '0') != '0' && isset($id)) {
                    $i = count($title) - 1;
                    $title[$i] = $this->GoogleNews($title[$i], $id);
                }
            }        
            
            // Set the text according to task
            if (isset($task) && in_array($task, array_keys($tasks))) {
                if ($tasks[$task] != '') {
                    $title[] = $tasks[$task];
                }
    
                switch($task) {
                    case 'uservideoslist':
                        // Add username if userid given
                        if( isset($userid) ) {
                            $user = $this->GetUserInfo($userid);
                            if( isset($user) ) {
                                $title[] = $user->username;
                            }
                        }
                        break;
                }
    
                unset($task);
            }
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);

            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, null, null, @$lang, $this->nonSefVars, $this->ignoreVars);
        }

        return $newUri;
    }

}
?>
