/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

var VMSMS = VMSMS || {};

VMSMS.buyCredit = function() {
    var form = document.getElementById('buyCreditForm');
    
    var credit = document.getElementById('credit_amount');
    var amount = credit[credit.selectedIndex].value;
    
    if (amount == '') {
        alert(this.txtErrSelectCredit);
        return;
    }
    
    form.credit.value = amount;
    form.submit();
}

VMSMS.sendCustomSMS = function() {
    var phone = document.getElementById('sms_phone').value;
    var text = document.getElementById('sms_text').value;
    
    if (phone == '' || text == '') {
        alert(this.txtErrFillPhoneText);
        return;
    }
    
    document.getElementById('sms_send').disabled = true;
    document.getElementById('ajax_working').style.display = 'inline';
    document.getElementById('ajax_err').style.display = 'none';
    document.getElementById('ajax_success').style.display = 'none';
    
    var postData = 'option=com_vmsms&controller=ajax&task=send_custom_sms&phone=' + encodeURIComponent(phone) + '&text=' + encodeURIComponent(text);
    new Ajax('index.php', {
        method: 'post',
        data: postData,
        onComplete: function(response) {
            var data = Json.evaluate(response);
            
            document.getElementById('sms_send').disabled = false;
            document.getElementById('ajax_working').style.display = 'none';
            
            if (data.success) {
                document.getElementById('ajax_success').style.display = 'inline';
            }
            else {
                document.getElementById('ajax_err').innerHTML = data.err;
                document.getElementById('ajax_err').style.display = 'inline';
            }
        }
    }).request();
}

/**
 * Auto complete
 */
VMSMS.autoCompleteShown = false;
VMSMS.autoCompleteElement = null;
VMSMS.timerId = 0;
VMSMS.timeOut = 250;
VMSMS.autoCompleteId = 'vmsms_autocomplete';
VMSMS.selectedItem = -1;
VMSMS.autoCompleteWidth = '200px';

VMSMS.hideAutoComplete = function() {
    if (this.timerId) {
        clearTimeout(this.timerId);
    }
    
    var ul = document.getElementById(this.autoCompleteId);
    
    if (ul) {
        ul.style.display = 'none';
    }
    
    this.autoCompleteShown = false;
}

VMSMS.showAutoComplete = function(el, e, task) {
    if (e.keyCode == 37 ||  // arrows
        e.keyCode == 38 ||
        e.keyCode == 39 ||
        e.keyCode == 40 ||
        e.keyCode == 13 ||  // enter
        e.keyCode == 33 ||  // page up
        e.keyCode == 34 ||  // page down
        e.keyCode == 35 ||  // end
        e.keyCode == 36 ||  // home
        e.keyCode == 45 ||  // insert
        e.keyCode == 16 ||  // shift
        e.keyCode == 17 ||  // shift
        e.keyCode == 20 ||  // caps lock
        e.keyCode == 144)   // num lock
    {
        return;
    }
    
    if (e.keyCode == 27) { // escape
        this.hideAutoComplete();
        return;
    }
    
    this.autoCompleteElement = el;
    
    if (this.timerId) {
        clearTimeout(this.timerId);
    }
    
    if (el.value.length < 1) {
        this.hideAutoComplete();
        return;
    }
    
    this.timerId = setTimeout('VMSMS.searchData(\''+task+'\');', this.timeOut);
}

VMSMS.handleKey = function(e) {
    var code;
    
    code = e.keyCode;
    
    if (this.autoCompleteShown) {
        var ul = document.getElementById(this.autoCompleteId);
        
        // Enter
        if (code == 13) {
            if (this.selectedItem > -1) {
                ul.childNodes[this.selectedItem].onmousedown();
                this.hideAutoComplete();
            }
            return false;
        }
        // Tab
        else if (code == 9) {
            if (this.selectedItem > -1) {
                ul.childNodes[this.selectedItem].onmousedown();
                this.hideAutoComplete();
            }
        }
        // Up or Down arrow
        else if (code == 38 || code == 40) {
            var newItem = this.selectedItem;
            
            if (code == 38) {
                newItem--;
            }
            else {
                newItem++;
            }
            if (newItem < 0) {
                newItem = ul.childNodes.length - 1;
            }
            else if (newItem >= ul.childNodes.length) {
                newItem = 0;
            }
            ul.childNodes[newItem].onmouseover();
        }
    }
    else {
        if (code == 13) {
            return false;
        }
    }
    
    return true;
}

VMSMS.searchData = function(task) {
    var postData = 'option=com_vmsms&controller=ajax&task=' + encodeURIComponent(task) + '&req=' + encodeURIComponent(this.autoCompleteElement.value);
    new Ajax('index.php', {
        method: 'post',
        data: postData,
        onComplete: function(response) {
            var data = Json.evaluate(response);
            
            var ul = document.getElementById(VMSMS.autoCompleteId);
            if (!ul) {
                return;
            }
            
            // Remove all the nodes
            while (ul.childNodes.length > 0) {
                ul.removeChild(ul.childNodes[0]);
            }
            VMSMS.selectedItem = -1;
            
            // Check if there are any data
            if (data.length == 0) {
                VMSMS.hideAutoComplete();
                return;
            }
            
            // Build new nodes
            for (var i = 0, n = data.length; i < n; i++) {
                var newLi = document.createElement('li');
                newLi.innerHTML = data[i].text;
                newLi.data = data[i].data;
                newLi.index = i;
                
                newLi.onmouseover = function() {
                    if (VMSMS.selectedItem > -1) {
                        var ul = document.getElementById(VMSMS.autoCompleteId);
                        VMSMS.removeClass(ul.childNodes[VMSMS.selectedItem], 'selected');
                    }
                    VMSMS.addClass(this, 'selected');
                    VMSMS.selectedItem = this.index;
                }
                newLi.onmousedown = function() {
                    VMSMS.autoCompleteElement.value = this.data;
                }
                
                ul.appendChild(newLi);
            }
    
            // List position
            ul.style.left = VMSMS.realLeft(VMSMS.autoCompleteElement) + 'px';
            ul.style.top = (VMSMS.realTop(VMSMS.autoCompleteElement) + VMSMS.autoCompleteElement.offsetHeight) + 'px';
            //ul.style.width = (VMSMS.autoCompleteElement.clientWidth * 2) + 'px';
            ul.style.width = VMSMS.autoCompleteWidth;
            ul.style.display = 'block';
            
            VMSMS.autoCompleteShown = true;
        }
    }).request();
}

VMSMS.realLeft = function(el) {
    var l = 0;
    while(el) {
        l += el.offsetLeft;
        el = el.offsetParent;
    }
    return l;
}

VMSMS.realTop = function(el) {
    var t = 0;
    while(el) {
        t += el.offsetTop;
        el = el.offsetParent;
    }
    return t;
}

VMSMS.hasClass = function(el, cl) {
    return (el.className.indexOf(cl) != -1);
}

VMSMS.addClass = function(el, cl) {
    if (!this.hasClass(el, cl)) {
        el.className = (el.className + ' ' + cl);
    }
}

VMSMS.removeClass = function(el, cl) {
    el.className = el.className.replace(new RegExp('(^|\\s)' + cl + '(?:\\s|$)'), '$1');
}

VMSMS.initSmsCounters = function() {
    // Loop through all textarea's and initialize counters
    var areas = document.getElementsByTagName('textarea');
    var re = new RegExp('^userText_|^customerText_|^sms_text$');
    for (var i = 0; i < areas.length; i++) {
        var area = areas[i];
        
        // Check id
        if (!re.test(area.id)) {
            continue;
        }
        
        area.onkeyup = VMSMS.countSms;
        
        // Initialize the counter value
        VMSMS.countSms.apply(area);
    }
}

VMSMS.standardChars = '@£$¥èéùìòÇØøÅåΔ_ΦΓΛΩΠΨΣΘΞÆæßÉ !"#¤%&\'()*+,-./0123456789:;<=>?¡ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÑÜ§¿abcdefghijklmnopqrstuvwxyzäöñüà';
VMSMS.doubleChars = '^{}\\[~]|€';

/**
 * Gets called on textarea's onkeyup event
 */
VMSMS.countSms = function() {
    var txt = this.value;
    var cnt = 0;
    
    // Count placeholders
    cnt += VMSMS.countSpecials(txt, /%customer%/g) * 15;
    txt = txt.replace('%customer%', '');
    cnt += VMSMS.countSpecials(txt, /%order_nr%/g) * 6;
    txt = txt.replace('%order_nr%', '');
    cnt += VMSMS.countSpecials(txt, /%order_total%/g) * 5;
    txt = txt.replace('%order_total%', '');
    cnt += VMSMS.countSpecials(txt, /%delivery_date%/g) * 10;
    txt = txt.replace('%delivery_date%', '');
    
    // Count the characters
    var len = txt.length;
    var sms = 0;
    var addCnt = 0;
    var maxChars = 160;
    for (var i = 0; i < len; i++) {
        var ch = txt[i];
        if (VMSMS.standardChars.indexOf(ch) != -1) {
            addCnt += 1;
        }
        else if (VMSMS.doubleChars.indexOf(ch) != -1) {
            addCnt += 2;
        }
        else {
            // Unicode character found
            if (VMSMS.allowUnicode) {
                // Send as Unicode SMS
                addCnt = len;
                maxChars = 70;
                break;
            }
            else {
                // Count as one character (will be replaced or stripped)
                addCnt += 1;
            }
        }
    }
    cnt += addCnt;
    
    if (cnt > maxChars) {
        // 7 chars for concatenation in each message
        sms = Math.ceil(cnt / (maxChars - 7));
    }
    else {
        sms = 1;
    }
    
    var span = document.getElementById('sms_counter_' + this.id);
    span.innerHTML = cnt + ' / ' + sms;
}

VMSMS.countSpecials = function(txt, special) {
    // Count occurrences
    var matches = txt.match(special);
    if (matches == null) {
        return 0;
    }
    
    return matches.length;
}