<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

/**
 * VM SMS autorun plugin
 */
class plgSystemVmsmsautorun extends JPlugin
{
    var $filename;
    var $nextrun;

    function plgSystemVmsmsautorun (&$subject)
    {
        parent::__construct($subject);
        
        // get filename
        $mainframe = JFactory::getApplication();
        $dirname = JPath::clean(trim($mainframe->getCfg('tmp_path') ? $mainframe->getCfg('tmp_path') : $mainframe->getCfg('config.tmp_path')));
        if (!is_writeable($dirname) && function_exists('sys_get_temp_dir'))
            $dirname = sys_get_temp_dir();
        $this->filename = $dirname . DS . 'vmsmsautorun.log';
        
        // check if file exists
        $this->nextrun = file_exists($this->filename) ? file_get_contents($this->filename) : false;
    }

    /**
     * After document was rendered.
     */
    function onAfterRender ()
    {
        if (!$this->nextrun || (time() >= $this->nextrun)) {
            $this->setNextRunTime();
            $this->runNow();
        }
    }

    /**
     * 
     * Initiate SMS sending now.
     */
    function runNow ()
    {
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/orderchecker.php');
        VmsmsOrderChecker::checkOrders();
    }

    /**
     * 
     * Set next run time by writing it into file.
     */
    function setNextRunTime ()
    {
        // TODO: add params to component configuration
        
        // load sending period settings
        $hr = 0; //$params->get('pre_def_time_h');
        $min = 10; //$params->get('pre_def_time');
        
        $lastrun = time();
        $nextrun = $lastrun + (60 * $min + (3600 * $hr));
        
        // write next runtime to file
        file_put_contents($this->filename, $nextrun);
    }

}
?>