<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.filesystem.file');

class pkg_vmsmsInstallerScript
{
    private $newInstall;
    
    public function preflight($type, $parent)
    {
        $this->newInstall = !Jfile::exists(JPATH_ADMINISTRATOR.'/components/com_vmsms/vmsms.xml');
    }
    
    public function install($parent)
    {
        $app = JFactory::getApplication();
            
        // Load the language file
        $lng = JFactory::getLanguage();
        $lng->load('com_vmsms');
        
        // Check if VirtueMart is installed
        if (!JFile::exists(JPATH_ADMINISTRATOR.'/components/com_virtuemart/admin.virtuemart.php')) {
            // Display message
            $app->enqueueMessage(JText::_('COM_VMSMS_VM_NOT_INSTALLED'), 'notice');
        }
        else {
            // VM Installed, check if this is new installation
            if ($this->newInstall) {
                $countrySet = false;
                
                // New installation, get VM shop owner user
                $db = JFactory::getDbo();
                $db->setQuery("SELECT `virtuemart_user_id` FROM `#__virtuemart_vmusers` WHERE `virtuemart_vendor_id` = 1");
                $uid = intval($db->loadResult());
                if ($uid > 0) {
                    // Get VM shop owner country code
                    $q = "SELECT c.`country_name`, c.`country_3_code`"
                        ." FROM `#__virtuemart_userinfos` u"
                        ." INNER JOIN `#__virtuemart_countries` c ON (c.virtuemart_country_id = u.virtuemart_country_id)"
                        ." WHERE u.`virtuemart_user_id` = {$uid} AND u.`address_type` = 'BT'";
                    $db->setQuery($q);
                    $country = $db->loadObject();
                    if (is_object($country)) {
                        $code = $country->country_3_code;
                        
                        // Try to obtain country calling code
                        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/helper.php');
                        $dial = VmsmsHelper::getCountryDialCode($code);
                        if ($dial !== false) {
                            // Set local country to VM SMS configuration
                            require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/config.php');
                            $config = VmsmsConfig::getInstance();
                            $config->localCountry = array('country_code' => $code, 'dial_code' => $dial);
                            $config->save();
                            
                            $app->enqueueMessage(JText::sprintf('COM_VMSMS_SET_LOCAL_COUNTRY', $country->country_name), 'notice');
                            $countrySet = true;
                        }
                    }
                }
                
                if (!$countrySet) {
                    $app->enqueueMessage(JText::_('COM_VMSMS_LOCAL_COUNTRY_NOT_SET'), 'notice');
                }
            }
        }
        
        // Load requried CSS - we can't load it through JDocument, because the text
        // is displayed after redirect, so it doesn't have an effect
        echo '<link rel="stylesheet" href="'.JURI::base(true).'/components/com_vmsms/assets/css/general.css'.'" type="text/css" />';
        
        // Display the How to start tutorial
        ?>
        <h1>How to Start</h1>
        <div class="hts_tile">
            <h2>Step 1: Register ARTIO account</h2>
            <p>If you already have an ARTIO website account, just <a href="http://www.artio.net/user-login/login" target="_blank">log in</a> and continue with Step 2.</p>
            <p>Otherwise, <a href="http://www.artio.net/user-login/create-an-account" target="_blank">register</a> a new ARTIO website account:</p>
            <p class="img">
                <a href="components/com_vmsms/assets/images/register.png" class="modal">
                    <img src="components/com_vmsms/assets/images/register.png" alt="Registration" width="250" />
                </a>
            </p>
        </div>
        <div class="hts_tile">
            <h2>Step 2: Activate SMS Services</h2>
            <p>Once you are logged in to ARTIO website, <a href="http://www.artio.net/sms-services/activation" target="_blank">activate</a> an SMS Service account:</p>
            <p class="img">
                <a href="components/com_vmsms/assets/images/activate.png" class="modal">
                    <img src="components/com_vmsms/assets/images/activate.png" alt="Activation" width="250" />
                </a>
            </p>
        </div>
        <div class="hts_tile">
            <h2>Step 3: Charge initial credit</h2>
            <p>If you select to charge initial credit during previous step, you will be taken to the checkout page, so just finish the order:</p>
            <p class="img">
                <a href="components/com_vmsms/assets/images/checkout.png" class="modal">
                    <img src="components/com_vmsms/assets/images/checkout.png" alt="Initial credit" width="250" />
                </a>
            </p>
        </div>
        <div class="hts_tile">
            <h2>Step 4: Find your API key</h2>
            <p><a href="http://www.artio.net/sms-services/dashboard" target="_blank">Open</a> your SMS Service dashboard and find your username and API key:</p>
            <p class="img">
                <a href="components/com_vmsms/assets/images/apikey.png" class="modal">
                    <img src="components/com_vmsms/assets/images/apikey.png" alt="API key" width="250" />
                </a>
            </p>
        </div>
        <div class="hts_tile">
            <h2>Step 5: Set your API key</h2>
            <p>Then <a href="index.php?option=com_vmsms&amp;view=config" target="_blank">open</a> your new ARTIO VM SMS Configuration page and set your username, API key and the fields your VM users use for phone numbers:</p>
            <p class="img">
                <a href="components/com_vmsms/assets/images/basic_config.png" class="modal">
                    <img src="components/com_vmsms/assets/images/basic_config.png" alt="Basic Configuration" width="250" />
                </a>
            </p>
        </div>
        <div class="hts_tile">
            <h2>Step 6: Configure SMS</h2>
            <p>Still on the ARTIO VM SMS Configuration page, set if you want to send SMS to you or your customer for each VM status:</p>
            <p class="img">
                <a href="components/com_vmsms/assets/images/sms_config.png" class="modal">
                    <img src="components/com_vmsms/assets/images/sms_config.png" alt="SMS Configuration" width="250" />
                </a>
            </p>
        </div>
        <div class="hts_tile">
            <h2>Step 7: You're ready to go!</h2>
            <p>Congratulations, you've successfully set up your ARTIO VM SMS!</p>
            <p>You can now continue to the ARTIO VM SMS dashboard: <a href="index.php?option=com_vmsms">ARTIO VM SMS Dashboard</a></p>
        </div>
        <div class="clear"></div>
        <?php
        
        return true;
    }
}
