<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsView extends JViewLegacy
{
    public function display($tpl = null)
    {
        // Load CSS
        $doc = JFactory::getDocument();
        $doc->addStylesheet(JURI::base(true).'/components/com_vmsms/assets/css/general.css');
        if (version_compare(JVERSION, '3.0', '>=')) {
            $doc->addStyleSheet(JURI::base(true).'/components/com_vmsms/assets/css/joomla3.css');
        }

        // Load JS
        $doc->addScript(JURI::base(true).'/components/com_vmsms/assets/js/vmsms.js');

		// Manual JS
        $config = VmsmsConfig::getInstance();
		$js = '
var VMSMS = VMSMS || {};
VMSMS.allowUnicode = '.json_encode(intval($config->allowUnicode)).';
VMSMS.txtErrSelectCredit = '.json_encode(JText::_('COM_VMSMS_ERR_SELECT_CREDIT')).';
VMSMS.txtErrFillPhoneText = '.json_encode(JText::_('COM_VMSMS_ERR_CUSTOM_SMS_PHONE_TEXT')).';
';
		$doc->addScriptDeclaration($js);

        // Load JS framework
        JHtml::_('behavior.framework');

        parent::display($tpl);
    }

    public function label($name, $label)
    {
        $for = (empty($name) ? '' : 'for="'.$name.'"');
        $html = '<label '.$for.' class="hasTip" title="'.JText::_($label.'_TIP').'">'.JText::_($label).':</label>';

        return $html;
    }
}
