<?php
/**
 * Contacts SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

global $mosConfig_absolute_path;

if( !function_exists('sef_contacts_getCategoryTitle') ) {
    function sef_contacts_getCategoryTitle($id) {
        global $database;
        
        $database->setQuery("SELECT `id`, `title` FROM `#__categories` WHERE `id` = $id");
        $database->loadObject($cat);
        if($cat)
            return $cat->title;
        else
            return null;
    }
}

if( !function_exists('sef_contacts_getContactName') ) {
    function sef_contacts_getContactName($id) {
        global $database;
        
        // JOIN cannot be used for JoomFish to work properly
        $database->setQuery("SELECT `id`, `name`, `catid` FROM `#__contact_details` WHERE `id` = $id");
        $database->loadObject($contact);
        if($contact)
            return array( sef_contacts_getCategoryTitle($contact->catid), $contact->name );
        else
            return array();
    }
}

// Extract variables
extract($vars);
$title = array();

$title[] = getMenuTitle(@$option, @$task, @$Itemid);

if( isset($catid) ) {
    $title[] = sef_contacts_getCategoryTitle($catid);
}
if( isset($task) ) {
    if( $task == 'view' ) {
        $title = array_merge( $title, sef_contacts_getContactName($contact_id) );
        unset($task);
    }
}

if (count($title) > 0) {
    $string = sef_404::sefGetLocation($string, $title, @$task, null, null, @$lang);
}
?>