<?php

/**
 * @version     $Id$
 * @package     ARTIO Booking
 * @subpackage  models
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

class BookingModelEmail extends JModelAdmin
{
    public $id;
    public $subject;
    public $body;
    public $sms;
    public $pdf;
    public $mode;
    public $usage;
    public $checked_out;
    public $checked_out_time;

    /**
     * (non-PHPdoc)
     * @see JModelForm::getForm()
     */
    public function getForm($data = array(), $loadData = true)
    {
        $form = $this->loadForm('com_booking.email', 'email', array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form))
            return false;
        return $form;
    }

    /**
     * (non-PHPdoc)
     * @see JModelForm::loadFormData()
     */
    protected function loadFormData()
    {
        $data = JFactory::getApplication()->getUserState('com_booking.edit.email.data', array());
        if (empty($data))
            $data = $this->getItem();
        return $data;
    }

    /**
     * Get this object instance filled by data from the database.
     *
     * @param int $pk database row primary key
     * @return BookingModelEmail
     */
    public function getItem($pk = null)
    {
        $this->setProperties(parent::getItem($pk)->getProperties());
        return $this;
    }

    public function send($emailAddress, $emailSubject, $emailBody, $emailAttachments, $smsPhoneNumber, $smsBody, $pdfFileContent)
    {
        $app = JFactory::getApplication();
        $config = AFactory::getConfig();

        $emailSubject = $emailSubject ?: $this->subject;
        $emailBody = $emailBody ?: $this->body;
        $emailAttachments = array_filter((array)$emailAttachments);

        if (trim($pdfFileContent)) {
            if (!class_exists('TCPDF')) { // maybe Bookinginvoices are used
                require_once(JPath::clean(JPATH_COMPONENT_SITE . '/assets/libraries/tcpdf/tcpdf.php'));
            }

            $pdf = new TCPDF();

            $pdf->SetFont('freesans', '', 12, JPath::clean(JPATH_COMPONENT_SITE . '/assets/libraries/tcpdf/fonts/freesans.php'), true);

            $pdf->SetTitle($emailSubject);
            $pdf->SetCreator($app->getCfg('sitename'));
            $pdf->SetAuthor($app->getCfg('sitename'));
            $pdf->SetKeywords($app->getCfg('sitename'));
            $pdf->setPrintHeader(false);

            $locale = JFactory::getLanguage()->getLocale();
            $pdf->setLanguageArray(array('a_meta_charset' => 'UTF-8', 'a_meta_dir' => 'ltr', 'a_meta_language' => $locale[4], 'w_page' => JText::_('JPage')));

            $pdf->AddPage();

            $pdf->writeHTMLCell('', '', '', '', str_replace('src="images/', 'src="' . JUri::root() . 'images/', $pdfFileContent));

            $filePath = $app->getCfg('tmp_path') . '/' . $emailSubject . '.pdf';

            $pdf->Output($filePath, 'F');
            $emailAttachments[] = $filePath;
        }

        if ($emailAddress && trim($emailSubject) && ($this->usage == NOTIFY_EMAIL || $this->usage == NOTIFY_ALL)) {
            JFactory::getMailer()->sendMail($app->getCfg('mailfrom'), $app->getCfg('fromname'), $emailAddress, $emailSubject, $emailBody, $this->mode, null, null, $emailAttachments);
        }
        if (trim($smsPhoneNumber) && trim($smsBody) && ($this->usage == NOTIFY_SMS || $this->usage == NOTIFY_ALL)) {
            ASmsService::getInstance()->sendMessage($config->smsUsername, $config->smsApikey, AUtils::getLocalPhone($smsPhoneNumber), $smsBody, $config->smsUnicode);
        }
        if (!empty($filePath)) {
            JFile::delete($filePath);
        }
    }
}