<?php

/**
 * Select item template form.
 *
 * @package     ARTIO Booking
 * @subpackage  views
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSelectTemplate */

ADocument::addScriptPropertyDeclaration('templatesCount', count($this->templates));

JToolBarHelper::title(JText::_('NEW_ITEM'), 'module');

$bar = JToolBar::getInstance();
$bar->appendButton('ALink', 'new', 'USE_EXIST_TEMPLATE', 'SelectTemplate.select()');
$bar->appendButton('ALink', 'default', 'NEW_TEMPLATE', 'SelectTemplate.newTmp()');
$bar->appendButton('ALink', 'cancel', 'CANCEL', 'SelectTemplate.cancel()');
$bar->render();

echo AHtml::renderToolbarBox();
?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
    <?php if ($this->templates) { ?>
        <fieldset class="adminList">
            <legend><?php echo JText::_('EXIST_TEMPLATES') ?></legend>
            <table>
                <?php foreach ($this->templates as $i => $template) { ?>
                    <tr>
                        <td>
                            <input type="radio" class="inputRadio" id="template<?php echo $i ?>" name="template"
                                   value="<?php echo $template->id ?>"/>
                        </td>
                        <td>
                            <label for="template<?php echo $i ?>"><?php echo $template->name ?></label>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </fieldset>
    <?php } ?>
    <input type="hidden" name="option" value="<?php echo OPTION ?>"/>
    <input type="hidden" name="controller" value="<?php echo CONTROLLER_SUBJECT ?>"/>
    <input type="hidden" name="task" value="add"/>
    <input type="hidden" name="templatesCount" value="<?php echo count($this->templates) ?>"/>
</form>