<?php
/**
 * Manager reservation form.
 * 
 * @package	ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2015 ARTIO Ltd. All rights reserved.
 * @author 	ARTIO Ltd., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */
defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservation */

$config = AFactory::getConfig();
$user = JFactory::getUser();
?>
<h1><?php echo $this->reservation->id ? JText::sprintf('RESERVATION_NUM', $this->reservation->id) : JText::_('ADD_RESERVATION'); ?></h1>
<div class="edit item-page">
    <form action="<?php echo JRoute::_('index.php'); ?>" method="post" name="adminForm" id="adminForm">
        <div class="bookingToolbar">
            <a class="aIconToolSave tool save" title="<?php echo JText::_('JSave', true); ?>" href="javascript:submitbutton('save')"><?php echo JText::_('JSave', true); ?></a>
            <a class="aIconToolApply tool apply" title="<?php echo JText::_('JApply', true); ?>" href="javascript:submitbutton('apply')"><?php echo JText::_('JApply', true); ?></a>
            <a class="aIconToolCancel tool cancel" title="<?php echo JText::_('JCancel', true); ?>" href="<?php echo JRoute::_(ARoute::view(VIEW_RESERVATIONS)); ?>"><?php echo JText::_('JCancel', true); ?></a>
            <div class="clr"></div>
        </div>
        <fieldset>
            <legend><?php echo JText::_('CUSTOMER'); ?></legend>
            <div class="row-fluid">
                <div class="formelm span12">	
                    <label><?php echo JText::_('CUSTOMER'); ?>:</label>
                    <?php echo JElementCustomer::fetchElement($this->reservation->customer); ?>
                </div>
            </div>
            <div class="row-fluid">
                <div class="formelm span6">
                    <label for="title_before"><?php echo JText::_('TITLE_BEFORE'); ?>: </label>
                    <input type="text" name="title_before" id="title_before" maxlength="255" value="<?php echo $this->reservation->title_before; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="firstname"><?php echo JText::_('FIRST_NAME'); ?>: </label>
                    <input type="text" name="firstname" id="firstname" maxlength="255" value="<?php echo $this->reservation->firstname; ?>" />
                </div>
            </div>
            <div class="row-fluid">
                <div class="formelm span6">
                    <label for="middlename"><?php echo JText::_('MIDDLE_NAME'); ?>: </label>
                    <input type="text" name="middlename" id="middlename" maxlength="255" value="<?php echo $this->reservation->middlename; ?>" />
                </div>	
                <div class="formelm span6">
                    <label for="surname"><?php echo JText::_('SURNAME'); ?>: </label>
                    <input type="text" name="surname" id="surname" maxlength="255" value="<?php echo $this->reservation->surname; ?>" />
                </div>
            </div>
            <div class="row-fluid">                    
                <div class="formelm span6">
                    <label for="title_after"><?php echo JText::_('TITLE_AFTER'); ?>: </label>
                    <input type="text" name="title_after" id="title_after" maxlength="255" value="<?php echo $this->reservation->title_after; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="company"><?php echo JText::_('COMPANY'); ?>: </label>
                    <input type="text" name="company" id="company" maxlength="255" value="<?php echo $this->reservation->company; ?>" />
                </div>
            </div>
            <div class="row-fluid">                    
                <div class="formelm span6">
                    <label for="company_id"><?php echo JText::_('COMPANY_ID'); ?>: </label>
                    <input type="text" name="company_id" id="company_id" maxlength="255" value="<?php echo $this->reservation->company_id; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="vat_id"><?php echo JText::_('VAT_ID'); ?>: </label>
                    <input type="text" name="vat_id" id="vat_id" maxlength="255" value="<?php echo $this->reservation->vat_id; ?>" />
                </div>
            </div>
            <div class="row-fluid">                    
                <?php foreach ($this->getCustomFields() as $i => $field) { ?>
                    <?php if ($i && $i % 2 == 0) { ?>
                    </div>
                    <div class="row-fluid">                    
                    <?php } ?>
                    <div class="formelm span6">
                        <label for="<?php echo $field['name']; ?>"><?php echo $field['title']; ?>: </label>
                        <?php echo AHtml::getField($field, $this->reservation->fields); ?>
                    </div>
                    <?php
                }
                if (!$this->reservation->id) {
                    ?>
                    <div class="formelm">
                        <label for="notify_customer"><?php echo JText::_('NOTIFY_CUSTOMER_BY_E_MAIL'); ?>: </label>
                        <input type="checkbox" name="notify_customer" id="notify_customer" value="1" />
                    </div>
                <?php } ?>
            </div>
        </fieldset>
        <?php if ($config->rsMoreNames == 1) { ?>
            <div class="addMore" id="addMoreButton" onclick="ViewReservation.addMoreNames()" style="display: <?php echo empty($this->reservation->more_names) ? 'block' : 'none'; ?>">
                <?php echo JText::_('ADD_MORE_CUSTOMERS'); ?>
            </div>
            <div class="clr"></div>
            <fieldset id="addMoreNames" class="addMoreNames" style="display: <?php echo empty($this->reservation->more_names) ? 'none' : 'block'; ?>">
                <legend><?php echo JText::_('MORE_CUSTOMERS'); ?></legend>
                <?php
                if (!empty($this->reservation->more_names)) {
                    foreach ($this->reservation->more_names as $name) {
                        ?>
                        <input type="text" name="more_names[]" value="<?php echo $this->escape($name); ?>" />
                        <?php
                    }
                } else {
                    ?>
                    <input type="text" name="more_names[]" value="" />
                    <input type="text" name="more_names[]" value="" />
                    <input type="text" name="more_names[]" value="" />
                <?php } ?>
                <div class="addNext" id="addNextButton" onclick="ViewReservation.addNextName()">
                    <?php echo JText::_('ADD_NEXT'); ?>
                </div>
                <div class="hideAddMore" onclick="ViewReservation.hideAddMoreNames()">
                    <?php echo JText::_('HIDE_ADD_MORE_CUSTOMERS'); ?>
                </div>                                        
            </fieldset>
        <?php } ?>
        <div id="reservedItems">
            <?php
            if ($this->ajaxForItems) {
                ob_clean();
                ob_start();
            }
            ?>
            <?php
            $z = 0;
            $countReservedItems = count($this->reservedItems);
            if ($countReservedItems)
                foreach ($this->reservedItems as $key => $reservedItem) {
                    /* @var $reservedItem TableReservationItems */
                    TableReservationItems::display($reservedItem);
                    $id = $z++;
                    $iID = (int) $reservedItem->id;
                    $subject = $this->subjects[$reservedItem->subject];
                    ?>
                    <fieldset id="reservationItem<?php echo $reservedItem->id ? $reservedItem->id : $key; ?>">
                        <legend><?php echo $reservedItem->subject_title; ?></legend>

                        <input type="hidden" name="id[<?php echo $id ?>]" value="<?php echo $reservedItem->id ?>">
                        <input type="hidden" name="subject[<?php echo $id ?>]" value="<?php echo $reservedItem->subject ?>">
                        <input type="hidden" name="subject_title[<?php echo $id ?>]" value="<?php echo $reservedItem->subject_title ?>">
                        <input type="hidden" name="rtype[<?php echo $id ?>]" value="<?php echo $reservedItem->rtype ?>">
                        <input type="hidden" name="ctype[<?php echo $id ?>]" value="<?php echo empty($reservedItem->ctype) ? '' : $reservedItem->ctype ?>" />
                        <?php if (!empty($reservedItem->boxIds)) { ?>
                            <?php foreach ($reservedItem->boxIds as $bid) { ?>
                                <input type="hidden" name="boxIds[<?php echo $id ?>][]" value="<?php echo $bid; ?>" />
                            <?php } ?>
                        <?php } else { ?>
                            <input type="hidden" name="boxIds[<?php echo $id ?>][]" value="" />
                        <?php } ?>

                        <div class="formelm">
                            <label></label>
                            <a class="aIconLegend aIconUnpublish" href="javascript:removeReservationItem('<?php echo $reservedItem->id ? $reservedItem->id : $key; ?>', '<?php echo (int) $this->reservation->id; ?>')" title=""><?php echo JText::_('REMOVE_ITEM'); ?></a>
                        </div>
                        <div class="row-fluid">
                            <div class="formelm span6">
                                <label for="subject_title[<?php echo $id ?>]"><?php echo JText::_('SUBJECT_TITLE'); ?>: </label>
                                <input type="text" name="subject_title[<?php echo $id ?>]" id="itemTitle<?php echo $iID; ?>" maxlength="255" value="<?php echo $reservedItem->subject_title; ?>" readonly="true" />

                                <?php if ($this->reservation->id && $user->authorise('booking.reservation.edit.item', 'com_booking') && $reservedItem->rtype != RESERVATION_TYPE_PERIOD) { ?>
                                    <span id="changeItemSelect<?php echo $iID; ?>"></span>
                                    <a class="aIconEditInline aIconEdit" href="javascript:ViewReservation.openChangeItem(<?php echo $iID; ?>)" id="openChangeItem<?php echo $iID; ?>"></a>
                                    <a class="aIconEditInline aIconTick" href="javascript:ViewReservation.changeItem(<?php echo $iID; ?>)" id="changeItem<?php echo $iID; ?>" style="display: none"></a>
                                    <a class="aIconEditInline aIconUnpublish" href="javascript:ViewReservation.closeChangeItem(<?php echo $iID; ?>)" id="closeChangeItem<?php echo $iID; ?>" style="display: none"></a>
                                <?php } ?>

                            </div>
                            <?php if ($config->parentsBookable == 2) { ?>
                                <div class="formelm span6">	
                                    <label for="sub_subject-<?php echo $id ?>"><?php echo JText::_('SUB_ITEM'); ?>:</label>
                                    <?php echo BookingHelper::getSubjectSelectBox($reservedItem->sub_subject, "sub_subject[$id]", false, $reservedItem->subject); ?>
                                </div>
                            <?php } ?>
                        </div>
                        <?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
                            <div class="row-fluid">
                                <div class="formelm span6">	
                                    <label for="period_time_up[<?php echo $id ?>]"><?php echo JText::_('PERIOD_TIME_UP'); ?>: </label>
                                    <input type="text" value="<?php echo AHtml::date($reservedItem->period_time_up, ATIME_FORMAT, 0); ?>" readonly="readonly" />
                                    <input type="hidden" name="period_time_up[<?php echo $id ?>]" id="period_time_up[<?php echo $id ?>]" value="<?php echo $reservedItem->period_time_up; ?>" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_time_down[<?php echo $id ?>]"><?php echo JText::_('PERIOD_TIME_DOWN'); ?>: </label>
                                    <input type="text" name="period_time_down[<?php echo $id ?>]" value="<?php echo AHtml::date($reservedItem->period_time_down, ATIME_FORMAT, 0); ?>" readonly="readonly" />
                                    <input type="hidden" name="period_time_down[<?php echo $id ?>]" id="period_time_down[<?php echo $id ?>]" value="<?php echo $reservedItem->period_time_down; ?>" />
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	
                                    <label for="period_type[<?php echo $id ?>]"><?php echo JText::_('PERIOD_TYPE'); ?>: </label>
                                    <?php
                                    $options = array(JHtml::_('select.option', '', JText::_('SELECT_PERIOD_TYPE')));
                                    $options[] = JHtml::_('select.option', PERIOD_TYPE_DAILY, JText::_('DAILY'));
                                    $options[] = JHtml::_('select.option', PERIOD_TYPE_WEEKLY, JText::_('WEEKLY'));
                                    $options[] = JHtml::_('select.option', PERIOD_TYPE_MONTHLY, JText::_('MONTHLY'));
                                    $options[] = JHtml::_('select.option', PERIOD_TYPE_YEARLY, JText::_('YEARLY'));
                                    echo JHtml::_('select.genericlist', $options, '', 'disabled="disabled"', 'value', 'text', $reservedItem->period_type);
                                    ?>
                                    <input type="hidden" name="period_type[<?php echo $id ?>]" id="period_type[<?php echo $id ?>]" value="<?php echo $reservedItem->period_type; ?>" />
                                    <input type="hidden" name="period_rtype_id[<?php echo $id; ?>]" value="<?php echo @$reservedItem->period_rtype_id; ?>" />
                                    <input type="hidden" name="period_price_id[<?php echo $id; ?>]" value="<?php echo @$reservedItem->period_price_id; ?>" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_recurrence[<?php echo $id ?>]"><?php echo JText::_('PERIOD_RECURRENCE'); ?>: </label>
                                    <input type="text" name="period_recurrence[<?php echo $id ?>]" id="period_recurrence[<?php echo $id ?>]" value="<?php echo $reservedItem->period_recurrence; ?>" readonly="readonly" />
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	
                                    <label for="period_monday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_MONDAY'); ?>: </label>
                                    <input type="hidden" name="period_monday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_monday[<?php echo $id ?>]" id="period_monday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_monday) { ?>checked="checked"<?php } ?> readonly="readonly" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_tuesday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_TUESDAY'); ?>: </label>
                                    <input type="hidden" name="period_tuesday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_tuesday[<?php echo $id ?>]" id="period_tuesday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_tuesday) { ?>checked="checked"<?php } ?> readonly="readonly" />
                                </div>
                            </div>
                            <div class="row-fluid">                                
                                <div class="formelm span6">	
                                    <label for="period_wednesday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_WEDNESDAY'); ?>: </label>
                                    <input type="hidden" name="period_wednesday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_wednesday[<?php echo $id ?>]" id="period_wednesday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_wednesday) { ?>checked="checked"<?php } ?> readonly="readonly" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_thursday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_THURSDAY'); ?>: </label>
                                    <input type="hidden" name="period_thursday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_thursday[<?php echo $id ?>]" id="period_thursday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_thursday) { ?>checked="checked"<?php } ?> readonly="readonly" />
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	
                                    <label for="period_friday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_FRIDAY'); ?>: </label>
                                    <input type="hidden" name="period_friday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_friday[<?php echo $id ?>]" id="period_friday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_friday) { ?>checked="checked"<?php } ?> readonly="readonly" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_saturday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_SATURDAY'); ?>: </label>
                                    <input type="hidden" name="period_saturday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_saturday[<?php echo $id ?>]" id="period_saturday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_saturday) { ?>checked="checked"<?php } ?> readonly="readonly" />
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	
                                    <label for="period_sunday[<?php echo $id ?>]" class="checkbox inline"><?php echo JText::_('PERIOD_SUNDAY'); ?>: </label>

                                    <input type="hidden" name="period_sunday[<?php echo $id ?>]" value="0" />
                                    <input type="checkbox" name="period_sunday[<?php echo $id ?>]" id="period_sunday[<?php echo $id ?>]" value="1" <?php if ($reservedItem->period_sunday) { ?>checked="checked"<?php } ?> readonly="readonly" />

                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	
                                    <label for="period_month[<?php echo $id ?>]"><?php echo JText::_('PERIOD_MONTH'); ?>: </label>
                                    <?php
                                    $options = array(JHtml::_('select.option', '', JText::_('SELECT_PERIOD_MONTH')));
                                    $options[] = JHtml::_('select.option', 1, JText::_('JANUARY'));
                                    $options[] = JHtml::_('select.option', 2, JText::_('FEBRUARY'));
                                    $options[] = JHtml::_('select.option', 3, JText::_('MARCH'));
                                    $options[] = JHtml::_('select.option', 4, JText::_('APRIL'));
                                    $options[] = JHtml::_('select.option', 5, JText::_('MAY'));
                                    $options[] = JHtml::_('select.option', 6, JText::_('JUNE'));
                                    $options[] = JHtml::_('select.option', 7, JText::_('JULY'));
                                    $options[] = JHtml::_('select.option', 8, JText::_('AUGUST'));
                                    $options[] = JHtml::_('select.option', 9, JText::_('SEPTEMBER'));
                                    $options[] = JHtml::_('select.option', 10, JText::_('OCTOBER'));
                                    $options[] = JHtml::_('select.option', 11, JText::_('NOVEMBER'));
                                    $options[] = JHtml::_('select.option', 12, JText::_('DECEMBER'));
                                    echo JHtml::_('select.genericlist', $options, '', 'disabled="disabled"', 'value', 'text', $reservedItem->period_month);
                                    ?>
                                    <input type="hidden" name="period_month[<?php echo $id ?>]" id="period_month[<?php echo $id ?>]" value="<?php echo $reservedItem->period_month; ?>" />
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	  
                                    <label for="period_week<?php echo $id ?>"><?php echo JText::_('PERIOD_WEEK'); ?>: </label>
                                    <?php
                                    $options = array(JHtml::_('select.option', '', JText::_('SELECT_PERIOD_WEEK')));
                                    $options[] = JHtml::_('select.option', 1, JText::_('J1ST_WEEK'));
                                    $options[] = JHtml::_('select.option', 2, JText::_('J2ND_WEEK'));
                                    $options[] = JHtml::_('select.option', 3, JText::_('J3RD_WEEK'));
                                    $options[] = JHtml::_('select.option', 4, JText::_('J4TH_WEEK'));
                                    echo JHtml::_('select.genericlist', $options, '', 'disabled="disabled"', 'value', 'text', $reservedItem->period_week);
                                    ?>
                                    <input type="hidden" name="period_week[<?php echo $id ?>]" id="period_week[<?php echo $id ?>]" value="<?php echo $reservedItem->period_week; ?>" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_day[<?php echo $id ?>]"><?php echo JText::_('PERIOD_DAY'); ?>: </label>
                                    <?php
                                    $options = array(JHtml::_('select.option', '', JText::_('SELECT_PERIOD_DAY')));
                                    $options[] = JHtml::_('select.option', 1, JText::_('MONDAY'));
                                    $options[] = JHtml::_('select.option', 2, JText::_('Tuesday'));
                                    $options[] = JHtml::_('select.option', 3, JText::_('Wednesday'));
                                    $options[] = JHtml::_('select.option', 4, JText::_('Thursday'));
                                    $options[] = JHtml::_('select.option', 5, JText::_('Friday'));
                                    $options[] = JHtml::_('select.option', 6, JText::_('Saturday'));
                                    $options[] = JHtml::_('select.option', 7, JText::_('SUNDAY'));
                                    echo JHtml::_('select.genericlist', $options, '', 'disabled="disabled"', 'value', 'text', $reservedItem->period_day);
                                    ?>
                                    <input type="hidden" name="period_day[<?php echo $id ?>]" id="period_day[<?php echo $id ?>]" value="<?php echo $reservedItem->period_day; ?>" />
                                </div>
                            </div> 
                            <div class="row-fluid">
                                <div class="formelm span6">	  
                                    <label for="period_end[<?php echo $id ?>]"><?php echo JText::_('PERIOD_END_TYPE'); ?>: </label>
                                    <?php
                                    $options = array(JHtml::_('select.option', '', JText::_('SELECT_PERIOD_END_TYPE')));
                                    $options[] = JHtml::_('select.option', PERIOD_END_TYPE_NO, JText::_('NO_END_DATE'));
                                    $options[] = JHtml::_('select.option', PERIOD_END_TYPE_AFTER, JText::_('END_AFTER_OCCURRENCES'));
                                    $options[] = JHtml::_('select.option', PERIOD_END_TYPE_DATE, JText::_('END_BY_DATE'));
                                    echo JHtml::_('select.genericlist', $options, '', 'disabled="disabled"', 'value', 'text', $reservedItem->period_end);
                                    ?>
                                    <input type="hidden" name="period_end[<?php echo $id ?>]" id="period_end[<?php echo $id ?>]" value="<?php echo $reservedItem->period_end; ?>" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_occurrences[<?php echo $id ?>]"><?php echo JText::_('PERIOD_OCCURRENCES'); ?>: </label>
                                    <input type="text" name="period_occurrences[<?php echo $id ?>]" id="period_occurrences[<?php echo $id ?>]" value="<?php echo $reservedItem->period_occurrences; ?>" readonly="readonly" />
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="formelm span6">	   	
                                    <label for="period_date_up<?php echo $id ?>"><?php echo JText::_('PERIOD_DATE_UP'); ?>: </label>
                                    <input type="text" value="<?php echo AHtml::date($reservedItem->period_date_up, ADATE_FORMAT_NORMAL); ?>" readonly="readonly" />
                                    <input type="hidden" name="period_date_up[<?php echo $id ?>]" id="period_date_up[<?php echo $id ?>]" value="<?php echo $reservedItem->period_date_up; ?>" />
                                </div>
                                <div class="formelm span6">	
                                    <label for="period_date_down<?php echo $id ?>"><?php echo JText::_('PERIOD_DATE_DOWN'); ?>: </label>
                                    <input type="text" value="<?php echo AHtml::date($reservedItem->period_date_down, ADATE_FORMAT_NORMAL); ?>" readonly="readonly" />
                                    <input type="hidden" name="period_date_down[<?php echo $id ?>]" id="period_date_down[<?php echo $id ?>]" value="<?php echo $reservedItem->period_date_down; ?>" />
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="formelm">
                                <?php echo AHtml::intervalLabel($reservedItem); ?>: 
                                <?php echo AHtml::interval($reservedItem); ?>
                                <input type="hidden" name="from[<?php echo $id; ?>]" value="<?php echo $reservedItem->from; ?>" />
                                <input type="hidden" name="to[<?php echo $id; ?>]" value="<?php echo $reservedItem->to; ?>" />
                                <?php if ($this->reservation->id && $user->authorise('booking.reservation.edit.date', 'com_booking')) { ?>
                                    <a class="aIconEditInline aIconEdit" href="javascript:ViewReservation.openChangeDate(<?php echo (int) $reservedItem->subject; ?>, <?php echo (int) $iID; ?>, <?php echo (int) $reservedItem->rtype; ?>)" id="openChangeDate<?php echo $iID; ?>"></a>
                                <?php } ?>
                            </div>    		
                        <?php } ?>
                        <div class="row-fluid">
                            <div class="formelm span6">
                                <label for="capacity<?php echo $id ?>"><?php echo JText::_('CAPACITY'); ?>: </label>
                                <?php 
                                $capacity = AHtml::capacity($subject, ('capacity[' . $id . ']'), 'capacity' . $id, (!$this->reservation->id ? 'onchange="refreshReservation()"' : ''), $reservedItem);
                                echo $capacity['input'] . $capacity['text']; 
                                ?>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="formelm span6">
                                <label for="price"><?php echo ITEM_PRICE_TIP ?>: </label>
                                <input type="text" name="price[<?php echo $id ?>]" id="price[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->price; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                <?php echo $config->mainCurrency; ?>
                            </div>    	
                            <div class="formelm span6">
                                <label for="discount<?php echo $id ?>"><?php echo JText::_('Discount') ?>: </label>
                                <input type="text" name="discount[<?php echo $id ?>]" id="discount<?php echo $id ?>" size="1" maxlength="255" value="<?php echo $reservedItem->discount; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                <?php echo $config->mainCurrency; ?>
                            </div>    	                            
                        </div>
                        <?php if ($config->useShipping) { ?>
                            <hr>
                            <div class="row-fluid">
                                <div class="formelm span6">
                                    <label for="shipping<?php echo $id ?>"><?php echo JText::_('SHIPPING'); ?>:</label>
                                    <?php echo AHtml::shipping($subject->postage, $reservedItem->shipping, $id, !$this->reservation->id); ?>      
                                </div>
                                <div class="formelm span6">
                                    <label for="takeback<?php echo $id ?>"><?php echo JText::_('TAKEBACK'); ?>:</label>
                                    <?php echo AHtml::takeback($subject->postage, $reservedItem->takeback, $id, !$this->reservation->id); ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="row-fluid">
                            <?php
                            $i = 0;
                            foreach ($subject->occupancy_types as $otype) {
                                if ($i && $i % 2 == 0) {
                                    ?>
                                </div>
                                <div class="row-fluid">
                                    <?php
                                }
                                $i++;
                                ?>
                                <div class="formelm span6">
                                    <label for="occupancy<?php echo $otype->id; ?>"><?php echo $otype->title; ?>: </label>
                                    <?php if (!$this->reservation->id) { ?>
                                    <select name="occupancy[<?php echo $id ?>][<?php echo $otype->id; ?>]" <?php if (!$this->reservation->id) { ?>onchange="refreshReservation()"<?php } ?> class="input-mini">
                                            <?php if ($otype->emptyOption) { ?>
                                                <option value="0">-</option>
                                            <?php } ?>
                                            <?php echo JHtml::_('select.options', array_combine(range($otype->min, $otype->max), range($otype->min, $otype->max)), '', '', JArrayHelper::getValue($reservedItem->occupancy, $otype->id)['count']); ?>
                                        </select>
                                        <input type="text" name="occupancy[<?php echo $id ?>][<?php echo $otype->id; ?>][total]" value="<?php echo JArrayHelper::getValue($reservedItem->occupancy, $otype->id)['total']; ?>" size="1" disabled="disabled" class="input-mini"/>
                                        <?php echo $config->mainCurrency; ?>
                                    <?php } else { ?>
                                        <select name="occupancy[<?php echo $id ?>][<?php echo $otype->id; ?>][count]" <?php if (!$this->reservation->id) { ?>onchange="refreshReservation()"<?php } ?>>
                                            <option value="0">-</option>
                                            <?php echo JHtml::_('select.options', array_combine(range($otype->min, $otype->max), range($otype->min, $otype->max)), '', '', $reservedItem->occupancy[$otype->id]['count']); ?>
                                        </select>
                                        <?php if (!empty($reservedItem->occupancy[$otype->id])) { ?>
                                            <?php foreach ($reservedItem->occupancy[$otype->id] as $var => $val) { ?>
                                                <?php if ($var == 'total') { ?>
                                                    <input type="text" name="occupancy[<?php echo $id ?>][<?php echo $otype->id; ?>][<?php echo $var; ?>]" value="<?php echo $val; ?>" size="1" />
                                                    <?php echo $config->mainCurrency; ?>
                                                <?php } elseif ($var != 'count') { ?>
                                                    <input type="hidden" name="occupancy[<?php echo $id ?>][<?php echo $otype->id; ?>][<?php echo $var; ?>]" value="<?php echo $val; ?>" />
                                                <?php } ?>
                                            <?php } ?>
                                        <?php } ?>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                        <?php if (!empty($reservedItem->supplementsRaw)) { ?>
                            <hr/>
                            <div class="row-fluid">
                                <?php
                                foreach ($reservedItem->supplementsRaw as $i => $supplement) {
                                    $value = $capacity = $fullPrice = $discount = null;
                                    foreach ($reservedItem->supplements as $item) {
                                        $toCompare = $this->reservation->id ? $item->supplement : $item->id;
                                        if ($toCompare == $supplement->id) {
                                            $value = $item->value;
                                            $capacity = $item->capacity;
                                            $fullPrice = $item->fullPrice;
                                            $discount = $item->discount;
                                            break;
                                        }
                                    }
                                    if ($i && $i % 2 == 0) {
                                        ?>
                                    </div>
                                    <div class="row-fluid">
                                    <?php } ?>
                                    <div class="formelm span6">
                                        <label><?php echo $supplement->title; ?>: </label>
                                        <div class="pull-left">
                                            <?php echo BookingHelper::displaySupplementInput($supplement, $value, $capacity, $id, ($this->reservation->id ? '' : 'onchange="refreshReservation()"')) ?>
                                        </div>
                                        <div class="pull-left" style="padding: 0 0 10px 10px">
                                            <?php if ($fullPrice)
                                                echo JText::_('FULL') . ': ' . BookingHelper::displayPrice($fullPrice);
                                            if ($discount)
                                                echo '<br>'.JText::_('DISCOUNT') . ': ' . BookingHelper::displayPrice($discount); ?>                                    </div>
                                    </div>  	
                                <?php } ?>                 
                            </div>
                            <hr/>
                        <?php } ?>                 
                        <div class="row-fluid">
                            <div class="formelm span6">	
                                <label for="provision"><?php echo JText::_('PROVISION'); ?>: </label>
                                <input type="text" name="provision[<?php echo $id ?>]" id="provision[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->provision; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                <?php echo $config->mainCurrency; ?>
                            </div>                                                                        
                            <div class="formelm span6">		
                                <label for="deposit"><?php echo ITEM_DEPOSIT_TIP ?>: </label>
                                <input type="text" name="deposit[<?php echo $id ?>]" id="deposit[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->deposit; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                <?php echo $config->mainCurrency; ?>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="formelm span6">	
                                <label for="fullDeposit"><?php echo FULL_DEPOSIT_TIP ?>: </label>
                                <input type="text" name="fullDeposit[<?php echo $id ?>]" id="fullDeposit[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->fullDeposit; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                <?php echo $config->mainCurrency; ?>
                            </div>
                            <div class="formelm span6">		
                                <label for="priceExcludingTax"><?php echo JText::_('TOTAL_PRICE_EXCLUDING_TAX'); ?>: </label>
                                <input type="text" name="priceExcludingTax[<?php echo $id ?>]" id="priceExcludingTax[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo round(BookingHelper::getPriceExcludingTax(null, $reservedItem), 2); ?>" disabled="disabled" />
                                <?php echo $config->mainCurrency; ?>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="formelm span6">	
                                <label for="fullDiscount"><?php echo JText::_('TOTAL_DISCOUNT'); ?>: </label>
                                <input type="text" name="fullDiscount[<?php echo $id ?>]" id="fullDiscount[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->fullDiscount; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                %
                            </div>    		    		    		                            
                            <div class="formelm span6">	
                                <label for="tax"><?php echo JText::_('TAX'); ?>: </label>
                                <input type="text" name="tax[<?php echo $id ?>]" id="tax[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->tax; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                %
                            </div>    		    		    		
                        </div>
                        <div class="row-fluid">
                            <div class="formelm span6">	
                                <label for="fullPriceSupplements"><?php echo FULL_PRICE_TIP ?>: </label>
                                <input type="text" name="fullPriceSupplements[<?php echo $id ?>]" id="fullPriceSupplements[<?php echo $id ?>]" size="1" maxlength="255" value="<?php echo $reservedItem->fullPriceSupplements; ?>" <?php if (!$this->reservation->id) { ?>disabled="disabled"<?php } ?> />
                                <?php echo $config->mainCurrency; ?>
                            </div>
                            <div class="formelm span6">	
                            
                                <label for="message[<?php echo $id ?>]"><?php echo JText::_('Message') ?></label>
                                <textarea rows="5" cols="50" name="message[<?php echo $id ?>]" id="message[<?php echo $id ?>]"><?php echo $reservedItem->message; ?></textarea>
                            </div>
                        </div>
                        <?php
                        if ($config->rsMoreNames > 1) {
                            $persons = $reservedItem->capacity - 1;
                            foreach ($reservedItem->occupancy as $occupancy) {
                                if ($occupancy['count']) {
                                    $persons += $occupancy['count'];
                                }
                            }
                            $inc = $reservedItem->occupancy ? 1 : 2;
                            for ($q = 0; $q < $persons; $q++) {
                                ?>
                                <div class="formelm more_names">
                                    <label>
                                        <?php echo JText::sprintf('PERSON_NUM', ($q + $inc)); ?>:
                                    </label>
                                    <div class="field">
                                        <label for="more_names_firstname<?php echo $id . '-' . $q; ?>">
                                            <?php echo JText::_('FIRST_NAME'); ?>
                                        </label>
                                        <input type="text" name="more_names[<?php echo $id; ?>][<?php echo $q; ?>][firstname]" id="more_names_firstname<?php echo $id . '-' . $q; ?>" value="<?php echo $this->escape(@$reservedItem->more_names[$q]->firstname); ?>" />  
                                    </div>
                                    <div class="field">
                                        <label for="more_names_surname<?php echo $id . '-' . $q; ?>">
                                            <?php echo JText::_('SURNAME'); ?>
                                        </label>
                                        <input type="text" name="more_names[<?php echo $id; ?>][<?php echo $q; ?>][surname]" id="more_names_surname<?php echo $id . '-' . $q; ?>" value="<?php echo $this->escape(@$reservedItem->more_names[$q]->surname); ?>" />
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>      
                        <?php if (!$this->reservation->id) { ?>   
                            <div class="formelm">
                                <button class="button" onclick="return refreshReservation()"><?php echo JText::_('REFRESH'); ?></button>
                            </div> 			
                        <?php } ?>                
                    </fieldset>
                <?php } ?>
            <?php if ($this->ajaxForItems) $ajaxOutput['items'] = ob_get_clean(); ?>
        </div>
        <div id="reservationTotal">
            <?php
            if ($this->ajaxForItems) {
                ob_clean();
                ob_start();
            }
            ?>
            <fieldset>
                <legend><?php echo JText::_('RESERVATION_STATUS_AND_PAYMENT'); ?></legend>
                <div class="row-fluid">
                    <div class="formelm span6">
                        <label for="fax"><?php echo JText::_('PAYMENT_STATUS'); ?>: </label>
                        <?php echo JHtml::_('select.genericlist', BookingHelper::getPaymentStatuses(), 'paid', '', 'id', 'label', $this->reservation->paid); ?>
                    </div>
                    <div class="formelm span6">    	
                        <label for="fax"><?php echo JText::_('RESERVATION_STATUS'); ?>: </label>
                        <?php echo JHtml::_('select.genericlist', BookingHelper::getReservationStatuses(), 'state', '', 'id', 'label', $this->reservation->state); ?>                        
                    </div>
                </div>
                <div class="row-fluid">
                                        <div class="formelm span6">    	
                        <label for="provision"><?php echo JText::_('TOTAL_PROVISION'); ?>: </label>
                        <strong><?php echo BookingHelper::displayPrice($this->reservation->fullProvision); ?></strong>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="formelm span6">    	
                        <?php echo JText::_('DEPOSIT') . ': ' . BookingHelper::displayPrice($this->reservation->fullDeposit); ?></strong>
                    </div>
                    <div class="formelm span6">    	
                        <?php echo JText::_('DEPOSIT_MUST_BE_PAID_BEFORE') . ': ' . $this->depositExpires; ?>			
                    </div>			    		
                </div>
                <div class="row-fluid">
                    <div class="formelm span6">    	
                        <?php echo JText::_('TAX') . ': ' . BookingHelper::displayPrice(BookingHelper::getFullTax($this->reservedItems)); ?>
                    </div>
                    <div class="formelm span6">    	
                        <?php echo JText::_('TOTAL_PRICE') . ': ' . BookingHelper::displayPrice($this->reservation->fullPrice); ?>
                    </div>			
                </div>
            </fieldset>
            <?php
            if ($this->ajaxForItems) {
                $ajaxOutput['total'] = ob_get_clean();
                $ajaxOutput = json_encode($ajaxOutput);
                die($ajaxOutput);
            }
            ?>
        </div>
        <fieldset>
            <legend><?php echo JText::_('CONTACT'); ?></legend>
            <div class="row-fluid">
                <div class="formelm span6">
                    <label for="street"><?php echo JText::_('STREET'); ?>: </label>
                    <input type="text" name="street" id="street" maxlength="255" value="<?php echo $this->reservation->street; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="city"><?php echo JText::_('CITY'); ?>: </label>
                    <input type="text" name="city" id="city" maxlength="255" value="<?php echo $this->reservation->city; ?>" />
                </div>
            </div>
            <div class="row-fluid">
                <div class="formelm span6">
                    <label for="zip"><?php echo JText::_('ZIP'); ?>: </label>
                    <input type="text" name="zip" id="zip" maxlength="255" value="<?php echo $this->reservation->zip; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="country"><?php echo JText::_('COUNTRY'); ?>: </label>
                    <input type="text" name="country" id="country" maxlength="255" value="<?php echo $this->reservation->country; ?>" />
                </div>
            </div>
            <div class="row-fluid">                
                <div class="formelm span6">
                    <label for="email"><?php echo JText::_('EMAIL'); ?>: </label>
                    <input type="text" name="email" id="email" maxlength="255" value="<?php echo $this->reservation->email; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="telephone"><?php echo JText::_('TELEPHONE'); ?>: </label>
                    <input type="text" name="telephone" id="telephone" maxlength="255" value="<?php echo $this->reservation->telephone; ?>" />
                </div>
            </div>
            <div class="row-fluid">                
                <div class="formelm span6">
                    <label for="fax"><?php echo JText::_('FAX'); ?>: </label>
                    <input type="text" name="fax" id="fax" maxlength="255" value="<?php echo $this->reservation->fax; ?>" />
                </div>
                <div class="formelm span6">
                    <label for="note"><?php echo JText::_('NOTE'); ?></label>
                    <textarea name="note" id="note" cols="50" rows="5"><?php echo $this->reservation->note; ?></textarea>
                </div>
            </div>
        </fieldset>
        <div class="bookingToolbar">
            <a class="aIconToolSave tool save" title="<?php echo JText::_('JSave', true); ?>" href="javascript:submitbutton('save')"><?php echo JText::_('JSave', true); ?></a>
            <a class="aIconToolApply tool apply" title="<?php echo JText::_('JApply', true); ?>" href="javascript:submitbutton('apply')"><?php echo JText::_('JApply', true); ?></a>
            <a class="aIconToolCancel tool cancel" title="<?php echo JText::_('JCancel', true); ?>" href="<?php echo JRoute::_(ARoute::view(VIEW_RESERVATIONS)); ?>"><?php echo JText::_('JCancel', true); ?></a>
            <div class="clr"></div>
        </div>
        <input type="hidden" name="option" value="<?php echo OPTION; ?>" />
        <input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>" />
        <input type="hidden" name="boxchecked" value="1" />
        <input type="hidden" name="Itemid" value="<?php echo JRequest::getInt('Itemid'); ?>" />
        <input type="hidden" name="cid[]" value="<?php echo $this->reservation->id; ?>" />
        <input type="hidden" name="task" value="" />
        <?php echo JHTML::_('form.token'); ?>
    </form>
</div>