<?php

/**
 * @version        $Id$
 * @package        ARTIO Booking
 * @subpackage    views
 * @copyright        Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author            ARTIO s.r.o., http://www.artio.net
 * @license        GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link            http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

$this->setting = new stdClass();
$this->setting->day = $this->setting->month = $this->setting->year = $this->setting->week = '';

$config = AFactory::getConfig();
/* @var $config BookingConfig */

JHtml::_('behavior.modal');

?>
<div class="clr"></div>
<div id="bookingCalendar">
    <!--AJAX_bookingCalendar-->
    <div class="period">
        <h2><?php echo JText::_('PERIODIC_RESERVATION'); ?></h2>
        <fieldset class="timeframe">
            <legend><?php echo JText::_('TIMEFRAME'); ?></legend>
            <?php echo implode(' ', $this->getPeriodLists()); ?>
            <?php if ($config->multiTimeFrame) { ?>
                <input type="hidden" name="period_time_up_multi" id="period_time_up" value=""/>
                <input type="hidden" name="period_time_down_multi" id="period_time_down" value=""/>
            <?php } else { ?>
                <input type="hidden" name="period_time_up" id="period_time_up" value=""/>
                <input type="hidden" name="period_time_down" id="period_time_down" value=""/>
            <?php } ?>
            <input type="hidden" name="period_rtype_id" id="period_rtype_id" value=""/>
            <input type="hidden" name="period_price_id" id="period_price_id" value=""/>
        </fieldset>
        <fieldset class="recurrence-pattern">
            <legend><?php echo JText::_('RECURRENCE_PATTERN'); ?></legend>
            <div class="type">
			<span <?php if (!$config->showRecurrencePatternDaily) { ?>style="display: none"<?php } ?>>
				<input type="radio" name="period_type" id="period_type_daily" value="<?php echo PERIOD_TYPE_DAILY; ?>"
                       autocomplete="off"/>
				<label for="period_type_daily"><?php echo JText::_('DAILY'); ?></label>
			</span>
                <span <?php if (!$config->showRecurrencePatternWeekly) { ?>style="display: none"<?php } ?>>
				<input type="radio" name="period_type" id="period_type_weekly" value="<?php echo PERIOD_TYPE_WEEKLY; ?>"
                       autocomplete="off"/>
				<label for="period_type_weekly"><?php echo JText::_('WEEKLY'); ?></label>
			</span>
                <span <?php if (!$config->showRecurrencePatternMonthly) { ?>style="display: none"<?php } ?>>
				<input type="radio" name="period_type" id="period_type_monthly"
                       value="<?php echo PERIOD_TYPE_MONTHLY; ?>" autocomplete="off"/>
				<label for="period_type_monthly"><?php echo JText::_('MONTHLY'); ?></label>
			</span>
                <span <?php if (!$config->showRecurrencePatternYearly) { ?>style="display: none"<?php } ?>>
				<input type="radio" name="period_type" id="period_type_yearly" value="<?php echo PERIOD_TYPE_YEARLY; ?>"
                       autocomplete="off"/>
				<label for="period_type_yearly"><?php echo JText::_('YEARLY'); ?></label>
			</span>
            </div>
            <div class="intensity" id="daily_weekly" style="display: none">
                <div id="recurrence">
                    <label for="period_recurrence"><?php echo JText::_('RECUR_EVERY'); ?></label>
                    <input type="text" name="period_recurrence" id="period_recurrence" value="" size="1"
                           autocomplete="off" class="input-mini"/>
                    <label for="period_recurrence"><?php echo JText::_('WEEKS_ON'); ?></label>
                </div>
                <div class="clr"></div>
                <?php if ($config->firstDaySunday) { ?>
                    <input type="checkbox" name="p" id="period_sunday_checkbox" disabled="disabled"/>
                    <input type="hidden" name="period_sunday" id="period_sunday_hidden" value="0" autocomplete="off"/>
                    <label for="period_sunday_checkbox"><?php echo JText::_('SUNDAY'); ?></label>
                <?php } ?>
                <input type="checkbox" name="p" id="period_monday_checkbox" disabled="disabled"/>
                <input type="hidden" name="period_monday" id="period_monday_hidden" value="0" autocomplete="off"/>
                <label for="period_monday_checkbox"><?php echo JText::_('MONDAY'); ?></label>

                <input type="checkbox" name="p" id="period_tuesday_checkbox" disabled="disabled"/>
                <input type="hidden" name="period_tuesday" id="period_tuesday_hidden" value="0" autocomplete="off"/>
                <label for="period_tuesday_checkbox"><?php echo JText::_('TUESDAY'); ?></label>

                <input type="checkbox" name="p" id="period_wednesday_checkbox" disabled="disabled"/>
                <input type="hidden" name="period_wednesday" id="period_wednesday_hidden" value="0" autocomplete="off"/>
                <label for="period_wednesday_checkbox"><?php echo JText::_('WEDNESDAY'); ?></label>

                <input type="checkbox" name="p" id="period_thursday_checkbox" disabled="disabled"/>
                <input type="hidden" name="period_thursday" id="period_thursday_hidden" value="0" autocomplete="off"/>
                <label for="period_thursday_checkbox"><?php echo JText::_('THURSDAY'); ?></label>

                <input type="checkbox" name="p" id="period_friday_checkbox" disabled="disabled"/>
                <input type="hidden" name="period_friday" id="period_friday_hidden" value="0" autocomplete="off"/>
                <label for="period_friday_checkbox"><?php echo JText::_('FRIDAY'); ?></label>

                <input type="checkbox" name="p" id="period_saturday_checkbox" disabled="disabled"/>
                <input type="hidden" name="period_saturday" id="period_saturday_hidden" value="0" autocomplete="off"/>
                <label for="period_saturday_checkbox"><?php echo JText::_('SATURDAY'); ?></label>

                <?php if (!$config->firstDaySunday) { ?>
                    <input type="checkbox" name="p" id="period_sunday_checkbox" disabled="disabled"/>
                    <input type="hidden" name="period_sunday" id="period_sunday_hidden" value="0" autocomplete="off"/>
                    <label for="period_sunday_checkbox"><?php echo JText::_('SUNDAY'); ?></label>
                <?php } ?>
            </div>
            <div class="intensity" id="monthly_yearly" style="display: none">
                <?php echo $this->getMonthSelector() ?>
                <?php echo $this->getWeekSelector() ?>
                <?php echo $this->getDaySelector() ?>
            </div>
        </fieldset>
        <fieldset class="recurrence-range">
            <legend><?php echo JText::_('RANGE_OF_RECURRENCE'); ?></legend>
            <div class="begin">
                <label for="period_date_up"><?php echo JText::_('START'); ?></label>
                <?php echo AHtml::getCalendar('', 'period_date_up', 'period_date_up', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL, '', false, false, ADATE_FORMAT_MYSQL_DATE_CAL, false, true) ?>
            </div>
            <div class="end">
                <div class="no-end"
                     <?php if (!$config->showRangeOfRecurrenceNoEndDate) { ?>style="display: none"<?php } ?>>
                    <input type="radio" name="period_end" id="period_end_no" value="<?php echo PERIOD_END_TYPE_NO; ?>"
                           autocomplete="off"/>
                    <label for="period_end_no"><?php echo JText::_('NO_END_DATE'); ?></label>
                    <div class="clr"></div>
                </div>
                <div class="end-after"
                     <?php if (!$config->showRangeOfRecurrenceEndAfter) { ?>style="display: none"<?php } ?>>
                    <input type="radio" name="period_end" id="period_occurrences"
                           value="<?php echo PERIOD_END_TYPE_AFTER; ?>" autocomplete="off"/>
                    <label for="period_occurrences"
                           id="period_occurrences_lbl"><?php echo JText::_('END_AFTER'); ?></label>
                    <input type="text" name="period_occurrences" id="period_occurrences_occurrences" size="1" value=""
                           disabled="disabled" autocomplete="off" class="input-mini "/>
                    <label for="period_occurrences_occurrences"><?php echo JText::_('OCCURRENCES'); ?></label>
                    <div class="clr"></div>
                </div>
                <div class="end-by" <?php if (!$config->showRangeOfRecurrenceEndBy) { ?>style="display: none"<?php } ?>>
                    <input type="radio" name="period_end" id="period_date_down"
                           value="<?php echo PERIOD_END_TYPE_DATE; ?>" autocomplete="off"/>
                    <label for="period_date_down" id="period_date_down_lbl"><?php echo JText::_('END_BY'); ?></label>
                    <?php echo AHtml::getCalendar('', 'period_date_down', 'period_date_down_date', ADATE_FORMAT_NORMAL_CAL, ADATE_FORMAT_NORMAL_CAL, '', false, false, ADATE_FORMAT_MYSQL_DATE_CAL, false, true) ?>
                    <div class="clr"></div>
                </div>
            </div>
            <?php if ($config->useCalculateButton) { ?>
                <div class="clr"></div>
                <div class="calculate">
                    <button class="btn btn-primary" id="calculateBookIt">
                        <?php echo JText::_('CALCULATE'); ?></button>
                    <?php echo JHtml::image('mootree_loader.gif', '', 'class="calculate-loader" id="calculateLoader"', true) ?>
                    <h3 id="calculateTotal"></h3>
                    <strong id="calculateError"></strong>
                    <div id="calculateRecurrences">
                        <strong><?php echo JText::_('RECURRENCES') ?></strong>
                        <div></div>
                    </div>
                </div>
            <?php } ?>
        </fieldset>
        <?php if (!empty($this->customer->id) || JFactory::getUser()->authorise('booking.reservation.create', 'com_booking')) { ?>
            <div class="tools">
                <?php if ($config->showCapacity) { ?>
                    <label for="capacity">
                        <span><?php echo JText::_('Quantity'); ?></span>
                        <select name="capacity" id="capacity" onchange="Calendars.showTotal();Calendars.showOccupancy()"
                                class="input-mini">
                            <?php echo JHtml::_('select.options', array_combine(range($this->subject->minimum_capacity, $this->subject->total_capacity), range($this->subject->minimum_capacity, $this->subject->total_capacity)), '', '', $this->subject->minimum_capacity); ?>
                        </select>
                        <span><?php echo $this->template->name; ?></span>
                    </label>
                    <div class="clr"></div>
                <?php } ?>
                <?php echo $this->loadTemplate('occupancy') ?>
                <div class="bookit bookInterval">
                    <strong id="checkInfo"></strong>
                    <a class="checkButton bookitButton" id="bookIt">
                        <?php echo JText::_('BOOK_IT'); ?></a>
                </div>
            </div>
        <?php } ?>
    </div>
    <!--/AJAX_bookingCalendar-->
</div>
<script type="text/javascript">
    window.fireEvent('booking-period-domready');
</script>