<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

$this->_addSQL('ALTER TABLE `#__booking_payment` ADD `info` TEXT NOT NULL AFTER `title`');
$this->_addSQL('ALTER TABLE `#__booking_reservation` ADD `payment_method_info` TEXT NOT NULL AFTER `payment_method_name`');
$this->_addSQL('ALTER TABLE `#__booking_supplement` ADD `member_discount` TEXT NOT NULL AFTER `price`');

$db = JFactory::getDbo();

$query = $db->getQuery(true);
$query->select('element, params');
$query->from('#__extensions');
$query->where('folder = ' . $db->quote('bookingpayment'));

$db->setQuery($query);
$plugins = $db->loadObjectList();

foreach ($plugins as $plugin) {
	$params = new JRegistry($plugin->params);
	$this->_addSQL('UPDATE #__booking_payment SET info = ' . $db->quote($params->get('info')) . ' WHERE alias = ' . $db->quote($plugin->element));
}