<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

if (! class_exists('JParameter'))
    jimport('joomla.html.parameter');

$files[] = realpath(($component = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_artiofusioncharts' . DS) . 'helpers' . DS . 'helper.php');
$files[] = realpath($component . 'config.php');
$files[] = realpath($component . 'helpers' . DS . 'route.php');
$files[] = realpath($component . 'models' . DS . 'artiofusionchart.php');
$files[] = realpath($component . 'models' . DS . 'database.php');
$files[] = realpath($component . 'tables' . DS . 'artiofusionchart.php');
$files[] = realpath($component . 'tables' . DS . 'database.php');

$canUse = true;

foreach ($files as $file) {
    if (file_exists($file))
        include_once ($file);
    else {
        $canUse = false;
        break;
    }
}

if ($canUse) {
    JHTML::_('behavior.caption');
    JHTML::script('FusionCharts.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);
    
    if (($chart = ARTIOFusionChartsHelper::getChart(($id = (int) $params->getValue('id'))))) {
        if (file_exists(($layoutPath = JModuleHelper::getLayoutPath('mod_artiofusioncharts', ($layout = $params->get('layout', 'default'))))))
            include ($layoutPath);
        else
            echo JText::_('Layout ' . $layout . ' for ARTIOFusionCharts not found');
    } else
        echo JText::sprintf('Chart with ID %s isnt\'t exists', $id);
} else
    echo JText::_('Component ARTIOFusionCharts isn\'t installed or is installed incorectly');

?>