<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

class plgButtonARTIOFusionCharts extends JPlugin
{

    /**
     * Create object.
     * 
     * @param JDispatcher $subject plugins events dispatcher 
     * @param array $config plugin settings
     * @return void
     */
    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }

    /**
     * Display button to open page to choosing chart inserted into article.
     * 
     * @param string $name
     * @return JObject
     */
    function onDisplay($name)
    {
        JHTML::_('behavior.modal');
        
        $button = new JObject();
        
        $button->set('modal', true);
        $button->set('link', 'index.php?option=com_artiofusioncharts&amp;plugin=1&amp;tmpl=component&amp;e_name=' . $name);
        $button->set('text', JText::_('ARTIOFusionChart'));
        $button->set('name', 'readmore');
        $button->set('options', "{handler: 'iframe', size: {x: 800, y: 400}}");
        
        return $button;
    }
}

?>