<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::script('multi-series.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);

?>
<fieldset class="adminform">
    <legend><?php echo JText::_('Line Sets'); ?></legend>
    <div id="lineset" style="overflow: auto">
    <div id="chartToolbar">
    	<a href="javascript:MultiSeries.addLineSet()" class="addCat"><?php echo JText::_('Add Line Set')?></a>
    	<a href="javascript:MultiSeries.removeLineSets()" class="removeCat"><?php echo JText::_('Remove Line Sets')?></a>
    	<div class="cleaner"></div>
    </div>
    <table class="admintable" id="linesets">
    		<tr id="lineset-0" style="display: none"><td></td></tr>
    		<?php 
    			foreach ($this->chart->linesets as $i=>$lineset) {
    				JFilterOutput::objectHTMLSafe($lineset, ENT_QUOTES);
    				$lineSetId = $i+1; 
    		?>
    			<tr id="lineset-<?php echo $lineSetId; ?>">
    				<td class="chart">
    					<input type="checkbox" id="lineset-checkbox-<?php echo $lineSetId; ?>" name="lineset-checkbox-<?php echo $lineSetId; ?>" value="<?php echo $lineSetId; ?>" class="checkbox"/>
    					<input type="text" id="lineset-name-<?php echo $lineSetId; ?>" name="lineset[<?php echo $lineSetId; ?>]" value="<?php echo $lineset->value; ?>" size="15"/>    					
    					<img src="<?php echo ARTIOFUSIONCHARTS_SET_IMAGE; ?>" class="setImage"  onclick="MultiSeries.setParams('lineset-<?php echo $lineSetId; ?>-params','maskLineset')" alt="<?php echo JText::_('Config'); ?>"/>
    					<img src="<?php echo ARTIOFUSIONCHARTS_ADD_IMAGE; ?>" class="setImage" onclick="MultiSeries.addLineSetSet(<?php echo $lineSetId; ?>)" title="<?php echo JText::_('Add Set'); ?>"/>
    					
    					<input type="hidden" id="lineset-<?php echo $lineSetId; ?>-params" name="lineset-params[<?php echo $lineSetId; ?>]" value="<?php echo $lineset->params; ?>"/>
    					
    				</td>
    				<td id="lineset-<?php echo $lineSetId; ?>-values">
	    				<?php 
	    					foreach ($lineset->sets as $j=>$set) {
	    				    	JFilterOutput::objectHTMLSafe($set, ENT_QUOTES);
	    						$setId = $j + 1; 
	    				?>
	   							<input type="text" id="lineset-<?php echo $lineSetId; ?>-value-<?php echo $setId; ?>" name="lineset-<?php echo $lineSetId; ?>-values[]" value="<?php echo $set->value; ?>" size="15"/>
	   							<img src="<?php echo ARTIOFUSIONCHARTS_REM_IMAGE; ?>" class="setImage" onclick="MultiSeries.removeLineSetSet(<?php echo $lineSetId; ?>, <?php echo $setId; ?>, this)" id="lineset-<?php echo $lineSetId; ?>-remove-<?php echo $setId; ?>" title="<?php echo JText::_('Remove Set'); ?>" />
	    				<?php } ?>
    				</td>	
    			</tr>
    		<?php } ?>
    	</tbody>	
    </table>    
    </div>
</fieldset>

<?php
    ARTIOFusionChartsHelper::exportParamsInJs($this->chart->paramsLinesetSource,'maskLineset');
?>
