<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::script('single-series.js?v=119', ARTIOFUSIONCHARTS_ASSETS_JS);

/* @var $this JView */

$params = ARTIOFusionChartsHelper::getParamsInTableForm($this->chart->paramsSetSource, 'sets');
  
?>
<fieldset class="adminform">
    <legend><?php echo JText::_('Chart data'); ?></legend>
    <div class="chartToolbar">
        <a href="javascript:ARTIOFusionCharts.add('sets','set')" class="addCol"><?php echo $this->chart->chartLanguages['addLabel']; ?></a>
        <a href="javascript:ARTIOFusionCharts.remove('sets','set')" class="removeCol"><?php echo $this->chart->chartLanguages['removeLabel']; ?></a>
        <div class="cleaner"></div>
    </div>
    <div>
    	<table class="adminlist" cellspacing="1">
    		<thead>
    			<tr>
    				<th class="title" align="left" width="2%">
    					<input type="checkbox" onclick="ARTIOFusionCharts.checkAll('sets',this)" name="checkbox"/>
    				</th>
                    <?php
                    	$width = ARTIOFUSIONCHARTS_SHIT_BROWSER ? 'width="' . floor(98 / count($params->tableForms)) . '%"' : '';
                    	foreach ($params->tableForms as $i=>$param) { 
                    ?>
    				    <th class="title" <?php echo $width; ?>>
    					   <span class="editlinktip hasTip" title="<?php echo $this->escape($param->title . '::' . $param->desc); ?>">
    					        <?php echo $param->title; ?>
    					   </span>
    				    </th>
                    <?php } ?>
    			</tr>	
    		</thead>			
    		<tbody id="sets">				
                <?php
                	echo ARTIOFusionChartsHelper::getMaskRow($params->html, 'set');
                    foreach ($this->chart->sets as $set) {
                        echo ARTIOFusionChartsHelper::getFillTableRowFromParams($params->html, $set);
                    }
                ?>
    		</tbody>
    	</table>
    </div>
</fieldset>