<?php

/**
 * Componet for creating Fusion Charts XML source in graphic mode.
 * Can create, modified and deleting assorted Fusion Charts. Charts
 * can display on frontend page by module or content plugin.  
 *
 * @version		$Id$
 * @package     ArtioFusioncharts
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this ARTIOFusionChartsViewCreate */

JHTML::_('behavior.tooltip');

JToolBarHelper::title(   JText::_( 'Create New Chart' ), 'charts.png' );
JToolBarHelper::back('Charts Manager',ARTIOFusionChartsHelperRoute::getHomeRoute());
if (ARTIOFUSIONCHARTS_ADMIN)
	JToolBarHelper::preferences(ARTIOFUSIONCHARTS_OPTION,600);

$document = &JFactory::getDocument();
/* @var $document JDocument */
$css = '.tool-tip { max-width: 500px !important; padding: 0 !important; }' . PHP_EOL;
$css .= '.tool-title { display: none !important; }';
$document->addStyleDeclaration($css);

?>

<table class="adminform">
	<tr>
		<td width="55%" valign="top">
			<div id="cpanel">
				<?php foreach ($this->categories as $j => $category){ ?>
					<!-- 
					<fieldset class="adminform" style="float: left">
						<legend><?php echo $category->name; ?></legend>
						 -->
						<?php 
							foreach ($category->charts as $i=>$chart) {
								$name = $this->escape($chart->name) 
						?>
							<div style="float:left;">
								<div class="icon">
									<span class="editlinktip hasTip"
									title="<?php echo htmlentities(' ::<h3 class="preview">' . $name . '</h3><img src="' . $chart->preview . '" name="imagelib" />'); ?>">
									<a href="<?php echo JRoute::_($chart->link); ?>">
										<img src="<?php echo $chart->icon; ?>" alt="<?php echo $name; ?>"  />					
										<span><?php echo $name; ?></span>
									</a>
									</span>
								</div>
							</div>
						<?php }?>
						<!-- 
					</fieldset>
					 -->
				<?php } ?>
			</div>
		</td>
	</tr>
</table>
