<?php

/**
 * Artio DOCman2 2.0.0 - Joomla! Document Manager
 * @version     $Id: view.html.php $
 * @package     DOCman2
 * @copyright	Copyright (C) 2009 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 **/

defined ( '_JEXEC' ) or die ( 'Restricted access' );

jimport ( 'joomla.application.component.view' );

require_once (JPATH_COMPONENT_HELPERS . DS . 'categories.php');
require_once (JPATH_COMPONENT_HELPERS . DS . 'documents.php');
require_once (JPATH_COMPONENT_HELPERS . DS . 'upload.php');

define ( 'DTMP_DOCDETAILS', 'page_docdetails.tpl.php' );
define ( 'DTMP_DOCEDIT', 'page_docedit.tpl.php' );
define ( 'DTMP_DOCMOVE', 'page_docmove.tpl.php' );
define ( 'DTMP_DOCUPLOAD', 'page_docupload.tpl.php' );
define ( 'DTMP_SCRIPT_DOCEDIT', 'script_docedit.tpl.php' );

class DocmanViewDocument extends JView {
	function display() {
		$docman = &DocmanFactory::getDocman ();
		$tpl = $docman->getCfg ( 'icon_theme' );
		$html = new StdClass ( );
		$gid = DocmanHelper::getGid ();
		$html->menu = DocmanHelper::fetchMenu ( $gid, $tpl );
		$html->docdetails = DocumentsHelper::fetchDocument ( $gid, $tpl );
		$path = DocmanHelper::getPath ( DTMP_DOCDETAILS, $tpl, true );
		$tpl = &new DOCMAN_Theme ( );
		$tpl->path = $path;
		// Assign values to the Savant instance.
		$tpl->assignRef ( 'html', $html );
		// load a filter to trim whitespace
		$tpl->loadFilter ( 'trimwhitespace' );
		// Display a template using the assigned values.
		$tpl->display ( DTMP_DOCDETAILS );
	}
	function _displayForm() {
		$docman = &DocmanFactory::getDocman ();
		$tpl = $docman->getCfg ( 'icon_theme' );
		$gid = DocmanHelper::getGid ();
		$html = new StdClass ( );
		$html->menu = DocmanHelper::fetchMenu ( $gid, $tpl );
		$html->docedit = DocumentsHelper::fetchEditDocumentForm ( $gid );
		$path = DocmanHelper::getPath ( DTMP_DOCEDIT, $tpl, true );
		// Assign values to the Savant instance.
		$tpl = &new DOCMAN_Theme ( );
		$tpl->path = $path;
		$tpl->assignRef ( 'html', $html );
		// load a filter to trim whitespace
		$tpl->loadFilter ( 'trimwhitespace' );
		// Display a template using the assigned values.
		DocmanViewDocument::importScript ();
		
		$tpl->display ( DTMP_DOCEDIT );
	}
	function _displayMove() {
		$docman = &DocmanFactory::getDocman ();
		$tpl = $docman->getCfg ( 'icon_theme' );
		$html = new StdClass ( );
		$gid = DocmanHelper::getGid ();
		$html->menu = DocmanHelper::fetchMenu ( $gid, $tpl );
		$html->docmove = DocumentsHelper::fetchMoveDocumentForm ( $gid );
		$path = DocmanHelper::getPath ( DTMP_DOCMOVE, $tpl, true );
		$tpl = &new DOCMAN_Theme ( );
		$tpl->path = $path;
		// Assign values to the Savant instance.
		$tpl->assignRef ( 'html', $html );
		// load a filter to trim whitespace
		$tpl->loadFilter ( 'trimwhitespace' );
		// Display a template using the assigned values.
		$tpl->display ( DTMP_DOCMOVE );
	}
	function _displayUpload() {
		$docman = &DocmanFactory::getDocman ();
		$tpl = $docman->getCfg ( 'icon_theme' );
		$step = JRequest::getInt ( 'step', 1 );
		$method = JRequest::getString ( 'method', null );
		$script = JRequest::getInt ( 'script' );
		$update = 0;
		$gid = DocmanHelper::getGid ();
		
		if ($script) {
			HTML_docman::scriptDocumentUpload ( $step, $method, $update );
			return;
		}
		
		//fetch the license form
		$html = new StdClass ( );
		$html->menu = DocmanHelper::fetchMenu ( $gid, $tpl );
		$html->docupload = UploadHelper::fetchDocumentUploadForm ( $gid, $step, $method, $update );
		$path = DocmanHelper::getPath ( DTMP_DOCUPLOAD, $tpl, true );
		$tpl = &new DOCMAN_Theme ( );
		$tpl->path = $path;
		// Assign values to the Savant instance.
		$tpl->assignRef ( 'html', $html );
		$tpl->assignRef ( 'step', $step );
		$tpl->assignRef ( 'method', $method );
		$tpl->assignRef ( 'update', $update );
		// load a filter to trim whitespace
		$tpl->loadFilter ( 'trimwhitespace' );
		// Display a template using the assigned values.
		if ($step == 3) {
			DocmanViewDocument::importScript ();
		}
		$tpl->display ( DTMP_DOCUPLOAD );
	}
	function importScript() {
		$f = JPATH_COMPONENT . DS . 'views' . DS . 'themes' . DS . $this->_layout . DS . 'templates' . DS . 'scripts' . DS . 'form_docedit.tpl.php';
		echo '<script type="text/javascript">';
		require_once ($f);
		echo '</script>';
	}
}
?>