<?php
/**
 * Content SEF extension for Joomla!
 *
 * @author      $Author: Howson $
 * @copyright   Stackideas., http://www.stackideas.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_easyblog extends SefExt
{
    function beforeCreate(&$uri)
    {
        if(file_exists(JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'easyblog.php'))
        {
            require_once (JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'helpers'.DS.'router.php');
            
            if(is_null($uri->getVar('Itemid')));
            {
                $Itemid = EasyBlogRouter::getItemId($uri->getVar('view'));
                $uri->setVar('Itemid' , $Itemid);
            }
        }
        
        // Remove the limitstart and limit variables if they point to the first page
        if( !is_null($uri->getVar('limitstart')) && ($uri->getVar('limitstart') == '0') ) {
            $uri->delVar('limitstart');
            $uri->delVar('limit');
        }
        
        if ($uri->getVar('filter') == 'all') {
            $uri->delVar('filter');
        }

        return;
    }
    
    function create(&$uri)
    {
        $sefConfig =& SEFConfig::getConfig();

        $this->params = SEFTools::GetExtParams('com_easyblog');

        $vars = $uri->getQuery(true);
        extract($vars);

		$id = empty($id)? '' : $id;
		
        // Do not SEF edit urls
        if( isset($task) && ($task == 'edit') ) {
            return $uri;
        }

        // Set title.
        $title = array();
		
		$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
        //$title[] = JText::_('Submit');
		
        if(file_exists(JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'easyblog.php'))
        {
            require_once (JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'helpers'.DS.'router.php');
            
            //process id to something more meaningful
            if (empty($id) && !empty($blogid)) {
                $id = $blogid;
            }
            if(!empty($id) && !empty($view))
            {
                switch($view)
                {
                    case 'entry':
                        $idname = EasyBlogRouter::getBlogSefPermalink($id);
                        if ($this->params->get('blogid', '0') == '1') {
                            $idname = $id . '-' . $idname;
                        }
                        break;
                    case 'blogger':
                        $idname = EasyBlogRouter::getBloggerPermalink($id);
                        break;
                    case 'categories':
                        $idname = EasyBlogRouter::getCategoryPermalink($id);
                        if ($this->params->get('categoryid', '0') == '1') {
                            $idname = $id . '-' . $idname;
                        }
                        break;
                    case 'tags':
                        $idname = EasyBlogRouter::getTagPermalink($id);
                        if ($this->params->get('tagid', '0') == '1') {
                            $idname = $id . '-' . $idname;
                        }
                        break;
                    case 'teamblog':
                        $idname = EasyBlogRouter::getTeamBlogPermalink($id);
                        break;
                    case 'dashboard':
                        if ($uri->getVar('layout') == 'write') {
                            $idname = EasyBlogRouter::getBlogSefPermalink($id);
                            if ($this->params->get('blogid', '0') == '1') {
                                $idname = $id . '-' . $idname;
                            }
                        }
                        break;
                    default:
                        $idname ='';
                }
            }
        }
        
		//port from sh404sef
		if(isset($view))
		{
			$title[] = $view;
		}
		
		if(isset($layout) && ($layout != 'write' || empty($blogid)) && ($layout != 'listings') && ($layout != 'tag'))
		{
			$title[] = $layout;
		}
		
		if(!empty($id))
		{
			if(!empty($idname))
			{
				$title[] = $idname;
			}
		}
		
		if (!empty($layout) && ($layout == 'write') && !empty($blogid)) {
		    $title[] = JText::_('Edit');
		}
		
		if(!empty($filter))
		{
		    $title[] = JText::_($filter);
		}
		
		if(!empty($format) && ($format != 'feed'))
		{
			$title[] = $format;
		}
		
		if(!empty($type))
		{
			$title[] = $type;
		}
		
		if(!empty($task))
		{
		    $title[] = $task;
		}
		///////////////////
		
        if (isset($limitstart) && (!$sefConfig->appendNonSef || ($this->params->get('pagination', '0') == '0'))) {
            $page = $limitstart+1;
            $pagetext = strval($page);
            if (($cnfPageText = $sefConfig->getPageText())) {
                $pagetext = str_replace('%s', $page, $cnfPageText);
            }
            $title[] = $pagetext;
        }

        if (isset($showall) && ($showall == 1)) {
            $title[] = JText::_('All Pages');
        }

        if (isset($print) && ($print == 1)) {
            // Print article
            $title[] = JText::_('Print') . (!empty($page) ? '-'.($page+1) : '');
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $nonSefVars = array();
            if (isset($limit))      $nonSefVars['limit'] = $limit;
            if (isset($limitstart)) $nonSefVars['limitstart'] = $limitstart;

            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, $nonSefVars);
        }

        return $newUri;
    }
}
?>
