<?php
/**
 * FireBoard SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_fireboard extends SefExt
{
    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->params = SEFTools::getExtParams('com_fireboard');
        
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        // Set non-sef vars according to settings
        $doOptimize = in_array($uri->getVar('do'), array('reply', 'quote', 'delete', 'edit', 'move', 'sticky', 'lock'))
        || ($uri->getVar('func') == 'report');
        if ($this->params->get('idExclude', true) && $doOptimize) {
            if (!is_null($uri->getVar('id')))
                $this->nonSefVars['id'] = $uri->getVar('id');
            if (!is_null($uri->getVar('replyto')))
                $this->nonSefVars['replyto'] = $uri->getVar('replyto');
            if (!is_null($uri->getVar('msg_id')))
                $this->nonSefVars['msg_id'] = $uri->getVar('msg_id');
        }
        if ($this->params->get('optimize', true) && $doOptimize) {
            if (!is_null($uri->getVar('fb_thread')))
                $this->nonSefVars['fb_thread'] = $uri->getVar('fb_thread');
            if (!is_null($uri->getVar('name')))
                $this->nonSefVars['name'] = $uri->getVar('name');
        }
        if ($this->params->get('doExclude', true)) {
            if (!is_null($uri->getVar('do')))
                $this->nonSefVars['do'] = $uri->getVar('do');
        }
    }

    function getFbConfig($obj, $name)
    {
        $val = null;
        
        if (is_object($obj)) {
            if (isset($obj->$name)) {
                $val = $obj->$name;
            }
        }
        else if (is_array($obj)) {
            if (isset($obj[$name])) {
                $val = $obj[$name];
            }
        }
        
        return $val;
    }
    
    function beforeCreate(&$uri) {
        global $fbConfig;
        
        if (is_null($this->getFbConfig($fbConfig, 'messages_per_page'))) {
            $file = JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_fireboard'.DS.'fireboard_config.php';
            if (!file_exists($file)) {
                return;
            }
            
            require($file);
        }
                
        $database =& JFactory::getDBO();
        $params = SEFTools::getExtParams('com_fireboard');
        
        $vars = $uri->getQuery(true);
        extract($vars);
        
        if( isset($func) && ($func == 'showcat') && isset($id) ) {
            $uri->delVar('id');
        }
        elseif( isset($id) && $params->get('smarturls', false) ) {
            // Find the root msg
            $oldid = $id;
            
            $query = "SELECT `id` FROM `#__fb_messages` WHERE (`parent` = '0') AND (`thread` = (SELECT `thread` FROM `#__fb_messages` WHERE `id` = '$id'))";
            $database->setQuery($query);
            $id = $database->loadResult();
            
            $uri->setVar('id', $id);
            
            if( $oldid != $id ) {
                // Get the message number
                $query = "SELECT COUNT(`id`) FROM `#__fb_messages` WHERE (`id` < '$oldid') AND (`thread` = (SELECT `thread` FROM `#__fb_messages` WHERE `id` = '$oldid')) ORDER BY `id`";
                $database->setQuery($query);
                $num = $database->loadResult();
                
                // Compute the limitstart
                $l = $this->getFbConfig($fbConfig, 'messages_per_page');
                if( $num >= $l ) {
                    $ls = intval($num / $l) * $l;
                    $uri->setVar('limitstart', $ls);
                }
            }
        }
        
        if( is_null($uri->getVar('limitstart')) && !is_null($uri->getVar('limit')) ) {
            $uri->delVar('limit');
        }
        
        if( !is_null($uri->getVar('limitstart')) ) {
            $uri->setVar('limit', $this->getFbConfig($fbConfig, 'messages_per_page'));
        }
    }

    function create(&$uri) {
        $vars = $uri->getQuery(true);
        extract($vars);

        // JF translate extension.
        $sefConfig =& SEFConfig::getConfig();
        $database =& JFactory::getDBO();

        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

        // load params
        $this->params = SEFTools::getExtParams('com_fireboard');

        $catRewrite = true;
        $msgRewrite = true;
        $usrRewrite = true;

        if ($msgRewrite || $catRewrite) {
            if ($catRewrite && !empty($catid)) {
                $query = "
        		SELECT `name`$jfTranslate
        		FROM `#__fb_categories`
        		WHERE `id` = $catid
        		";
                $database->setQuery($query);
                $catTitle = $database->loadResult();
            }
            if (isset($id)) $msgID = $id;
            elseif (isset($msg_id)) $msgID = $msg_id;
            elseif (isset($replyto)) $msgID = $replyto;
            else $msgID = null;
            if ($msgRewrite && !empty($msgID)) {
                $query = "
        		SELECT `subject`$jfTranslate
        		FROM `#__fb_messages`
        		WHERE `id` = $msgID
        		";
                $database->setQuery($query);
                $msgTitle = $database->loadResult();
                
                if( $this->params->get('msgid', false) ) {
                    $msgTitle = $msgID.$sefConfig->replacement.$msgTitle;
                }
            }
        }
        if ($usrRewrite && isset($userid)) {
            $query = "
        	SELECT `username`
        	FROM `#__users`
        	WHERE `id` = $userid
        	";
            $database->setQuery($query);
            $usrTitle = $database->loadResult();
        }

        // Set non-sef vars according to settings
        $this->_createNonSefVars($uri);
        
        // this needs to follow previous that use do
        if ($this->params->get('doExclude', true)) {
            unset($do);
        }

        // if task is not set, use do
        if (empty($task) && isset($func) && $func == 'post' && isset($do)) {
            $task = $do;
            unset($func); unset($do);
        }

        if (empty($task) && isset($func)) {
            $task = $func;
            unset($func);
        }

        // First subdir
        if (!empty($option)) {
            $title[] = JoomSEF::_getMenuTitle($option, @$task, @$Itemid);
        }

        // Category
        if (isset($catTitle) && !empty($catTitle)) {
            $title[] = $catTitle;
        }

        // Topic
        if (isset($msgTitle) && !empty($msgTitle) && isset($task) && ($task != 'showcat')) {
            //$title[] = (!isset($do) && !isset($func)) ? $msgTitle.$sefConfig->suffix : $msgTitle;
            $title[] = $msgTitle;
        }

        // Selection
        if (@$task == 'latest' && $sel) {
            $task .= '-'.$sel;
        }

        // View
        if (isset($view)) {
            $title[] = (!isset($do) && !isset($func)) ? $view.$sefConfig->suffix : $view;
        }

        // User
        if (isset($usrTitle) && !empty($usrTitle)) {
            if ($func == 'fbprofile') {
                $title[] = 'users';
                $func = null;
            }
            $title[] = !isset($do) ? $usrTitle.$sefConfig->suffix : $usrTitle;
        }

        if (isset($page) && $page > 1) {
            $title[] = $page;
        }

        // Func and do
        if (isset($do) || isset($func)) {
            if (isset($func)) $oper[] = $func;
            if (isset($do))   $oper[] = $do;
            $title[] = join('-', $oper).$sefConfig->suffix;
        }

        if( in_array(@$task, array('showcat', 'view')) ) {
            unset($task);
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $this->nonSefVars, $this->ignoreVars);
        }

        return $newUri;
    }
}
?>
