<?php
/**
 * Glossary SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_glossary extends SefExt
{
    var $params;
    
    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('page')))
            $this->nonSefVars['page'] = $uri->getVar('page');
    }
    
    // Returns term for given id
    function GetTerm($id)
    {
        $database =& JFactory::getDBO();

        $database->setQuery("SELECT `tterm`, `tletter` FROM `#__glossary` WHERE `id` = $id");
        $row = $database->loadObject();
        
        if ($this->params->get('letter', '0') != '0') {
            return array($row->tletter, $row->tterm);
        } else {
            return array($row->tterm);
        }
    }
    
    function GetGlossary($id)
    {
        $database =& JFactory::getDBO();
        
        $database->setQuery("SELECT `name` FROM `#__glossaries` WHERE `id` = '$id'");
        return $database->loadResult();
    }

    function create(&$uri)
    {
        $sefConfig =& SEFConfig::getConfig();

        $this->params = SEFTools::getExtParams('com_glossary');
        
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
        
        if (isset($glossid) && $this->params->get('use_glossary_name', 0)) {
            $title[] = $this->GetGlossary($glossid);
        }

        if (isset($task)) {
            switch($task) {
                case 'display':
                    if (isset($search)) {
                        // We don't want to save every search URL in the database
                        return;
                    }
                    if (isset($letter))  $title[] = $letter;
                    if (isset($page) && !$sefConfig->appendNonSef)  $title[] = $page;
                    break;

                case 'list':
                    // add letter
                    if (isset($letter)) $title[] = $letter;
                    // add page if available
                    if (isset($page)) $title[] = $page;
                    
                    unset($task);
                    
                    break;

                case 'comment':
                case 'delete':
                    $title = array_merge($title, $this->GetTerm($id));
                    $title[] = $func;
                    break;

                case 'submit':
                    if (isset($id)) {
                        $title = array_merge($title, $this->GetTerm($id));
                        $title[] = 'edit';
                    }
                    else {
                        $title[] = $letter;
                        $title[] = 'submit';
                    }
                    break;
            }
        }
        elseif (isset($id)) {
            $title = array_merge($title, $this->GetTerm($id));
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);
            
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $this->nonSefVars);
        }
        
        return $newUri;
    }

}
?>
