<?php
/**
 * QuickFAQ SEF extension for Joomla!
 *
 * @copyright  	(C) 2009 ARTIO.net, Denis Dulici
 * @license	   	GNU General Public License
 * @author		www.artio.net
 * @package		JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_jafilia extends SefExt
{
    var $params;

    function create(&$uri)
    {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();
        $nonSefVars = array();
        
        $this->params = SEFTools::getExtParams('com_jafilia');
        
        // Load the texts to use in URL
        $texts = SEFTools::getExtTexts('com_jafilia');
        $texts = $this->checkTexts($texts);
        
        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
              
        if (isset($limit))
            $nonSefVars['limit'] = $limit;
        if (isset($limitstart))
            $nonSefVars['limitstart'] = $limitstart;
        
        if (isset($task) && isset($texts['_' . $task])) {
        	$title[] = $texts['_' . $task];
        	unset($task);
        }
            
        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }
        
        return $newUri;
    }
    
    function checkTexts($texts)
    {
    	if (!isset($texts['_mainpage']))	$texts['_mainpage'] 	= 'Overview';
    	if (!isset($texts['_banner']))		$texts['_banner'] 		= 'Banners and Ads';
    	if (!isset($texts['_leads']))		$texts['_leads'] 		= 'Outstanding Fees';
    	if (!isset($texts['_payouts']))		$texts['_payouts'] 		= 'Realized Payouts';
    	if (!isset($texts['_referes']))		$texts['_referes'] 		= 'Referers';
    	if (!isset($texts['_userdetails']))	$texts['_userdetails'] 	= 'Partner Information';
    	
    	return $texts;
    }    

}
?>