<?php
/**
 * jDownloads SEF extension for Joomla!
 *
 * @copyright  2009 Denis Dulici
 * @license     GNU General Public License
 * www.denisdulici.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_jdownloads extends SefExt
{
    var $params;

    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('limit')))
            $this->nonSefVars['limit'] = $uri->getVar('limit');
        if (!is_null($uri->getVar('limitstart')))
            $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
        if (!is_null($uri->getVar('site')))
            $this->nonSefVars['site'] = $uri->getVar('site');
        if (!is_null($uri->getVar('start')))
            $this->nonSefVars['start'] = $uri->getVar('start');
        if (!is_null($uri->getVar('list')))
            $this->nonSefVars['list'] = $uri->getVar('list');
        if (!is_null($uri->getVar('user')))
            $this->nonSefVars['user'] = $uri->getVar('user');
        
        // Ordering
        $this->params = SEFTools::getExtParams('com_jdownloads');
        if ($this->params->get('nonsefordering', '1') == '1') {
            if (!is_null($uri->getVar('order')))
                $this->nonSefVars['order'] = $uri->getVar('order');
            if (!is_null($uri->getVar('dir')))
                $this->nonSefVars['dir'] = $uri->getVar('dir');
        }
    }
    
    function getCategoryTitle($catid) {
        $categories = array();
        
        while ($catid > 0) {
            $database =& JFactory::getDBO();
            $database->setQuery("SELECT `cat_title`, `cat_alias`, `parent_id`, `cat_id` FROM `#__jdownloads_cats` WHERE `cat_id` = $catid");
            $cat = $database->loadObject();
            
            $name = $this->BuildCategoryName($cat);
            array_unshift($categories, $name);
            
            $catid = $cat->parent_id;
        }
        
        return $categories;
    }
    
    function BuildCategoryName($category)
    {
        $name = array();
        $category->text = $this->params->get('categorynametext', 'Category');
        $this->AddNamePart($name, $category, $this->params->get('categoryname1', 'none'));
        $this->AddNamePart($name, $category, $this->params->get('categoryname2', 'cat_title'));
        $this->AddNamePart($name, $category, $this->params->get('categoryname3', 'none'));
        
        return implode('-', $name);
    }

    function BuildFileName($file)
    {
        $name = array();
        $file->text = $this->params->get('filenametext', 'File');
        $this->AddNamePart($name, $file, $this->params->get('filename1', 'none'));
        $this->AddNamePart($name, $file, $this->params->get('filename2', 'file_title'));
        $this->AddNamePart($name, $file, $this->params->get('filename3', 'none'));
        
        return implode('-', $name);
            }
    
    function AddNamePart(&$name, $object, $part)
    {
        if (isset($object->$part)) {
            $name[] = $object->$part;
        }
    }
    
    function getFileTitle($cid) {
        $database =& JFactory::getDBO();
        
        $database->setQuery("SELECT `file_title`, `file_alias`, `file_id`, `cat_id` FROM `#__jdownloads_files` WHERE `file_id` = $cid");
        $file = $database->loadObject();
        
        $catNames = $this->getCategoryTitle($file->cat_id);
        $cats = $this->params->get('category_inc', '2');
        
        $name = $this->BuildFileName($file);
        
        if ($cats == '2') {
            // All categories
            array_push($catNames, $name);
            return $catNames;
        }
        else if ($cats == '1') {
            // One category
            return array(end($catNames), $name);
        }
        else {
            // No category
            return array($name);
        }
    }

    function beforeCreate(&$uri) {
        // Remove the part after ':' from variables
        if (!is_null($uri->getVar('cid')))       SEFTools::fixVariable($uri, 'cid');
        if (!is_null($uri->getVar('catid')))     SEFTools::fixVariable($uri, 'catid');
        
        // Remove task if empty
        if ($uri->getVar('task') == '') {
            $uri->delVar('task');
        }
        if ($uri->getVar('view') == '' || $uri->getVar('view') == 'viewcategories') {
            $uri->delVar('view');
        }
        
        // Remove default mirror flag
        if ($uri->getVar('view') == 'finish' && $uri->getVar('m') == 0) {
            $uri->delVar('m');
        }
        
        // Remove task and catid if they point to empty category
        if (($uri->getVar('task') == 'viewcategory') || ($uri->getVar('view') == 'viewcategory')) {
            if (is_null($uri->getVar('catid')) || ($uri->getVar('catid') == 0)) {
                $uri->delVar('task');
                $uri->delVar('view');
                $uri->delVar('catid');
            }
        }
        
        // Remove limitstart if it's 0
        if ($uri->getVar('limitstart') == '0') {
            $uri->delVar('limitstart');
        }
        
        // Ordering
        $order = $uri->getVar('order', '');
        if ($order == 'default' || $order == '') {
            if ($uri->getVar('dir') == 'asc') {
                $uri->delVar('dir');
            }
            $uri->delVar('order');
        }
    }

    function create(&$uri) {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_jdownloads');

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if (!isset($task) && !empty($view)) {
            $task = $view;
            unset($view);
        }
        
        $always_english = ($this->params->get('always_english', '0') == '1');
        if (isset($task)) {
            switch($task) {
                case 'viewcategory':
                    if( isset($catid) ) {
                        $catNames = $this->getCategoryTitle($catid);
                        
                        if ($this->params->get('category_inc', '2') == '2') {
                            // All categories
                            $title = array_merge($title, $catNames);
                        } else {
                            // One category
                            $title[] = @$catNames[count($catNames) - 1];
                        }
                    }
                    unset($task);
                    break;
                case 'view.download':
                case 'viewdownload':
                    if( isset($cid) ) {
                        $title = array_merge( $title, $this->getFileTitle($cid));
                    }
                    unset($task);
                    break;
                case 'summary':
                case 'finish':
                    if( isset($cid) ) {
                        $title = array_merge( $title, $this->getFileTitle($cid));
                    }
                    if ($always_english) {
                        $tasks = array('summary' => 'Summary', 'finish' => 'Finish');
                    }
                    else {
                        $tasks = array('summary' => JText::_('JLIST_FRONTEND_HEADER_SUMMARY_TITLE'),
                                       'finish' => JText::_('JLIST_FRONTEND_HEADER_FINISH_TITLE'));
                    }
                    $title[] = $tasks[$task];
                    if (isset($m)) {
                        if ($m == 1) {
                            if ($always_english) {
                                $title[] = 'Mirror 1';
                            }
                            else {
                                $title[] = JText::_('JLIST_FRONTEND_MIRROR_URL_TITLE_1');
                            }
                        }
                        else {
                            if ($always_english) {
                                $title[] = 'Mirror 2';
                            }
                            else {
                                $title[] = JText::_('JLIST_FRONTEND_MIRROR_URL_TITLE_2');
                            }
                        }
                    }
                    unset($task);
                    break;
                case 'report':
                case 'edit':
                case 'save':
                    if( isset($cid) ) {
                        $title = array_merge( $title, $this->getFileTitle($cid));
                    }
                    if ($always_english) {
                        $tasks = array('report' => 'Report', 'edit' => 'Edit', 'save' => 'Save');
                    }
                    else {
                        $tasks = array('report' => JText::_('JLIST_CONFIG_REPORT_FILE_LINK_TEXT'),
                                       'edit' => JText::_('JLIST_BACKEND_TOOLBAR_EDIT'),
                                       'save' => JText::_('JLIST_FE_FILESEDIT_SAVE_BUTTON'));
                    }
                    $title[] = $tasks[$task];
                    unset($task);
                    break;
                case 'search':
                case 'upload':
                case 'view.upload':
                    if ($always_english) {
                        $tasks = array( 'search' => 'Search',
                        'upload' => 'Submit file',
                        'view.upload' => 'Submit file');
                                            }
                    else {
                        $tasks = array( 'search' => JText::_('JLIST_FRONTEND_SEARCH_LINKTEXT'),
                        'upload' => JText::_('JLIST_FRONTEND_UPLOAD_LINKTEXT'),
                        'view.upload' => JText::_('JLIST_FRONTEND_UPLOAD_LINKTEXT'));
                    }
                    $title[] = $tasks[$task];
                    unset($task);
                    break;
            }
        }
        
        // Ordering
        if ($this->params->get('nonsefordering', '1') == '0') {
            if (!empty($order)) {
                $title[] = $order;
            }
            if (!empty($dir)) {
                $title[] = $dir;
            }
        }
        
        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);
            
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, null, null, @$lang, $this->nonSefVars);
        }

        return $newUri;
    }
}
?>