<?php
/**
 * JoomDOC SEF extension for Joomla!
 *
 * @author      $Author: Teer $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_joomdoc extends SefExt
{

    var $params;
    
    /**
     * Get array of nested categories from given category id
     */
    function getCategories($catId, $lastOnly = false)
    {
        $db = & JFactory::getDBO();
        $sefConfig = & SEFConfig::getConfig();
        
        $categories = array();
        // check if we want our URLs translated
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';
        
        while ($catId > 0) {
            $db->setQuery("SELECT `title`$jfTranslate, `parent_id` FROM `#__categories` WHERE `id` = " . $catId);
            $row = $db->loadObject();
            
            $name = ($this->params->get('add_categoryId', '0') != '0' ? $catId . '-' : '') . $row->title;
            array_unshift($categories, $name);
            // get parent category Id (if not loading only last)
            $catId = $lastOnly ? 0 : $row->parent_id;
        }
        return $categories;
    }    
    
    function getDocument($id)
    {
        $db = &JFactory::getDBO();
        $id = (int) $id;
        if ($id > 0) {
            $query = 'SELECT id, dmname, catid FROM #__joomdoc WHERE id = ' . $id;
            $db->setQuery($query);
            $row = $db->loadAssoc();
            if (is_array($row) && count($row) == 3) {
                return $row;
            }
        }
        return null;
    }

    function create(&$uri)
    {
        $this->params = SEFTools::getExtParams('com_joomdoc');
        
        $vars = $uri->getQuery(true);
        extract($vars);
        
        // type of displaying categories (one / all / none)
        $catShowType = $this->params->get('categories', '2');
        
        $title = array();       
        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
        
        // we do not work with view, it is added by joomla
        if (isset($view)) {
            /*switch ($view) {
                case 'docman':
                case 'search':
                case 'document':
                case 'download':
                    $task = '';
                    break;
            }*/
            // remove it completely
            $uri->delVar('view');
            unset($view);
            // we will simply ignore it
            //$ignoreSefVars['view'] = $view;
        }
        if (isset($task)) {
            if (! isset($gid)) $gid = 0;

            switch (@$task) {
                case 'search_form':
                    $title[] = JText::_('Search'); break;
                    break;
                    
                case 'cat_view':
                case 'upload':
                    // all categories                    
                    if ($catShowType == '2') {
                        $catNames = $this->getCategories($gid);                        
                        foreach ($catNames as $cat) $title[] = $cat;
                    // one category (or none)
                    } else {
                        $catNames = $this->getCategories($gid, true);
                        $title[] = @$catNames[count($catNames) - 1];
                    }
                    
                    // if uplaod
                    if ($task == 'upload') {
                        $title[] = JText::_('Upload');
                    }
                    
                    break;
                case 'doc_download':
                case 'doc_details':
                case 'doc_view':
                case 'doc_move':
                case 'doc_edit':
                case 'doc_checkin':
                case 'doc_checkout':
                case 'doc_update':
                case 'doc_reset':
                case 'doc_delete':
                    if (($doc = $this->getDocument($gid))) {
                        $catID = $doc['catid'];                        
                        
                        // categories
                        if ($catShowType > 0) {                            
                            // all categories
                            if ($catShowType == '2') {
                                $catNames = $this->getCategories($catID); 
                                foreach ($catNames as $cat) $title[] = $cat;
                            // one category
                            } elseif ($catShowType == '1') {
                                $catNames = $this->getCategories($catID, true);
                                $title[] = @$catNames[count($catNames) - 1];
                            }
                        }

                        // document name
                        $title[] = $doc['dmname'];

                        // additional task
                        switch ($task) {
                            case 'doc_download':
                                $title[] = JText::_('Download'); break;
                            case 'doc_details':
                                $title[] = JText::_('Details'); break;
                            case 'doc_view':
                                $title[] = JText::_('View'); break;
                            case 'doc_move':
                                $title[] = JText::_('Move'); break;
                            case 'doc_edit':
                                $title[] = JText::_('Edit'); break;
                            case 'doc_checkout':
                                $title[] = JText::_('Checkout'); break;
                            case 'doc_checkin':
                                $title[] = JText::_('Checkin'); break;
                            case 'doc_update':
                                $title[] = JText::_('Update'); break;
                            case 'doc_reset':
                                $title[] = JText::_('Reset'); break;
                            case 'doc_delete':
                                $title[] = JText::_('Delete'); break;
                        }
                    }
                    break;
            }
            unset($task);
        }
        $nonSefVars = array();
		$ignoreSefVars = array();
        if (isset($limit))        $nonSefVars['limit'] = $limit;
        if (isset($limitstart))   $nonSefVars['limitstart'] = $limitstart;
        if (isset($dir))          $nonSefVars['dir'] = $dir;
        if (isset($order))        $nonSefVars['order'] = $order;
        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$vars['lang'], $nonSefVars, $ignoreSefVars);
        }
        
        return $newUri;
    }

}
?>
