<?php
/**
 * QContacts SEF extension for Joomla!
 *
* @copyright  2009 Denis Dulici
 * @license	    GNU General Public License
 * www.denisdulici.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_qcontacts extends SefExt
{
    var $params;

    function getCategoryTitle($catid) {
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT `id`, `title` FROM `#__categories` WHERE `id` = $catid");
        $cat = $database->loadObject();
        if($cat) {
            $name = ( ($this->params->get('categoryid_inc', '0') != '0') ? $catid.'-' : '' ).$cat->title;
            return $name;
        } else {
            return null;
        }
    }

    function getContactTitle($id) {
        $database =& JFactory::getDBO();

        $database->setQuery("SELECT `id`, `name`, `catid` FROM `#__qcontacts_details` WHERE `id` = $id");
        $contact = $database->loadObject();
        if($contact) {
            $name = ( ($this->params->get('contactid_inc', '0') != '0') ? $id.'-' : '' ).$contact->name;
            if( $this->params->get('category_inc', '1') != '1' ) {
                return array( $name );
            } else {
                return array( $this->getCategoryTitle($contact->catid), $name );
            }
        }
        else {
            return array();
        }
    }

    function beforeCreate(&$uri) {
        // Remove the part after ':' from variables
        if( !is_null($uri->getVar('id')) )       SEFTools::fixVariable($uri, 'id');
        if( !is_null($uri->getVar('catid')) )    SEFTools::fixVariable($uri, 'catid');
        
        // Remove view and catid if they point to empty category
        if( !is_null($uri->getVar('view')) && ($uri->getVar('view') == 'category') ) {
            if( is_null($uri->getVar('catid')) || ($uri->getVar('catid') == 0) ) {
                $uri->delVar('view');
                $uri->delVar('catid');
            }
        }
        return;
    }

    function create(&$uri) {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_qcontacts');

		$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
		
        if( isset($view) ) {
            switch($view) {
                case 'contact':
                    $title = array_merge( $title, $this->getContactTitle($id) );
                    unset($view);
                    break;
                case 'category':
                    if( isset($catid) ) {
                        $title[] = $this->getCategoryTitle($catid);
                    }
                    unset($view);
                    break;
            }
        }

        $nonSefVars = array();
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
		
		$newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }

        return $newUri;
    }
}
?>