<?php
/**
 * Content SEF extension for Joomla!
 *
 * @author      $Author: Howson $
 * @copyright   Stackideas., http://www.stackideas.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_sectionex extends SefExt
{
    function beforeCreate(&$uri)
    {
        $db =& JFactory::getDBO();

        $params = SEFTools::GetExtParams('com_sectionex');

        // Compatibility mode
        $comp = $params->get('compatibility', '0');
        
        // Change task=view to view=article for old urls
        if( !is_null($uri->getVar('task')) && ($uri->getVar('task') == 'view') ) {
            if( $comp == '0' ) {
                $uri->delVar('task');
            }
            $uri->setVar('view', 'article');
        }
        
        // Add the task=view in compatibility mode
        if( $comp != '0' ) {
            if( is_null($uri->getVar('task')) && !is_null($uri->getVar('view')) && ($uri->getVar('view') == 'article')) {
                $uri->setVar('task', 'view');
            }
        }

        // Remove the limitstart and limit variables if they point to the first page
        if( !is_null($uri->getVar('limitstart')) && ($uri->getVar('limitstart') == '0') ) {
            $uri->delVar('limitstart');
            $uri->delVar('limit');
        }

        // Try to guess the correct Itemid if set to
        if( $params->get('guessId', '0') != '0' ) {
            if( !is_null($uri->getVar('Itemid')) && !is_null($uri->getVar('id')) ) {
                global $mainframe;
                $i = $mainframe->getItemid($uri->getVar('id'));
                $uri->setVar('Itemid', $i);
            }
        }

        // Remove the part after ':' from variables
        if (!is_null($uri->getVar('id')) )    SEFTools::fixVariable($uri, 'id');
        if (!is_null($uri->getVar('catid')))  SEFTools::fixVariable($uri, 'catid');

        // If catid not given, try to find it
        $catid = $uri->getVar('catid');
        if (!is_null($uri->getVar('view')) 
        && ($uri->getVar('view') == 'article') 
        && !is_null($uri->getVar('id')) 
        && empty($catid) ) {
            $id = $uri->getVar('id');
            $query = "SELECT `catid` FROM `#__content` WHERE `id` = '{$id}'";
            $db->setQuery($query);
            $catid = $db->loadResult();

            if( !empty($catid) ) {
                $uri->setVar('catid', $catid);
            }
        }

        // Add the view variable if it's not set
        if( is_null($uri->getVar('view')) ) {
            if( is_null($uri->getVar('id')) ) {
                $uri->setVar('view', 'frontpage');
            } else {
                $uri->setVar('view', 'article');
            }
        }

        return;
    }
    
    function create(&$uri)
    {
        $sefConfig =& SEFConfig::getConfig();

        $params = SEFTools::GetExtParams('com_content');

        $vars = $uri->getQuery(true);
        extract($vars);

        // Do not SEF URLs with exturl variable
        //if( !empty($exturl) )   return $string;

        // Do not SEF edit urls
        if( isset($task) && ($task == 'edit') ) {
            return $uri;
        }

        // Set title.
        $title = array();
		
		if (isset($format)) 
		{
	        if ($format == 'pdf') {
	            if (intval($id) == 0 ) {
	                // Wrong ID
	                return $uri;
	            }
	            
	            // Create PDF
	            $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
	
	            $title[] = JText::_('PDF');
	        } elseif ($format == 'feed') {
	            // Create feed
	            if (@$view != 'frontpage') {
	                if (intval($id) == 0) {
	                    // Wrong ID
	                    return $uri;
	                }
	                
	                $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
	            }
	            if ((count($title) === 0) && empty($type)) {
	                $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
	            }
	
	            if (!empty($type)) $title[] = $type;
	        }
	    }
		else
		{
			$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
	        //$title[] = JText::_('Submit');
	
	        if (isset($limitstart) && (!$sefConfig->appendNonSef || ($params->get('pagination', '0') == '0'))) {
	            $page = $limitstart+1;
	            $pagetext = strval($page);
	            if (($cnfPageText = $sefConfig->getPageText())) {
	                $pagetext = str_replace('%s', $page, $cnfPageText);
	            }
	            $title[] = $pagetext;
	        }
	
	        if (isset($showall) && ($showall == 1)) {
	            $title[] = JText::_('All Pages');
	        }
	
	        if (isset($print) && ($print == 1)) {
	            // Print article
	            $title[] = JText::_('Print') . (!empty($page) ? '-'.($page+1) : '');
	        }
	    }
		
        switch (@$view)
		{
            case 'article':
            	$uri->delVar('option');
            	$uri->setVar('option', 'com_content');
            	$title[] = $this->getCategoryAlias($catid);
            	$title[] = $this->getArticleAlias($id);
            	break;
            default:
            	//do nothing
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $nonSefVars = array();
            if( $sefConfig->appendNonSef && ($params->get('pagination', '0') != '0') ) {
                if (isset($limit))      $nonSefVars['limit'] = $limit;
                if (isset($limitstart)) $nonSefVars['limitstart'] = $limitstart;
            }

            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, $nonSefVars);
        }

        return $newUri;
    }

	
	function getCategoryAlias($categoryid)
	{
		$db =& JFactory::getDBO();
		
		$sql = 'SELECT ' . $db->nameQuote('alias') . ' FROM ' . $db->nameQuote('#__categories') . ' WHERE ' . $db->nameQuote('id') . ' = ' . $db->quote($categoryid) . ' LIMIT 1';
		$db->setQuery($sql);
		$alias = $db->loadResult();
		
		return $alias;
	}
	
	function getArticleAlias($articleid)
	{
		$db =& JFactory::getDBO();
		
		$sql = 'SELECT ' . $db->nameQuote('alias') . ' FROM ' . $db->nameQuote('#__content') . ' WHERE ' . $db->nameQuote('id') . ' = ' . $db->quote($articleid) . ' LIMIT 1';
		$db->setQuery($sql);
		$alias = $db->loadResult();
		
		return $alias;
	}	
}
?>
