<?php
/**
*
* @package garyscookbook 2009-08-24
* A Joomla Cookbook Component
* based on AKOgallery by Arthur Konze
* @Author Gerald Berger / Ove Eriksson
* @Testing Forummoderation Ove Erikson and others
Copyright (C) 2007/2008/2009  by Gerald Berger   All Rights Reserved
Homepage   :www.Garyscookbook.de      www.vb-dozent.net
Version    : 3.0.12  for Joomla! 1.5.x
License    :
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*/
/**
* Mailfunktionen
*
* emailContentForm()
* Shows the email form for a given content item.
*
* @param mixed $uid
* @return
*/
function emailContentForm($uid)
{
    global $mainframe, $my;
    // Database Query
    $imgtitle = '';
    $dbGKB->setQuery("SELECT imgtitle FROM #__garyscookbook WHERE id = '" . $uid . "'");
    $imgtitle = $dbGKB->loadResult();
    if (id === null) {
        mosNotAuth();
        return;
    } else {
        $template = '';
        $dbGKB->setQuery("SELECT template FROM #__templates_menu WHERE client_id = '0' AND menuid = '0'");
        $template = $dbGKB->loadResult();
        emailForm($uid, $imgtitle, $template);
    }
}

/**
* emailForm()
* Writes Email form for filling in the send destination
*
* @param mixed $uid
* @param mixed $title
* @param string $template
* @return
*/
function emailForm($uid, $title, $template = '')
{
    global $mosConfig_sitename;

    ?>
	<script language="javascript" type="text/javascript">
	function submitbutton() {
		var form = document.frontendForm;
		// do field validation
		if (form.email.value == "" || form.youremail.value == "") {
			alert( '<?php echo addslashes(JText::_('You must enter your valid e-mail and the valid e-mail to send to.'));

    ?>' );
			return false;
		}
		return true;
	}
	</script>

	<title><?php echo $title;

    ?></title>
	<link rel="stylesheet" href="templates/<?php echo $template;

    ?>/css/template_css.css" type="text/css" />
	<form action="index2.php?option=com_garyscookbook&Itemid=$Itemid&func=emailsend&id=$id;" name="frontendForm" method="post" onSubmit="return submitbutton();">
	<table cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td colspan="2">
		<?php echo JText::_('E-mail this recipe to a friend.');

    ?>
		</td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td width="130">
		<?php echo JText::_('Your friend&apos;s E-mail:');

    ?>
		</td>
		<td>
		<input type="text" name="email" class="inputbox" size="25">
		</td>
	</tr>
	<tr>
		<td height="27">
		<?php echo JText::_('Your Name:');

    ?>
		</td>
		<td>
		<input type="text" name="yourname" class="inputbox" size="25">
		</td>
	</tr>
	<tr>
		<td>
		<?php echo JText::_('Your E-mail:');

    ?>
		</td>
		<td>
		<input type="text" name="youremail" class="inputbox" size="25">
		</td>
	</tr>
	<tr>
		<td>
		<?php echo JText::_('Message subject:');

    ?>
		</td>
		<td>
		<input type="text" name="subject" class="inputbox" maxlength="100" size="40">
		</td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td colspan="2">
		<input type="submit" name="submit" class="button" value="<?php echo JText::_('Send e-mail');

    ?>">
		&nbsp;&nbsp; <input type="button" name="cancel" value="<?php echo JText::_('Cancel');

    ?>" class="button" onclick="window.close();">
		</td>
	</tr>
	</table>

	<input type="hidden" name="id" value="<?php echo $uid;

    ?>">
	</form>
	<?php
}

/**
* emailContentSend()
* Creates Email and send a Link
*
* @param mixed $uid
* @return
*/
function emailContentSend($uid)
{
    global $mainframe;
    global $GKB_Live_site, $mosConfig_sitename;
    global $mosConfig_mailfrom, $mosConfig_fromname;

    $_Itemid = $mainframe->getItemid($uid, 0, 0);

    $email = trim(mosGetParam($_POST, 'email', ''));
    $yourname = trim(mosGetParam($_POST, 'yourname', ''));
    $youremail = trim(mosGetParam($_POST, 'youremail', ''));
    $subject_default = _EMAIL_INFO . " $yourname";
    $subject = trim(mosGetParam($_POST, 'subject', $subject_default));
    if (!$email || !$youremail || (is_email($email) == false) || (is_email($youremail) == false)) {
        echo "<script>alert (\"" . JText::_('You must enter your valid e-mail and the valid e-mail to send to.') . "\"); window.history.go(-1);</script>";
        exit(0);
    }

    $template = '';
    $dbGKB->setQuery("SELECT template FROM #__templates_menu WHERE client_id='0' AND menuid='0'");
    $template = $dbGKB->loadResult();
    // link sent in email
    $link = JRoute::_($GKB_Live_site . '/index.php?option=com_garyscookbook&Itemid=' . $_Itemid . '&func=detail&id=' . $uid);
    // message text
    $msg = sprintf(JText::_('The following recipe from the &apos;%s&apos; website has been sent to you by %s ( %s ). You can access it at the following url: %s'), $mosConfig_sitename, $yourname, $youremail, $link);
    // mail function
    mosMail($mosConfig_mailfrom, $mosConfig_fromname, $email, $subject, $msg);

    emailSent($email, $template);
}

/**
* is_email()
*
* @param mixed $email
* @return
*/
function is_email($email)
{
    $rBool = false;
    if (preg_match("/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $email)) {
        $rBool = true;
    }
    return $rBool;
}

/**
* emailSent()
*
* @param mixed $to
* @param string $template
* @return
*/
function emailSent($to, $template = '')
{
    global $mosConfig_sitename;

    ?>
	<title><?php echo $mosConfig_sitename;

    ?></title>
	<link rel="stylesheet" href="templates/<?php echo $template;

    ?>/css/template_css.css" type="text/css" />
	<span class="contentheading"><?php echo JText::_('This item has been sent to') . " $to";

    ?></span> <br />
	<br />
	<br />
	<a href='javascript:window.close();'>
	<span class="small"><?php echo JText::_('Close Window');

    ?></span>
	</a>
	<?php
}

?>