<?php
/**
 * DocMan SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_docman extends SefExt
{
    function create(&$uri) {
        $sefConfig =& SEFConfig::getConfig();
        $database =& JFactory::getDBO();
        
        $vars = $uri->getQuery(true);
        extract($vars);

        // JF translate extension.
        $jfTranslate = $sefConfig->translateNames ? ', id' : '';

        $title = array();
        $task = isset($task) ? @$task : null;
        switch ($task)
        {
            case 'cat_view':
                {
                    $title[] = JoomSEF::_getMenuTitle($option, $task, $Itemid);
                    $title = array_merge($title, JoomSEF::_getContentTitles('category', $gid));
                    $title[] = '/';
                    $task = null;
                    break;
                }
            case 'doc_download':
            case 'doc_details':
            case 'doc_view':
                {
                    $database->setQuery("SELECT dmname, catid$jfTranslate FROM #__docman WHERE id = ".$gid);
                    $rows = $database->loadObjectList();

                    if ($database->getErrorNum()) {
                        die($database->stderr());
                    }

                    $title[] = JoomSEF::_getMenuTitle($option, $task, $Itemid);
                    if (@count($rows) > 0) {
                        $title = array_merge($title, JoomSEF::_getContentTitles('category', $rows[0]->catid));
                        $title[] = !empty($rows[0]->dmname) ? $rows[0]->dmname : $gid;
                    }
                    $title[] = '/';
                    $task = substr($task, 4);

                    break;
                }
            default:
                {
                    $title[] = JoomSEF::_getMenuTitle($option, $task);
                    $title[] = '/';
                }
        }

        // Handle nonSef variables
        $nonSefVars = array();
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
        if (isset($dir))         $nonSefVars['dir'] = $dir;
        if (isset($order))       $nonSefVars['order'] = $order;

        $newUri = JoomSEF::_sefGetLocation($uri, $title, $task, @$limit, @$limitstart, @$lang, $nonSefVars);

        return $newUri;
    }
}
?>
