<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFViewUpgrade extends JView
{
	function __construct($config = null)
	{
		parent::__construct($config);
		//$this->_addPath('template', $this->_basePath.DS.'views'.DS.'templates');
	}

	function display($tpl = null)
	{
		JToolBarHelper::title( JText::_( 'JoomSEF' ).' '.JText::_('Upgrade Manager'), 'update.png' );
		
		JToolBarHelper::back('Back', 'index.php?option=com_sef');
		
		JSubMenuHelper::addEntry('Control Panel', 'index.php?option=com_sef');
		JSubMenuHelper::addEntry('Configuration', 'index.php?option=com_sef&controller=config&task=edit');
		JSubMenuHelper::addEntry('Manage Extensions', 'index.php?option=com_sef&controller=extension');
		JSubMenuHelper::addEntry('Edit .htaccess', 'index.php?option=com_sef&controller=htaccess');
		JSubMenuHelper::addEntry('Upgrade', 'index.php?option=com_sef&task=showUpgrade', true);
		JSubMenuHelper::addEntry('Manage SEF URLs', 'index.php?option=com_sef&controller=sefurls&viewmode=3');
		JSubMenuHelper::addEntry('Manage Custom URLs', 'index.php?option=com_sef&controller=sefurls&viewmode=2');
		JSubMenuHelper::addEntry('View 404 Logs', 'index.php?option=com_sef&controller=sefurls&viewmode=1');
		JSubMenuHelper::addEntry('Manage 301 Redirects', 'index.php?option=com_sef&controller=movedurls');
		JSubMenuHelper::addEntry('Documentation', 'index.php?option=com_sef&controller=info&task=doc');
		JSubMenuHelper::addEntry('Changelog', 'index.php?option=com_sef&controller=info&task=changelog');
		JSubMenuHelper::addEntry('Support', 'index.php?option=com_sef&controller=info&task=help');

		$exts = $this->get('UpgradeExts');
		$this->assignRef('extensions', $exts);
		
		$oldVer = SEFTools::getSEFVersion();
		$this->assignRef('oldVer', $oldVer);
		
		$newVer = $this->get('newSEFVersion');
		$this->assignRef('newVer', $newVer);
		
		$urlfopen = ini_get('allow_url_fopen');
		if( !$urlfopen ) {
		    JError::raiseNotice(100, JText::_('URL fopen wrapper is not enabled, automatic upgrade from server is not supported.'));
		}

		parent::display($tpl);
	}

	function showMessage()
	{
	    JToolBarHelper::title( JText::_( 'JoomSEF' ).' '.JText::_('Upgrade Manager'), 'update.png' );
	    
	    JToolBarHelper::back('Continue', 'index.php?option=com_sef');
	    
	    $this->setLayout('message');
	    parent::display();
	}
}
