<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFViewExtensions extends JView
{
	function __construct($config = null)
	{
		parent::__construct($config);
		$this->_addPath('template', $this->_basePath.DS.'views'.DS.'templates');
	}

	function display($tpl = null)
	{
		JToolBarHelper::title( JText::_('JoomSEF Extensions Manager'), 'plugin.png' );
		
		$bar = & JToolBar::getInstance();
		JToolBarHelper::custom('installext', 'install', '', 'Install', false);
		$bar->appendButton('Confirm', 'Are you sure you want to uninstall selected extension?', 'uninstall', 'Uninstall', 'uninstallext', true, false);
		JToolBarHelper::editList('editext');
		JToolBarHelper::spacer();
		JToolBarHelper::back('Back', 'index.php?option=com_sef');
		
		JSubMenuHelper::addEntry('Control Panel', 'index.php?option=com_sef');
		JSubMenuHelper::addEntry('Configuration', 'index.php?option=com_sef&controller=config&task=edit');
		JSubMenuHelper::addEntry('Manage Extensions', 'index.php?option=com_sef&controller=extension', true);
		JSubMenuHelper::addEntry('Edit .htaccess', 'index.php?option=com_sef&controller=htaccess');
		JSubMenuHelper::addEntry('Upgrade', 'index.php?option=com_sef&task=showUpgrade');
		JSubMenuHelper::addEntry('Manage SEF URLs', 'index.php?option=com_sef&controller=sefurls&viewmode=3');
		JSubMenuHelper::addEntry('Manage Custom URLs', 'index.php?option=com_sef&controller=sefurls&viewmode=2');
		JSubMenuHelper::addEntry('View 404 Logs', 'index.php?option=com_sef&controller=sefurls&viewmode=1');
		JSubMenuHelper::addEntry('Manage 301 Redirects', 'index.php?option=com_sef&controller=movedurls');
		JSubMenuHelper::addEntry('Documentation', 'index.php?option=com_sef&controller=info&task=doc');
		JSubMenuHelper::addEntry('Changelog', 'index.php?option=com_sef&controller=info&task=changelog');
		JSubMenuHelper::addEntry('Support', 'index.php?option=com_sef&controller=info&task=help');

		$exts = $this->get('extensions', 'extensions');
		$this->assignRef('extensions', $exts);
        
        JHTML::_('behavior.tooltip');
        
		parent::display($tpl);
	}

}
