<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFViewInfo extends JView
{

	function display($tpl = null)
	{
		$task = JRequest::getVar('task');
	
		if ($task == 'help') {
		    $title = 'JoomSEF Support';
		    $icon = 'help.png';
		}
		elseif ($task == 'doc') {
		    $title = 'JoomSEF Documentation';
		    $icon = 'docs.png';
		}
		elseif ($task == 'changelog') {
		    $title = 'JoomSEF Changelog';
		    $icon = 'info.png';
		}
		else {
		    $title = 'JoomSEF';
		    $icon = 'artio.png';
		}
		
		JToolBarHelper::title(JText::_($title), $icon);		
		JToolBarHelper::back(JText::_('Back'), 'index.php?option=com_sef');
		
		JSubMenuHelper::addEntry('Control Panel', 'index.php?option=com_sef');
		JSubMenuHelper::addEntry('Configuration', 'index.php?option=com_sef&controller=config&task=edit');
		JSubMenuHelper::addEntry('Manage Extensions', 'index.php?option=com_sef&controller=extension');
		JSubMenuHelper::addEntry('Edit .htaccess', 'index.php?option=com_sef&controller=htaccess');
		JSubMenuHelper::addEntry('Upgrade', 'index.php?option=com_sef&task=showUpgrade');
		JSubMenuHelper::addEntry('Manage SEF URLs', 'index.php?option=com_sef&controller=sefurls&viewmode=3');
		JSubMenuHelper::addEntry('Manage Custom URLs', 'index.php?option=com_sef&controller=sefurls&viewmode=2');
		JSubMenuHelper::addEntry('View 404 Logs', 'index.php?option=com_sef&controller=sefurls&viewmode=1');
		JSubMenuHelper::addEntry('Manage 301 Redirects', 'index.php?option=com_sef&controller=movedurls');
		JSubMenuHelper::addEntry('Documentation', 'index.php?option=com_sef&controller=info&task=doc', ($task == 'doc'));
		JSubMenuHelper::addEntry('Changelog', 'index.php?option=com_sef&controller=info&task=changelog', ($task == 'changelog'));
		JSubMenuHelper::addEntry('Support', 'index.php?option=com_sef&controller=info&task=help', ($task == 'help'));
		
		parent::display($tpl);
	}

}
