<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * The Rewriter handles outgoing URL rewriting (sefRelToAbs).
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

@define( '_SEF_REWRITER', 'sefRewriter' );

/**
 * Rewriter class
 *
 */
class sefRewriter extends sefObject {

    /**
   * function sefrewriter
   *
   * @param object $db the database connection object
   * @param object $config an instance of JosOpenSEFConfig
   * @param object $site an instance of JosOpenSEFSite
   * @return sefRewriter
   */
    function sefRewriter( &$db, &$config, &$site ) {
        $this->sefObject( $db, $config, $site );
        $this->ignore = array(
        'option=login',
        'option=logout',
        'option=com_jce',
        'task=new',
        'task=edit',
        'task=saveUserEdit',
        'addreview'
        );
        $this->cache = array();
    }

    /**
   * rewrite
   *
   * @param string $string
   * @return string
   */
    function rewrite( $string ) {
        //var_dump('REWRITE: '.$string);
        $anchor = '';
        if(strstr($string,'#')){
            $tmp = explode('#',$string);
            $string = $tmp[0];
            $anchor = $tmp[1];
        }
        if (!($string = $this->normalize( $string ))){
            return $string;
        }
        if (!empty( $this->config->cache_outgoing )) {
            if (array_key_exists( $string, $this->cache )) {
                if(empty($anchor)){
                    $url = $this->cache[$string];
                } else{
                    $url = $this->cache[$string]."#".$anchor;
                }
                return $url;
            } else {
                $url = $this->rewriteNoCache( $string );
                $this->cache[$string] = $url;
                if(empty($anchor)){
                    return $url;
                } else{
                    return $url."#".$anchor;
                }
            }
        }
        if(empty($anchor)){
            return $this->rewriteNoCache( $string );
        } else{
            return $this->rewriteNoCache( $string )."#".$anchor;
        }
        return $this->rewriteNoCache( $string );
    }


    /**
   * strip &amp;
   *
   * @param string $url
   * @return string
   */
    function normalize( $url ) {
        // if begins with live_site, strip it off
        // if begins with index.php without trailing slash, add slash
        $url = str_replace( '&amp;', '&', $url );
        return $url;
    }

    /**
   * rewrite directly
   *
   * @param string $url
   * @return string
   */
    function rewriteNoCache( $url ) {
        global $database, $sefConfig, $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_lang;

        if ($url == 'index.php') {
            if(!empty($this->site->base_url)){
                return $this->site->base_url . '/';
            } else {
                return $url;
            }
        }
        // Refuse to process URLs that wouldn't work anyway; see reserved list.
        if (is_array( $this->ignore )) {
            foreach ($this->ignore as $pattern) {
                if (eregi( $pattern, $url ))
                return $url;
            }
        }

        // ARTIO: added lang addition
        if (class_exists('JoomFish') && !eregi('lang=', $url)) {
            $url .= '&lang='.getLangCode($mosConfig_lang);
        }

        $alias = JosOpenSEFAlias::lookupOutgoing( $this->site->id, $url );
        if ($alias != null && !empty( $alias->published ) && $alias->external != '' ) {
            $url = $alias->external;
            if ($url[0] == '/') $url = substr($url, 1);
        } else {
            $component = null;
            if (ereg( '[\?&]+option=com_([0-9a-zA-Z_\-]+)&', $url, $matches ))
            $component = $matches[1];
            $menu_id = 0;

            if (ereg( '&Itemid=([0-9]+)', $url, $matches )) {
                $menu_id = $matches[1];
            }
            $query = "SELECT id FROM #__menu WHERE link = 'index.php?option=com_".$component."'";
            $database->setQuery($query);
            $temp_id = $database->loadResult();
            if ( ( $temp_id != 1 ) && ( $temp_id != 99999999 ) && ( $temp_id != '' ) && ( $component != 'frontpage' ))
            $menu_id = $temp_id;

            //var_dump('CCC: '.$component);
            switch ($component) {

                case 'frontpage':
                    // ARTIO: lang condition added and modified
                    if (!eregi("&limit=", $url)){
                        $c = JosOpenSEFComponent::lookup( $this->site->id, $menu_id, 'com_frontpage' );
                        $lang = eregi("&lang=([a-zA-Z_-]+)", $url, $reg) ? $reg[1] : '';
                        //if (!is_object( $c ) && empty( $c->alias )) {
                            //$lang = !eregi("lang=", $this->site->base_url) ? '?lang='.$lang : '';
                            return $this->site->base_url . '/';  //. $lang;
                        //} else {
                        //    $lang = $lang.'/';
                        //    return $lang . $c->alias . '/';
                        //}
                    }
                    else {
                        $url = str_replace( '2&limit=', '1&limit=', $url );
                    }

                case 'content':
                    $url = sefRewriteToJoomlaSEF( $url );
                    break;

                case 'weblinks':
                    $url = sefRewriteToJoomlaSEF( $url );
                    break;
                case 'newsfeeds':
                    $url = sefRewriteToJoomlaSEF( $url );
                    break;
                case 'wrapper':
                    $url = sefRewriteToJoomlaSEF( $url );
                    break;
                case 'banner':
                    $url = sefRewriteToJoomlaSEF( $url );
                    break;
                case '':
                    break;

                case 'registration':
                    // TODO: special support.

                case 'profiler':

                case 'phpshop':
                    // TODO: This needs some work as the URLs are pretty borked.
                    // Need to file bug reports with the component's maintainer.

                default:
                    $c = JosOpenSEFComponent::lookup( $this->site->id, $menu_id, 'com_' . $component );
                    if (is_object( $c ) && !empty( $c->alias ) && $c->block != '1') {
                        $path = $c->alias . '/';
                        if ($this->config->use_sef_ext == "1" ){
                            sefLoadExtension( $component );
                            if ($component=="poll"){
                                $class = 'sef_onfly_poll';
                            }
                            else if ($component=="contact"){
                                $class = 'sef_onfly_contact';
                            } else {
                                $class = 'sef_' . $component;
                            }
                            if (class_exists( $class ) && is_callable( array($class, 'create') )) {
                                $url = str_replace( '&', '&amp;', $url );
                                $sef_ext = new $class();
                                // ARTIO: added path param
                                $url = $sef_ext->create($url, $path);
                                $url = $path . $url;
                            }
                            else if (!empty( $GLOBALS['mosConfig_sef'] )) {
                                $url = sefRewriteToJoomlaSEF( $url, $path );
                            }
                        }
                    }
                    else if (!empty( $GLOBALS['mosConfig_sef'] )) {
                        $url = sefRewriteToJoomlaSEF( $url );
                    }
                    break;
            }
        }

        if (!empty( $this->config->xhtml_compliance )) {
            // This breaks links sent with Joomla's e-mailing, but XHTML
            // freaks may want it anyway.
            $url = str_replace( '&', '&amp;', $url );
        }
        $url = $this->site->base_url . '/' . $url;
        //$url = str_replace( '//', '/', $url ); // Just in case.
        if (!empty( $this->config->use_absolute_urls )) {
            $info = parse_url( $GLOBALS['mosConfig_live_site'] );
            $url = $info['scheme'] . '://' .
            (!empty( $this->site->host ) ? $this->site->host : $info['host']) . $url;
        }
        if (!empty( $this->config->use_session_fix )) {
            // TODO: .../sid,xyz/ -> ...?sid=xyz
        }
        return $url;
    }
}
?>