<?php

/**
 * @version     $Id$
 * @package     ARTIO Booking
 * @subpackage  models
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

class BookingModelPeriodDaily extends BookingModelPeriod
{

    protected $week;

    protected function _calculate()
    {
        $firstWeekDay = $this->config->firstDaySunday ? 7 : 1;
        while (!$this->isEnd()) {
            $dayWeekNum = $this->day->format('N');
            if ($firstWeekDay == $dayWeekNum && $this->week !== null) {
                $this->week++;
            }
            if ($this->week === null || $this->week % $this->item->period_recurrence == 0) {
                if ($dayWeekNum == 1 && $this->item->period_monday) {
                    $this->add();
                } elseif ($dayWeekNum == 2 && $this->item->period_tuesday) {
                    $this->add();
                } elseif ($dayWeekNum == 3 && $this->item->period_wednesday) {
                    $this->add();
                } elseif ($dayWeekNum == 4 && $this->item->period_thursday) {
                    $this->add();
                } elseif ($dayWeekNum == 5 && $this->item->period_friday) {
                    $this->add();
                } elseif ($dayWeekNum == 6 && $this->item->period_saturday) {
                    $this->add();
                } elseif ($dayWeekNum == 7 && $this->item->period_sunday) {
                    $this->add();
                }
            }
            $this->day->modify('next day');
        }
    }

    protected function add()
    {
        parent::add();
        if ($this->week === null) {
            $this->week = 0;
        }
    }
}