<?php

/**
 * Data object defines calendar day time box.
 *
 * @version        $Id$
 * @package        ARTIO JoomLIB
 * @subpackage  objects
 * @copyright    Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author        ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class BookingTimeBox
{
    var $engaged = false;
    var $date = '';
    var $fromFloat = '';
    var $fromTime = '';
    var $fromDate = '';
    var $fromUts = '';
    var $fromDisplay = '';
    var $toFloat = '';
    var $toTime = '';
    var $toDate = '';
    var $toUts = '';
    var $toDisplay = '';
    var $services = array();
    var $rtype = '';
    var $price = '';
    var $deposit = '';
    var $haveDailyService = '';
    var $closed = false;
    var $closingDayTitle = '';
    var $closignDayText = '';
    var $closignDayColor = '';
    var $closignDayShow = '';

    /**
     * Check if the box is closed by some closing day.
     *
     * @param BookingModelClosingday[] $closingDays
     * @param BookingDay $day
     * @return BookingTimeBox
     */
    public function checkClosing($closingDays, $day)
    {
        foreach ($closingDays as $closingDay) {
            if ($closingDay->date_up <= $day->date && $closingDay->date_down >= $day->date && ($this->rtype == RESERVATION_TYPE_DAILY || ($closingDay->tUp < $this->toTime && $closingDay->tDown > $this->fromTime)) && $closingDay->{$day->weekDayString}) {
                $this->closed = true;
                $this->closingDayTitle = $closingDay->title;
                $this->closignDayText = $closingDay->text;
                $this->closignDayColor = $closingDay->color;
                $this->closignDayShow = $closingDay->show;
                break;
            }
        }
        return $this;
    }
}