/**
 * Javascript for list subject form
 *
 * @package     ARTIO Booking
 * @subpackage  assets
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

var ListSubjects = {

    subject_id: 'subject_id',
    subject_name: 'subject_name',
    subject_title: 'subject_title',

    /**
     * Set template from param when create new subject
     *
     * @param element
     *            templates select box
     */
    setTemplate: function (element) {
        document.adminForm.template.value = element.value;
    },

    /**
     * Select subject from element window.
     *
     * @param id
     * @param name
     * @return false to disable page submit
     */
    select: function (id, name, alias, input) {
        if (input) {
            this.subject_id = input;
        }

        if (window.parent.document.getElementById(this.subject_id))
            window.parent.document.getElementById(this.subject_id).value = id;
        if (window.parent.document.getElementById(this.subject_name))
            window.parent.document.getElementById(this.subject_name).value = name;
        if (window.parent.document.getElementById(this.subject_title))
            window.parent.document.getElementById(this.subject_title).value = name;

        window.parent.SqueezeBox.close();

        return false;
    },

    reset: function () {
        if (document.getElementById(this.subject_id))
            document.getElementById(this.subject_id).value = '';
        if (document.getElementById(this.subject_title))
            document.getElementById(this.subject_title).value = '';
        if (document.getElementById(this.subject_name))
            document.getElementById(this.subject_name).value = '';
    }
}