<?php

/**
 * Monthly calendar template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */



$config = AFactory::getConfig();

$this->manager = $this->getLayout() == 'manager';

//$userCanReserve = $this->customer->id || $config->unRegisteregCanReserve;
$userCanReserve = $this->userCanReserve;
$this->setting = new BookingCalendarSetting();

//get number of shown months from template
if(empty($this->calendarnummonths))
{
	if(isset($this->templateTable->numberOfMonths) && $this->templateTable->numberOfMonths)
		$calMonths = $this->templateTable->numberOfMonths;
	else
		$calMonths = $config->calendarNumMonths;
	
}
else $calMonths = $this->calendarnummonths;
$calendarnummonths = $calMonths; // in the back-end admin has tool to change # of showed months

$this->days = BookingHelper::getMonthlyCalendar($this->subject, $this->setting, $calendarnummonths, $this->isAdmin, $this->lists['rids']);

ADocument::addDomreadyEvent('
Calendars.currentYear = "' . $this->setting->currentYear . '";
Calendars.currentMonth = "' . $this->setting->currentMonth . '";
Calendars.nextYear = "' . $this->setting->nextYear . '";
Calendars.nextMonth = "' . $this->setting->nextMonth . '";
Calendars.calendarType = "monthly";
');

//load csss colors for prices
//-----------------------
$colors = array();
foreach($this->days->prices as $prices)
{
	foreach($prices->prices as $priceIndex => $price)
	{
		$colors[$priceIndex] = $price->custom_color;
	}
}
$string = '';
foreach($colors as $priceIndex => $color)
{
	$string .= "#bookSetting .price".$priceIndex." {	background-color: ".$color.";} ";
}

$titleMakeReservation = JText::_('MAKE_S_RESERVATION_FOR_FULL_DAY_S_FOR_PRICE_S');
/* @var $titleMakeReservation string save translation into property for optimizing */
?>
<div id="bookingCalendar">
<!--AJAX_bookingCalendar-->
<style type="text/css"><?php echo $string; ?></style>
<?php
if ($config->buttonPosition == 0 && !$this->manager) echo $this->loadTemplate('bookitform');
?>
<div class="clr"></div>
<?php
if (!$this->manager)
    echo $this->loadTemplate('prices');  

if (!$this->isAdmin && $config->quickNavigator) { // customer has navigation in predefined length only
?>
	<div class="clr"></div>
	<div class="quickNavigator">
		<label for="imonth"><?php echo JText::_('SELECT_MONTH'); ?>: </label>
		<?php echo AHtml::getMonthsSelect('imonth', (int) $this->setting->lastMonth, $this->setting->lastYear, $config->calendarDeepMonth, 'onchange="Calendars.monthNavigation(this.value)"'); ?>
	</div>
<?php 
}
if ($this->subject->night_booking && $this->subject->night_booking_from_any) { 
?>    
	<label><?php echo JText::_('CHECK_IN_TIME'); ?>: </label>
    <?php echo implode(' : ', $this->getTimeSelector());
}

if ($this->isAdmin) { // admin has unlimited month and year navigation
?> 
	<div class="clr"></div>
	<div class="quickNavigator">
        <div class="pull-left">
		    <label for="imonth"><?php echo JText::_('SELECT_MONTH'); ?></label>
		    <?php echo AHtml::monthYearPicker('imonth', $this->setting->lastMonth . '-' . $this->setting->lastYear); ?>
        </div>
        <div class="pull-right">
		    <label for="calendarnummonths"><?php echo JText::_('NUMBER_OF_MONTHS'); ?></label>
            <span class="input-append">
		        <input type="number" name="calendarnummonths" id="calendarnummonths" value="<?php echo $this->calendarnummonths; ?>" size="1" class="input-mini" />
		        <button class="btn">
                    <span class="icon-clock"></span>
                    <?php echo JText::_('SUBMIT'); ?>
                </button>
            </span>
        </div>
        <div class="clr"></div>
	</div>
<?php }
$monthNumber = 1; ?>
<div<?php if (false && $monthNumber++ < $this->setting->monthNumber) { ?> class="monthlyCalendarHidden"<?php } ?>>
<h2 class="subjectSubtitle calendarTitle"><?php echo ($this->setting->monthName . ' ' . $this->setting->lastYear); ?></h2>
<table id="top" class="monthlyCalendar">
	<!-- Days names header -->
	<?php
		ob_start(); 
		if ($this->subject->night_booking && $config->nightsStyle) { 
	?>
	<thead>
		<tr>
                        <?php if ($config->showWeekNumbers) { ?>
                                <th><?php echo JText::_('WEEK'); ?></th>
                        <?php } ?>
			<?php if ($config->firstDaySunday) { ?>
                <th width="14%"<?php if (!in_array(7, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('SUN_TO_MON'); ?></th>
			<?php } ?>
			<th width="14%"<?php if (!in_array(1, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('MON_TO_TUE'); ?></th>
			<th width="14%"<?php if (!in_array(2, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('TUE_TO_WED'); ?></th>
			<th width="14%"<?php if (!in_array(3, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('WED_TO_THU'); ?></th>
			<th width="14%"<?php if (!in_array(4, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('THU_TO_FRI'); ?></th>
			<th width="14%"<?php if (!in_array(5, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('FRI_TO_SAT'); ?></th>
			<th width="14%"<?php if (!in_array(6, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('SAT_TO_SUN'); ?></th>
			<?php if (! $config->firstDaySunday) { ?>
				<th width="14%"<?php if (!in_array(7, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('SUN_TO_MON'); ?></th>
			<?php } ?>
		</tr>
	</thead>
	<?php } else { ?>
	<thead>
		<tr>
                        <?php if ($config->showWeekNumbers) { ?>
                                <th><?php echo JText::_('WEEK'); ?></th>
                        <?php } ?>
			<?php if ($config->firstDaySunday) { ?>
				<th width="14%"<?php if (!in_array(7, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Sun'); ?></th>
			<?php } ?>
			<th width="14%"<?php if (!in_array(1, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('MON'); ?></th>
			<th width="14%"<?php if (!in_array(2, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Tue'); ?></th>
			<th width="14%"<?php if (!in_array(3, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Wed'); ?></th>
			<th width="14%"<?php if (!in_array(4, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Thu'); ?></th>
			<th width="14%"<?php if (!in_array(5, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Fri'); ?></th>
			<th width="14%"<?php if (!in_array(6, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Sat'); ?></th>
			<?php if (! $config->firstDaySunday) { ?>
				<th width="14%"<?php if (!in_array(7, $config->daysInMonthLayout)) { ?> class="hidden"<?php } ?>><?php echo JText::_('Sun'); ?></th>
			<?php } ?>
		</tr>
	</thead>
	<?php 
		} 
		$head = ob_get_clean(); // save for next using
		echo $head;
	?>
	<!-- Body with months days -->
	<tbody>
	<tr>
                    <?php if ($config->showWeekNumbers) { ?>
			<td class="week">
				<span class="week"><?php echo $this->setting->week; ?></span>
				<?php if ($config->enableResponsive) { ?>
					<span class="month"></span>
				<?php } ?>
			</td>
                    <?php } ?>
		<?php 
            $this->showDate = true;
			$this->break = 0;
			$this->month = 1;
			$this->daysCount = count($this->days->calendar);
            for ($this->dayIndex = 0; $this->dayIndex < $this->daysCount; $this->dayIndex++) {
                $this->day = $this->days->calendar[$this->dayIndex];
                
                echo $this->loadTemplate('calendar_monthly_day');
                if (date('m', strtotime($this->day->date)) != date('m', strtotime($this->day->nextDate)) && $this->dayIndex > 6) {
					$lastMonthDay = $this->dayIndex % 7;
					$this->break++; // last day in month
				}
		 
				if ($this->dayIndex % 7 == 6 && $this->daysCount > $this->dayIndex + 1) { // end of week and next week is coming
					$this->isLastWeek = $this->daysCount - $this->dayIndex == 8;
		?>
					</tr>
		<?php
                                        $week = intval(AHtml::date($this->day->nextDate, 'W'));
					if ($this->break == 1) { // last of month hapened
						if ($lastMonthDay != 6) { // not last week day, week continues in next month
							$this->dayIndex -= 7; // repeat last week with start of next month
                                                        $week = intval(AHtml::date($this->day->date, 'W'));
							$this->break = -1; // set as -1 to ignore next step (repeating of end of this month in next month)
						} else {
							$this->break = 0;
                        }
						$nextMonth = JFactory::getDate($this->setting->selected . '-01' . ' + ' . ($this->month++) . ' month');
						/* @var $nextMonth JDate */
		?>
						</table>
						</div>
						<div<?php if (false && $monthNumber++ < $this->setting->monthNumber) { ?> class="monthlyCalendarHidden"<?php } ?>>
						<h2 class="subjectSubtitle calendarTitle"><?php echo ($nextMonth->format('F') . ' ' . $nextMonth->format('Y')); ?></h2>
						<table class="monthlyCalendar">
		<?php
							echo $head;				
					}
		?>
					<tr>
                                                <?php if ($config->showWeekNumbers) { ?>
							<td class="week">
								<span class="week"><?php echo $week; ?></span>
								<?php if ($config->enableResponsive) { ?>
									<span class="month"></span>
								<?php } ?>
							</td>
                                                <?php } ?>
		<?php 
				}
			} 
		?>
	</tr>
	</tbody>
</table>
</div>
<!-- Calendar pagination -->
<div class="calendarPagination">
	<?php if (! $this->setting->onCurrentMonth || $this->isAdmin) { // admin can browse to the past, customer can browse to the future only ?>
		<span class="previousPage"> 
			<a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->previousMonth; ?>,<?php echo $this->setting->previousYear; ?>)"><?php echo JText::_('PREVIOUS_MONTH'); ?></a>
		</span>
	<?php } ?>
	<span class="currentPage"> 
		<a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->currentMonth; ?>,<?php echo $this->setting->currentYear; ?>)"><?php echo JText::_('CURRENT_MONTH'); ?></a>
	</span> 
	<?php if (! $this->setting->lastAllowPage) { ?>
		<span class="nextPage"> 
			<a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->nearMonth; ?>,<?php echo $this->setting->nearYear; ?>)"><?php echo JText::_('NEXT_MONTH'); ?></a> 
		</span>
	<?php } ?>
</div>
<?php
	if ($config->buttonPosition == 1) echo $this->loadTemplate('bookitform');
?>
<!--/AJAX_bookingCalendar-->
</div>
<!--
AJAX_EVAL_BEGIN
	<?php if (!empty($this->commands))
		echo implode(PHP_EOL, (array) $this->commands); ?>
AJAX_EVAL_END
-->