<?php
/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

/*
 * Template's properties have since 1.3.8 option display.
 * This option allows to display property on frontend.
 * Because in previous versions were all properties automatically displayed on frontend
 * we have to set in existing templates all properties display on.
 */

// 1. load all existing templates
$db = JFactory::getDbo();
$db->setQuery('SELECT id, xml FROM #__booking_template');
$tmpls = $db->loadObjectList();

foreach ($tmpls as $tmpl) {
    // 2. load template XML
    $parser = JFactory::getXMLParser('Simple');
    /* @var $parser JSimpleXML */
    if ($parser->loadString($tmpl->xml)) {
        $root = $parser->document;
        /* @var $root JSimpleXMLElement */
        $params = $root->getElementByPath('params');
        /* @var $params JSimpleXMLElement */
        foreach ($params->children() as $param) {
            /* @var $param JSimpleXMLElement */
            // 3. set for each property display=1
            $param->addAttribute('display', 1);
        }
        // 4. update template XML
        $db->setQuery('UPDATE #__booking_template SET xml = ' . $db->quote($root->toString()) . ' WHERE id = ' . $tmpl->id);
        $db->query();
    }
}
?>