<?php
/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

$db = JFactory::getDbo();

$db->setQuery("
ALTER TABLE `#__booking_reservation` ADD `company_id` VARCHAR( 20 ) NOT NULL AFTER `company` ,
ADD `vat_id` VARCHAR( 20 ) NOT NULL AFTER `company_id`
")->query();

$db->setQuery("
ALTER TABLE `#__booking_customer` ADD `company_id` VARCHAR( 20 ) NOT NULL AFTER `company` ,
ADD `vat_id` VARCHAR( 20 ) NOT NULL AFTER `company_id`
")->query();

$db->setQuery("
CREATE TABLE IF NOT EXISTS `#__booking_location` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`title` varchar(100) NOT NULL DEFAULT '',
`pick_up` tinyint(1) NOT NULL DEFAULT 0,
`drop_off` tinyint(1) NOT NULL DEFAULT 0,
`checked_out` int(11) NOT NULL DEFAULT '0',
`checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
PRIMARY KEY (`id`),
KEY `checked_out` (`checked_out`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
")->query();

$db->setQuery("
CREATE TABLE IF NOT EXISTS `#__booking_article` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`title` varchar(100) NOT NULL DEFAULT '',
`text` text NOT NULL,
`checked_out` int(11) NOT NULL DEFAULT '0',
`checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
PRIMARY KEY (`id`),
KEY `checked_out` (`checked_out`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
")->query();

$db->setQuery("
INSERT INTO `#__booking_article` (`id`, `title`, `text`, `checked_out`, `checked_out_time`) VALUES
(1, 'Terms of Contract', '', 0, '0000-00-00 00:00:00'),
(2, 'Terms of Privacy', '', 0, '0000-00-00 00:00:00');
")->query();

$db->setQuery("
CREATE TABLE IF NOT EXISTS `#__booking_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `mode` tinyint(4) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `checked_out` (`checked_out`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
")->query();

JTable::addIncludePath(dirname(__FILE__) . '/../admin/tables');
$email = JTable::getInstance('Email', 'Table');
/* @var $email TableEmail */

$email->id = null;
$email->subject = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_emails_subject_customer'")->loadResult();
$email->body = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_body_customer'")->loadResult();
$email->mode = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_mode'")->loadResult() == 'plain_text' ? 0 : 1;
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_registration_client', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id")->query();

$email->id = null;
$email->subject = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_emails_subject_admin'")->loadResult();
$email->body = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_body_admin'")->loadResult();
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_registration_manager', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id")->query();

$email->id = null;
$email->subject = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_emails_subject_customer'")->loadResult();
$email->body = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_body_customer'")->loadResult();
$email->mode = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_mode'")->loadResult() == 'plain_text' ? 0 : 1;
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_reservation_client', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id")->query();

$email->id = null;
$email->subject = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_emails_subject_administrator'")->loadResult();
$email->body = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_body_admin'")->loadResult();
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_reservation_manager', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id")->query();

$email->id = null;
$email->subject = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_change_status_emails_subject_customer'")->loadResult();
$email->body = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_change_status_body_customer'")->loadResult();
$email->mode = $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_change_status_mode'")->loadResult() == 'plain_text' ? 0 : 1;
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_status_client', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id")->query();

$managers = array();
foreach (explode(',', $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_emails_from'")->loadResult() . ',' . $db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_emails_from'")->loadResult()) as $manager) 
	if (JString::trim($manager))
		$managers[] = JString::trim($manager);
$managers = $db->quote(implode(',', $managers));
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_manager', $managers) ON DUPLICATE KEY UPDATE `value` = $managers")->query();

//add new payment payex
$db->setQuery("INSERT INTO `#__booking_payment` (`id`, `title`, `alias`, `state`, `params`, `checked_out`, `checked_out_time`) VALUES
(9, 'PayEx', 'payex', 0, '', 0, '0000-00-00 00:00:00') ON DUPLICATE KEY UPDATE `id` = 9")->query();

$db->setQuery("
ALTER TABLE `#__booking_payment` ADD `asset_id` int(11) DEFAULT NULL
")->query();

