<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';
$db = JFactory::getDbo();
$db->setQuery('ALTER TABLE #__booking_reservation_type CHANGE fix_from fix_from TEXT')->query();
$count = $db->setQuery('SELECT COUNT(*) FROM #__booking_reservation_type')->loadResult();
for ($i = 0; $i < $count; $i += 100) {
	$types = $db->setQuery('SELECT id, fix_from FROM #__booking_reservation_type', $i, 100)->loadObjectList();
	foreach ($types as $type) {
		$type->fix_from = $type->fix_from == 'any' ? serialize(array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun')) : serialize(array($type->fix_from));
		$db->setQuery('UPDATE #__booking_reservation_type SET fix_from = ' . $db->quote($type->fix_from) . ' WHERE id = ' . $type->id)->query();
	}
}

// vice versa marks {CHECK_IN} x {CHECK_OUT} in PDF ticket template
$this->_addSQL("UPDATE #__booking_subject SET pdf_ticket_template = REPLACE(pdf_ticket_template, '{CHECK_IN}', 'X-X-X-X-X')");
$this->_addSQL("UPDATE #__booking_subject SET pdf_ticket_template = REPLACE(pdf_ticket_template, '{CHECK_OUT}', '{CHECK_IN}')");
$this->_addSQL("UPDATE #__booking_subject SET pdf_ticket_template = REPLACE(pdf_ticket_template, 'X-X-X-X-X', '{CHECK_OUT}')");

// convert price color from string code into hexa code
$this->_addSQL("UPDATE #__booking_price SET custom_color = '#FF0000' WHERE custom_color = 'red'");
$this->_addSQL("UPDATE #__booking_price SET custom_color = '#00FF00' WHERE custom_color = 'green'");
$this->_addSQL("UPDATE #__booking_price SET custom_color = '#0000FF' WHERE custom_color = 'blue'");
$this->_addSQL("UPDATE #__booking_price SET custom_color = '#999999' WHERE custom_color = 'grey'");