<?php

/**
 * Customer custom field.
 * 
 * @package	ARTIO Booking
 * @subpackage  tables 
 * @copyright	Copyright (C) 2015 ARTIO Ltd. All rights reserved.
 * @author 	ARTIO Ltd., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */
defined('_JEXEC') or die('Restricted access');

class TableField extends JTable {

    public function __construct(& $db) {
        parent::__construct('#__booking_field', 'id', $db);
        $this->_jsonEncode = array('template');
        return $this;
    }

    public function truncate() {
        $this->_db->setQuery('TRUNCATE TABLE #__booking_field')->execute();
        return $this;
    }

    public function store($fields = false) {
        foreach ($fields as $field) {
            $this->bind($field);
            $this->id = null;
            parent::store();
        }
        return $this;
    }

    public function getList() {
        $items = $this->_db->setQuery('SELECT * FROM #__booking_field')->loadAssocList();
        foreach ($items as $i => $item) {
            $items[$i]['template'] = (array) json_decode($item['template']);
        }
        return $items;
    }

}
