<?php
$thisMonth = $this->setting->lastMonth + $this->month - 1;
if ($thisMonth > 12) {
    $thisMonth -= 12;
}

$firstBox = reset($this->day->boxes);
$closed = is_object($firstBox) && $firstBox->closed;

$class = 'day';
$title = $style = '';

if (!$this->manager) {
    if ($this->day->engaged) {
        $class .= ' reserved';
    }

    if ($closed) {
        $class .= ' closed hasTip';
        $title .= $this->escape($firstBox->closingDayTitle) . '::' . $this->escape($firstBox->closignDayText);
    }

    if ($closed && $firstBox->closignDayColor) {
        $style .= 'background-color: #' . $firstBox->closignDayColor;
    } else if ($this->day->engaged && $this->config->colorCalendarFieldReserved) {
        $style .= 'background-color: ' . $this->config->colorCalendarFieldReserved;
    } else if (!$closed && $this->config->colorCalendarFieldFree) {
        $style .= 'background-color: ' . $this->config->colorCalendarFieldFree;
    }
    if (!$this->day->monthVisible) {
        $class .= ' hidden';
    }
}
if (!$this->config->hideNotCorrespondingDays || (int) $this->day->month == (int) $thisMonth) {
    ?>
    <td class="<?php echo $class; ?>" style="<?php echo $style; ?>" title="<?php echo $title; ?>">
        <?php if ($this->showDate) { ?>
            <?php if ($this->config->enableResponsive) { ?>
                <span class="date"><?php echo AHtml::date($this->day->date, ADATE_FORMAT_NICE_SHORT_RESPONSIVE, 0); ?></span>
            <?php } elseif ($this->subject->night_booking && $this->config->nightsStyle) { ?>
                <span class="date" ><?php echo JText::sprintf('NIGHT_BOOKING_DATE', AHtml::date($this->day->date, ADATE_FORMAT_NICE_SHORT, 0), AHtml::date($this->day->nextDate, ADATE_FORMAT_NICE_SHORT, 0)); ?></span>
            <?php } else { ?>
                <span class="date" ><?php echo AHtml::date($this->day->date, ADATE_FORMAT_NICE_SHORT, 0); ?></span>
                <?php
            }
        }
        if (!($this->break && !$this->isLastWeek)) {
            foreach ($this->day->boxes as $box) {
                /* @var $box BookingTimeBox */
                if (!$box->closed) {
                    foreach ($box->services as $service) {
                        /* @var $service BookingService */
                        if ($service->allowFixLimit || ($service->rtype == RESERVATION_TYPE_DAILY && $service->canReserve && in_array($service->rtypeId, $this->lists['rids'])) && !$this->manager) {
                            if ($this->userCanReserve && !$service->beforeFuture) {
                                $this->commands = ADocument::setBoxParams($service, $service->i, $this->daysCount, $this->dayIndex);
                            }
                            ?>
                            <span <?php echo AHtml::getPriceBoxParams($this->day, $service, 'monthly') ?>>
                                <?php                                                            
                                if ($service->price) {
                                    echo str_replace(' ', '&nbsp;', BookingHelper::displayPrice($service->price));
                                }
                                if ($this->subject->display_capacity && $this->subject->total_capacity > 1)
                                    echo ($this->subject->total_capacity - $service->alreadyReserved);
                                ?>
                            </span>
                            <?php
                        }
                    }
                }
            }
            $this->box = $this->day;
            echo $this->loadTemplate('popup');
            if (!$this->popup && ($this->isAdmin || IS_ADMIN) && !empty($box->customerName) && !$this->manager) { // admin sees customer info always 
                foreach ($box->customerName as $info) {
                    ?>
                    <div class="clr"><span class="time"><a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_RESERVATION, $info['reservation_id'])); ?>" title="<?php echo $this->escape(JText::_('SHOW_RESERVATION')); ?>::<?php echo $info['reservation_id']; ?>" class="hasTip"><?php echo $info['name']; ?></a></span>
                        <?php
                    }
                }
                if (!$this->popup && ((!$this->isAdmin && $this->subject->display_who_reserve) || $this->manager) && isset($this->day->customerName) && count($this->day->customerName)) {
                    if ($this->config->whoReserveShowType) {
                        echo AHtml::getCustomerShow($this->day, 'monthly');
                    } else {
                        if ($this->config->whoReserveShowType && !$this->manager) // show customer name as text 
                            echo AHtml::showUserInfo($this->day->customerName, 'monthly');
                        else { // show customer name in tooltip
                            if (!$this->manager) {
                                echo AHtml::getCustomerShow($this->day, 'monthly');
                            } else {

                                $items = array(); // group reservations by item
                                foreach ($this->day->customerName as $id => $data) {
                                    $data['name'] = $data['full'];
                                    $items[$data['item']][] = $data;
                                }

                                foreach ($items as $ii => $item) { // search price color for reservation
                                    foreach ($this->days->prices as $prices) {
                                        foreach ($prices->prices as $pi => $price) {
                                            if ($price->subject == $ii) {
                                                $items[$ii][0]['color'] = $pi; // index of price color
                                                break;
                                            }
                                        }
                                    }
                                }

                                foreach ($items as $item) {
                                    if ($this->config->checkPermissions && !$this->isAdmin) {
                                        ?>
                                        <span class="hasTip price price<?php echo $item[0]['color']; ?>" title="<?php echo AHtml::showUserInfo($item, 'monthly'); ?>">&nbsp;</span>
                                        <?php
                                    } else {
                                        $cid = array_merge($item);
                                        $cid = JArrayHelper::getColumn($cid, 'reservation_id'); // get reservation ids from list
                                        if (count($cid) > 1) { // more items - show filtered reservation list    
                                            $url = ARoute::view(VIEW_RESERVATIONS, null, null, array('layout' => 'admin', 'filter_reservation-id' => implode(', ', $cid)));
                                        } else { // only item - show reservation detail
                                            $url = ARoute::view(VIEW_RESERVATION, null, null, array('cid[]' => reset($cid)));
                                        }
                                        ?>    
                                        <a href="<?php echo JRoute::_($url); ?>" class="hasTooltip price price1 price<?php echo $item[0]['color']; ?>" title="<?php echo AHtml::showUserInfo($item); ?>"> </a>
                                        <?php
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if ($closed && $firstBox->closignDayShow) {
                ?>
                <span class="closed"><?php echo $firstBox->closingDayTitle; ?></span>
            <?php }
            ?> 
    </td>
<?php } else { ?>
    <td class="day"></td>
<?php
}
