<?php
/**
 * Monthly multi calendar template.
 *
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */
defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

$items = $this->getMonthlyItems();
?>
<div id="bookingCalendar" class="monthMultiCalendar">
    <!--AJAX_bookingCalendar-->
    <?php echo $this->loadTemplate('bookitform') ?>
    <div class="clr"></div>
    <?php
    echo $this->loadTemplate('prices');
    if ($this->showMultiTabs($items)) {
        echo JHtml::_('tabsadapter.groupbegin', 'bookable-items', 'bookable-item0');
        foreach ($items as $i => $item) {
            if ($item->showInTabs) {
                $this->days = $item->days;
                $this->supplements = $item->supplements;
                echo JHtml::_('tabsadapter.tabbegin', 'bookable-items', 'bookable-item' . $i, $item->title) . $this->loadTemplate('supplements') . JHtml::_('tabsadapter.tabend');
            }
        }
        echo JHtml::_('tabsadapter.groupend');
    }
    if ($this->config->quickNavigator) {
        ?>
        <div class="clr"></div>
        <div class="quickNavigator">
            <label for="imonth"><?php echo JText::_('SELECT_MONTH'); ?>: </label>
            <?php echo AHtml::getMonthsSelect('imonth', (int) $this->setting->lastMonth, $this->setting->lastYear, $this->config->calendarDeepMonth, 'onchange="Calendars.monthNavigation(this.value)"'); ?>
        </div>
    <?php } ?>

    <div class="clr"></div>
    <table class="monthlyCalendar leftColumn">
        <thead>
            <tr>
                <th><?php echo $this->escape($this->template->name)
    ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($items as $item) {
                ?>
                <tr>
                    <td class="day"><?php echo $this->escape($item->title) ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
    <div class="monthlyCalendarContainer">
        <table class="monthlyCalendar">
            <thead>
                <tr>
                    <?php
                    foreach (reset($items)->days->calendar as $day) {
                        if (!$day->inThePast) {
                            ?>
                            <th<?php if (!$day->monthVisible || ($this->config->hideNotCorrespondingDays && $day->month != $this->setting->lastMonth)) { ?> class="hidden"<?php } ?>><?php echo AHtml::date($day->date, ADATE_FORMAT_NICE_SHORT, 0) ?></th>
                            <?php
                        }
                    }
                    ?>
                </tr>
            </thead>
            <tbody>
                <?php
                $this->showDate = false;
                foreach ($items as $item) {
                    ?>
                    <tr>
                        <?php
                        $this->daysCount = count($item->days->calendar);
                        $this->month = 1;
                        foreach ($item->days->calendar as $this->dayIndex => $this->day) {
                            if (!$this->day->inThePast) {
                                echo $this->loadTemplate('calendar_monthly_day');
                            }
                        }
                        ?>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    <!-- Calendar pagination -->
    <div class="calendarPagination">
        <?php if (!$this->setting->onCurrentMonth || $this->isAdmin) { // admin can browse to the past, customer can browse to the future only                   ?>
            <span class="previousPage"> 
                <a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->previousMonth ?>,<?php echo $this->setting->previousYear ?>)"><?php echo JText::_('PREVIOUS_MONTH') ?></a>
            </span>
        <?php } ?>
        <span class="currentPage"> 
            <a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->currentMonth ?>,<?php echo $this->setting->currentYear ?>)"><?php echo JText::_('CURRENT_MONTH') ?></a>
        </span> 
        <?php if (!$this->setting->lastAllowPage) { ?>
            <span class="nextPage"> 
                <a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->nearMonth ?>,<?php echo $this->setting->nearYear ?>)"><?php echo JText::_('NEXT_MONTH') ?></a> 
            </span>
        <?php } ?>
    </div>    
    <?php
    if ($config->buttonPosition == 1) {
        echo $this->loadTemplate('bookitform');
    }
    ?>
    <!--/AJAX_bookingCalendar-->
</div>