<?php
/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';


//this was not in the 1.5.0 install script
if($curVersion == '1.5.0')
{
	$db = JFactory::getDbo();
	
	$db->setQuery("ALTER TABLE `#__booking_reservation` ADD `book_time` DATETIME DEFAULT NULL ");
	$db->query();
	
	$db->setQuery("ALTER TABLE `#__booking_reservation_items` ADD `cancel_time` INT DEFAULT NULL ");
	$db->query();
	
	$db->setQuery("ALTER TABLE `#__booking_price` ADD `cancel_time` INT DEFAULT NULL ");
	$db->query();
	
	//select old data
	if (version_compare(JVERSION, '1.6.0') >= 0)
		$query = 'SELECT `params` FROM `#__extensions` WHERE `element` = \'' . OPTION . '\'';
	else
		$query = 'SELECT `params` FROM `#__components` WHERE `option` = \'' . OPTION . '\' AND `parent` = 0';
	$db->setQuery($query);
	$params = (string) $db->loadResult();
	$params = new JParameter($params, CONFIG);
	$arr = $params->toArray();
	
	//create new table for config data
	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__booking_config` (
			`id` INT NOT NULL AUTO_INCREMENT,
	        `key` VARCHAR(100) NOT NULL,
			`value` VARCHAR(3000),
			PRIMARY KEY (`id`),
  			UNIQUE(`key`)
	       )");
	$db->query();
	
	//insert actual config data to the new table
	foreach($arr as $key=>$val)
	{
		$db->setQuery("INSERT IGNORE INTO `#__booking_config` (`id`, `key`, `value`) VALUES ('', ".$db->Quote($key).", ".$db->Quote($val).") ");
		$db->query();
	}
}
?>
