<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

//install all extensions from package
foreach(getPackages() as $pack)
{
	installPackage($pack);
}

//from AInstaller
function getPackages()
{
	//Install payment methods
	$folder = dirname(__FILE__) . DS . '..' . DS . 'admin' . DS . 'extensions' . DS . 'payment_methods';
	foreach (JFolder::folders($folder, '.', false, true) as $package)
		$outcome[] = $package;

	//install other plugins and modules
	$folder = dirname(__FILE__) . DS . '..' . DS . 'admin' . DS . 'extensions';
	foreach (JFolder::folders($folder, '.', false, true, array('payment_methods')) as $package)
		$outcome[] = $package;

	return isset($outcome) ? $outcome : array();
}

//from AInstaller
function installPackage($package)
{
	$installer = new JInstaller();
	$db = JFactory::getDBO();

	//override existing
	$installer->setOverwrite(true);

	if ($installer->install($package)) {
		if (is_object(($extension = AInstaller::loadExtension($package)))) {
			$extType = $extension->extType;
			unset($extension->extType);
			$succes = $extension->store();
			$mainframe = JFactory::getApplication();
				
			return array('title' => AInstaller::getExtensionTitle($extension) , 'extType' => $extType , 'outcome' => true);
		}
	}
	return false;
}

$this->_addSql("UPDATE #__extensions AS e
                JOIN #__booking_payment AS p ON e.element = p.alias
                SET e.params = p.params, e.enabled = p.state
                WHERE e.folder = 'bookingpayment'");

//every price can has specified discounts for number of persons in object (hotel, etc)
$this->_addSql('ALTER TABLE `#__booking_price` ADD `adult_occupancy_price` text NOT NULL');
$this->_addSql('ALTER TABLE `#__booking_price` ADD `child_occupancy_price` text NOT NULL');

//number of persons in the object (hotel)
$this->_addSql('ALTER TABLE `#__booking_reservation_items` ADD `adult_occupancy` int(11) NOT NULL DEFAULT \'0\'');
$this->_addSql('ALTER TABLE `#__booking_reservation_items` ADD `child_occupancy` int(11) NOT NULL DEFAULT \'0\'');

//max number of persons in the object (hotel)
$this->_addSql('ALTER TABLE `#__booking_subject` ADD `max_adult_occupancy` int(11) NOT NULL DEFAULT \'0\'');
$this->_addSql('ALTER TABLE `#__booking_subject` ADD `max_child_occupancy` int(11) NOT NULL DEFAULT \'0\'');
$this->_addSql('ALTER TABLE `#__booking_reservation_type` ADD `dynamic_gap_time` tinyint(1) NOT NULL DEFAULT 0');

$this->_addSql('ALTER TABLE `#__booking_price` ADD `time_range` TINYINT NOT NULL DEFAULT \'0\'');

$this->_addSQL('ALTER TABLE `#__booking_subject` ADD `featured` TINYINT( 1 ) NOT NULL AFTER `state` ');

$this->_addSQL('ALTER TABLE `#__booking_price` ADD `head_piece` INT NOT NULL ,
ADD `tail_piece` INT NOT NULL ');

