<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

$this->_addSQL('ALTER TABLE #__booking_subject ADD show_occupancy TINYINT(1) NOT NULL DEFAULT 1');


$db = JFactory::getDbo();


$query = $db->getQuery(true);
$query->select('name')->from('#__assets')->where('name LIKE ' . $db->quote('com_booking.subject.%'));
$assets = $db->setQuery($query)->loadColumn();


$query = $db->getQuery(true);
$query->select('id, title, parent')->from('#__booking_subject')->order('parent');
$items = $db->setQuery($query)->loadObjectList();


foreach ($items as $item) {
	if (!in_array('com_booking.subject.' . $item->id, $assets)) {

		$asset = JTable::getInstance('asset');
		/* @var $asset JTableAsset */
		$root = JTable::getInstance('asset');
		/* @var $root JTableAsset */
		
		$asset->name = 'com_booking.subject.' . $item->id;
		$asset->title = $item->title;
		
		if ($item->parent)
			$success = $root->loadByName('com_booking.subject.' . $item->parent);
		if (! $item->parent || ! $success)
			$root->loadByName('com_booking');

		$asset->setLocation($root->id, 'last-child');
		$asset->store();
	}
}